/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.serverlessapplicationrepository.transform;

import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateApplicationRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link CreateApplicationRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class CreateApplicationRequestModelMarshaller {
    private static final MarshallingInfo<String> AUTHOR_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("author").isBinary(false).build();

    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();

    private static final MarshallingInfo<List> LABELS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("labels").isBinary(false).build();

    private static final MarshallingInfo<String> LICENSEBODY_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("licenseBody").isBinary(false).build();

    private static final MarshallingInfo<String> LICENSEURL_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("licenseUrl").isBinary(false).build();

    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();

    private static final MarshallingInfo<String> READMEBODY_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("readmeBody").isBinary(false).build();

    private static final MarshallingInfo<String> READMEURL_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("readmeUrl").isBinary(false).build();

    private static final MarshallingInfo<String> SEMANTICVERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("semanticVersion").isBinary(false).build();

    private static final MarshallingInfo<String> SOURCECODEURL_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sourceCodeUrl").isBinary(false).build();

    private static final MarshallingInfo<String> SPDXLICENSEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("spdxLicenseId").isBinary(false).build();

    private static final MarshallingInfo<String> TEMPLATEBODY_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("templateBody").isBinary(false).build();

    private static final MarshallingInfo<String> TEMPLATEURL_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("templateUrl").isBinary(false).build();

    private static final CreateApplicationRequestModelMarshaller INSTANCE = new CreateApplicationRequestModelMarshaller();

    private CreateApplicationRequestModelMarshaller() {
    }

    public static CreateApplicationRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(CreateApplicationRequest createApplicationRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(createApplicationRequest, "createApplicationRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(createApplicationRequest.author(), AUTHOR_BINDING);
            protocolMarshaller.marshall(createApplicationRequest.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(createApplicationRequest.labels(), LABELS_BINDING);
            protocolMarshaller.marshall(createApplicationRequest.licenseBody(), LICENSEBODY_BINDING);
            protocolMarshaller.marshall(createApplicationRequest.licenseUrl(), LICENSEURL_BINDING);
            protocolMarshaller.marshall(createApplicationRequest.name(), NAME_BINDING);
            protocolMarshaller.marshall(createApplicationRequest.readmeBody(), READMEBODY_BINDING);
            protocolMarshaller.marshall(createApplicationRequest.readmeUrl(), READMEURL_BINDING);
            protocolMarshaller.marshall(createApplicationRequest.semanticVersion(), SEMANTICVERSION_BINDING);
            protocolMarshaller.marshall(createApplicationRequest.sourceCodeUrl(), SOURCECODEURL_BINDING);
            protocolMarshaller.marshall(createApplicationRequest.spdxLicenseId(), SPDXLICENSEID_BINDING);
            protocolMarshaller.marshall(createApplicationRequest.templateBody(), TEMPLATEBODY_BINDING);
            protocolMarshaller.marshall(createApplicationRequest.templateUrl(), TEMPLATEURL_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
