/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.serverlessapplicationrepository.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetApplicationPolicyResponse extends ServerlessApplicationRepositoryResponse implements
        ToCopyableBuilder<GetApplicationPolicyResponse.Builder, GetApplicationPolicyResponse> {
    private final List<ApplicationPolicyStatement> statements;

    private GetApplicationPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.statements = builder.statements;
    }

    /**
     * Array of policy statements applied to the application.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Array of policy statements applied to the application.
     */
    public List<ApplicationPolicyStatement> statements() {
        return statements;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statements());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApplicationPolicyResponse)) {
            return false;
        }
        GetApplicationPolicyResponse other = (GetApplicationPolicyResponse) obj;
        return Objects.equals(statements(), other.statements());
    }

    @Override
    public String toString() {
        return ToString.builder("GetApplicationPolicyResponse").add("Statements", statements()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Statements":
            return Optional.of(clazz.cast(statements()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ServerlessApplicationRepositoryResponse.Builder,
            CopyableBuilder<Builder, GetApplicationPolicyResponse> {
        /**
         * Array of policy statements applied to the application.
         * 
         * @param statements
         *        Array of policy statements applied to the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statements(Collection<ApplicationPolicyStatement> statements);

        /**
         * Array of policy statements applied to the application.
         * 
         * @param statements
         *        Array of policy statements applied to the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statements(ApplicationPolicyStatement... statements);

        /**
         * Array of policy statements applied to the application. This is a convenience that creates an instance of the
         * {@link List<ApplicationPolicyStatement>.Builder} avoiding the need to create one manually via {@link List
         * <ApplicationPolicyStatement>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ApplicationPolicyStatement>.Builder#build()} is called
         * immediately and its result is passed to {@link #statements(List<ApplicationPolicyStatement>)}.
         * 
         * @param statements
         *        a consumer that will call methods on {@link List<ApplicationPolicyStatement>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statements(List<ApplicationPolicyStatement>)
         */
        Builder statements(Consumer<ApplicationPolicyStatement.Builder>... statements);
    }

    static final class BuilderImpl extends ServerlessApplicationRepositoryResponse.BuilderImpl implements Builder {
        private List<ApplicationPolicyStatement> statements;

        private BuilderImpl() {
        }

        private BuilderImpl(GetApplicationPolicyResponse model) {
            super(model);
            statements(model.statements);
        }

        public final Collection<ApplicationPolicyStatement.Builder> getStatements() {
            return statements != null ? statements.stream().map(ApplicationPolicyStatement::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder statements(Collection<ApplicationPolicyStatement> statements) {
            this.statements = ListOfApplicationPolicyStatementCopier.copy(statements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statements(ApplicationPolicyStatement... statements) {
            statements(Arrays.asList(statements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statements(Consumer<ApplicationPolicyStatement.Builder>... statements) {
            statements(Stream.of(statements).map(c -> ApplicationPolicyStatement.builder().apply(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setStatements(Collection<ApplicationPolicyStatement.BuilderImpl> statements) {
            this.statements = ListOfApplicationPolicyStatementCopier.copyFromBuilder(statements);
        }

        @Override
        public GetApplicationPolicyResponse build() {
            return new GetApplicationPolicyResponse(this);
        }
    }
}
