/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.serverlessapplicationrepository.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Create application ChangeSet request
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateCloudFormationChangeSetRequest extends ServerlessApplicationRepositoryRequest implements
        ToCopyableBuilder<CreateCloudFormationChangeSetRequest.Builder, CreateCloudFormationChangeSetRequest> {
    private final String applicationId;

    private final List<ParameterValue> parameterOverrides;

    private final String semanticVersion;

    private final String stackName;

    private CreateCloudFormationChangeSetRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.parameterOverrides = builder.parameterOverrides;
        this.semanticVersion = builder.semanticVersion;
        this.stackName = builder.stackName;
    }

    /**
     * The id of the application to create the ChangeSet for
     * 
     * @return The id of the application to create the ChangeSet for
     */
    public String applicationId() {
        return applicationId;
    }

    /**
     * A list of parameter values for the parameters of the application.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of parameter values for the parameters of the application.
     */
    public List<ParameterValue> parameterOverrides() {
        return parameterOverrides;
    }

    /**
     * The semantic version of the application:\n\n https://semver.org/
     * 
     * @return The semantic version of the application:\n\n https://semver.org/
     */
    public String semanticVersion() {
        return semanticVersion;
    }

    /**
     * The name or the unique ID of the stack for which you are creating a change set. AWS CloudFormation generates\n
     * the change set by comparing this stack's information with the information that you submit, such as a modified\n
     * template or different parameter input values. \nConstraints: Minimum length of 1.\nPattern:
     * ([a-zA-Z][-a-zA-Z0-9]*)|(arn:\b(aws|aws-us-gov|aws-cn)\b:[-a-zA-Z0-9:/._+]*)
     * 
     * @return The name or the unique ID of the stack for which you are creating a change set. AWS CloudFormation
     *         generates\n the change set by comparing this stack's information with the information that you submit,
     *         such as a modified\n template or different parameter input values. \nConstraints: Minimum length of
     *         1.\nPattern: ([a-zA-Z][-a-zA-Z0-9]*)|(arn:\b(aws|aws-us-gov|aws-cn)\b:[-a-zA-Z0-9:/._+]*)
     */
    public String stackName() {
        return stackName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(parameterOverrides());
        hashCode = 31 * hashCode + Objects.hashCode(semanticVersion());
        hashCode = 31 * hashCode + Objects.hashCode(stackName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCloudFormationChangeSetRequest)) {
            return false;
        }
        CreateCloudFormationChangeSetRequest other = (CreateCloudFormationChangeSetRequest) obj;
        return Objects.equals(applicationId(), other.applicationId())
                && Objects.equals(parameterOverrides(), other.parameterOverrides())
                && Objects.equals(semanticVersion(), other.semanticVersion()) && Objects.equals(stackName(), other.stackName());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateCloudFormationChangeSetRequest").add("ApplicationId", applicationId())
                .add("ParameterOverrides", parameterOverrides()).add("SemanticVersion", semanticVersion())
                .add("StackName", stackName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.of(clazz.cast(applicationId()));
        case "ParameterOverrides":
            return Optional.of(clazz.cast(parameterOverrides()));
        case "SemanticVersion":
            return Optional.of(clazz.cast(semanticVersion()));
        case "StackName":
            return Optional.of(clazz.cast(stackName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ServerlessApplicationRepositoryRequest.Builder,
            CopyableBuilder<Builder, CreateCloudFormationChangeSetRequest> {
        /**
         * The id of the application to create the ChangeSet for
         * 
         * @param applicationId
         *        The id of the application to create the ChangeSet for
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * A list of parameter values for the parameters of the application.
         * 
         * @param parameterOverrides
         *        A list of parameter values for the parameters of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterOverrides(Collection<ParameterValue> parameterOverrides);

        /**
         * A list of parameter values for the parameters of the application.
         * 
         * @param parameterOverrides
         *        A list of parameter values for the parameters of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterOverrides(ParameterValue... parameterOverrides);

        /**
         * A list of parameter values for the parameters of the application. This is a convenience that creates an
         * instance of the {@link List<ParameterValue>.Builder} avoiding the need to create one manually via
         * {@link List<ParameterValue>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ParameterValue>.Builder#build()} is called immediately and
         * its result is passed to {@link #parameterOverrides(List<ParameterValue>)}.
         * 
         * @param parameterOverrides
         *        a consumer that will call methods on {@link List<ParameterValue>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameterOverrides(List<ParameterValue>)
         */
        Builder parameterOverrides(Consumer<ParameterValue.Builder>... parameterOverrides);

        /**
         * The semantic version of the application:\n\n https://semver.org/
         * 
         * @param semanticVersion
         *        The semantic version of the application:\n\n https://semver.org/
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder semanticVersion(String semanticVersion);

        /**
         * The name or the unique ID of the stack for which you are creating a change set. AWS CloudFormation
         * generates\n the change set by comparing this stack's information with the information that you submit, such
         * as a modified\n template or different parameter input values. \nConstraints: Minimum length of 1.\nPattern:
         * ([a-zA-Z][-a-zA-Z0-9]*)|(arn:\b(aws|aws-us-gov|aws-cn)\b:[-a-zA-Z0-9:/._+]*)
         * 
         * @param stackName
         *        The name or the unique ID of the stack for which you are creating a change set. AWS CloudFormation
         *        generates\n the change set by comparing this stack's information with the information that you submit,
         *        such as a modified\n template or different parameter input values. \nConstraints: Minimum length of
         *        1.\nPattern: ([a-zA-Z][-a-zA-Z0-9]*)|(arn:\b(aws|aws-us-gov|aws-cn)\b:[-a-zA-Z0-9:/._+]*)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServerlessApplicationRepositoryRequest.BuilderImpl implements Builder {
        private String applicationId;

        private List<ParameterValue> parameterOverrides;

        private String semanticVersion;

        private String stackName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCloudFormationChangeSetRequest model) {
            super(model);
            applicationId(model.applicationId);
            parameterOverrides(model.parameterOverrides);
            semanticVersion(model.semanticVersion);
            stackName(model.stackName);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final Collection<ParameterValue.Builder> getParameterOverrides() {
            return parameterOverrides != null ? parameterOverrides.stream().map(ParameterValue::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameterOverrides(Collection<ParameterValue> parameterOverrides) {
            this.parameterOverrides = ListOfParameterValueCopier.copy(parameterOverrides);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterOverrides(ParameterValue... parameterOverrides) {
            parameterOverrides(Arrays.asList(parameterOverrides));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterOverrides(Consumer<ParameterValue.Builder>... parameterOverrides) {
            parameterOverrides(Stream.of(parameterOverrides).map(c -> ParameterValue.builder().apply(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setParameterOverrides(Collection<ParameterValue.BuilderImpl> parameterOverrides) {
            this.parameterOverrides = ListOfParameterValueCopier.copyFromBuilder(parameterOverrides);
        }

        public final String getSemanticVersion() {
            return semanticVersion;
        }

        @Override
        public final Builder semanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
            return this;
        }

        public final void setSemanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
        }

        public final String getStackName() {
            return stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateCloudFormationChangeSetRequest build() {
            return new CreateCloudFormationChangeSetRequest(this);
        }
    }
}
