/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.serverlessapplicationrepository.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ServerlessApplicationRepositoryResponse;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.Version;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateApplicationResponse
extends ServerlessApplicationRepositoryResponse
implements ToCopyableBuilder<Builder, CreateApplicationResponse> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateApplicationResponse.getter(CreateApplicationResponse::applicationId)).setter(CreateApplicationResponse.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()}).build();
    private static final SdkField<String> AUTHOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateApplicationResponse.getter(CreateApplicationResponse::author)).setter(CreateApplicationResponse.setter(Builder::author)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("author").build()}).build();
    private static final SdkField<String> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateApplicationResponse.getter(CreateApplicationResponse::creationTime)).setter(CreateApplicationResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateApplicationResponse.getter(CreateApplicationResponse::description)).setter(CreateApplicationResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> HOME_PAGE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateApplicationResponse.getter(CreateApplicationResponse::homePageUrl)).setter(CreateApplicationResponse.setter(Builder::homePageUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("homePageUrl").build()}).build();
    private static final SdkField<List<String>> LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateApplicationResponse.getter(CreateApplicationResponse::labels)).setter(CreateApplicationResponse.setter(Builder::labels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("labels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LICENSE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateApplicationResponse.getter(CreateApplicationResponse::licenseUrl)).setter(CreateApplicationResponse.setter(Builder::licenseUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseUrl").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateApplicationResponse.getter(CreateApplicationResponse::name)).setter(CreateApplicationResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> README_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateApplicationResponse.getter(CreateApplicationResponse::readmeUrl)).setter(CreateApplicationResponse.setter(Builder::readmeUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readmeUrl").build()}).build();
    private static final SdkField<String> SPDX_LICENSE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateApplicationResponse.getter(CreateApplicationResponse::spdxLicenseId)).setter(CreateApplicationResponse.setter(Builder::spdxLicenseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spdxLicenseId").build()}).build();
    private static final SdkField<Version> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateApplicationResponse.getter(CreateApplicationResponse::version)).setter(CreateApplicationResponse.setter(Builder::version)).constructor(Version::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, AUTHOR_FIELD, CREATION_TIME_FIELD, DESCRIPTION_FIELD, HOME_PAGE_URL_FIELD, LABELS_FIELD, LICENSE_URL_FIELD, NAME_FIELD, README_URL_FIELD, SPDX_LICENSE_ID_FIELD, VERSION_FIELD));
    private final String applicationId;
    private final String author;
    private final String creationTime;
    private final String description;
    private final String homePageUrl;
    private final List<String> labels;
    private final String licenseUrl;
    private final String name;
    private final String readmeUrl;
    private final String spdxLicenseId;
    private final Version version;

    private CreateApplicationResponse(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.author = builder.author;
        this.creationTime = builder.creationTime;
        this.description = builder.description;
        this.homePageUrl = builder.homePageUrl;
        this.labels = builder.labels;
        this.licenseUrl = builder.licenseUrl;
        this.name = builder.name;
        this.readmeUrl = builder.readmeUrl;
        this.spdxLicenseId = builder.spdxLicenseId;
        this.version = builder.version;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public String author() {
        return this.author;
    }

    public String creationTime() {
        return this.creationTime;
    }

    public String description() {
        return this.description;
    }

    public String homePageUrl() {
        return this.homePageUrl;
    }

    public List<String> labels() {
        return this.labels;
    }

    public String licenseUrl() {
        return this.licenseUrl;
    }

    public String name() {
        return this.name;
    }

    public String readmeUrl() {
        return this.readmeUrl;
    }

    public String spdxLicenseId() {
        return this.spdxLicenseId;
    }

    public Version version() {
        return this.version;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.author());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.homePageUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.labels());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.readmeUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.spdxLicenseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationResponse)) {
            return false;
        }
        CreateApplicationResponse other = (CreateApplicationResponse)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.author(), other.author()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.homePageUrl(), other.homePageUrl()) && Objects.equals(this.labels(), other.labels()) && Objects.equals(this.licenseUrl(), other.licenseUrl()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.readmeUrl(), other.readmeUrl()) && Objects.equals(this.spdxLicenseId(), other.spdxLicenseId()) && Objects.equals(this.version(), other.version());
    }

    public String toString() {
        return ToString.builder((String)"CreateApplicationResponse").add("ApplicationId", (Object)this.applicationId()).add("Author", (Object)this.author()).add("CreationTime", (Object)this.creationTime()).add("Description", (Object)this.description()).add("HomePageUrl", (Object)this.homePageUrl()).add("Labels", this.labels()).add("LicenseUrl", (Object)this.licenseUrl()).add("Name", (Object)this.name()).add("ReadmeUrl", (Object)this.readmeUrl()).add("SpdxLicenseId", (Object)this.spdxLicenseId()).add("Version", (Object)this.version()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "Author": {
                return Optional.ofNullable(clazz.cast(this.author()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "HomePageUrl": {
                return Optional.ofNullable(clazz.cast(this.homePageUrl()));
            }
            case "Labels": {
                return Optional.ofNullable(clazz.cast(this.labels()));
            }
            case "LicenseUrl": {
                return Optional.ofNullable(clazz.cast(this.licenseUrl()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ReadmeUrl": {
                return Optional.ofNullable(clazz.cast(this.readmeUrl()));
            }
            case "SpdxLicenseId": {
                return Optional.ofNullable(clazz.cast(this.spdxLicenseId()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateApplicationResponse, T> g) {
        return obj -> g.apply((CreateApplicationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServerlessApplicationRepositoryResponse.BuilderImpl
    implements Builder {
        private String applicationId;
        private String author;
        private String creationTime;
        private String description;
        private String homePageUrl;
        private List<String> labels = DefaultSdkAutoConstructList.getInstance();
        private String licenseUrl;
        private String name;
        private String readmeUrl;
        private String spdxLicenseId;
        private Version version;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApplicationResponse model) {
            super(model);
            this.applicationId(model.applicationId);
            this.author(model.author);
            this.creationTime(model.creationTime);
            this.description(model.description);
            this.homePageUrl(model.homePageUrl);
            this.labels(model.labels);
            this.licenseUrl(model.licenseUrl);
            this.name(model.name);
            this.readmeUrl(model.readmeUrl);
            this.spdxLicenseId(model.spdxLicenseId);
            this.version(model.version);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getAuthor() {
            return this.author;
        }

        @Override
        public final Builder author(String author) {
            this.author = author;
            return this;
        }

        public final void setAuthor(String author) {
            this.author = author;
        }

        public final String getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(String creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(String creationTime) {
            this.creationTime = creationTime;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getHomePageUrl() {
            return this.homePageUrl;
        }

        @Override
        public final Builder homePageUrl(String homePageUrl) {
            this.homePageUrl = homePageUrl;
            return this;
        }

        public final void setHomePageUrl(String homePageUrl) {
            this.homePageUrl = homePageUrl;
        }

        public final Collection<String> getLabels() {
            return this.labels;
        }

        @Override
        public final Builder labels(Collection<String> labels) {
            this.labels = ___listOf__stringCopier.copy(labels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(String ... labels) {
            this.labels(Arrays.asList(labels));
            return this;
        }

        public final void setLabels(Collection<String> labels) {
            this.labels = ___listOf__stringCopier.copy(labels);
        }

        public final String getLicenseUrl() {
            return this.licenseUrl;
        }

        @Override
        public final Builder licenseUrl(String licenseUrl) {
            this.licenseUrl = licenseUrl;
            return this;
        }

        public final void setLicenseUrl(String licenseUrl) {
            this.licenseUrl = licenseUrl;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getReadmeUrl() {
            return this.readmeUrl;
        }

        @Override
        public final Builder readmeUrl(String readmeUrl) {
            this.readmeUrl = readmeUrl;
            return this;
        }

        public final void setReadmeUrl(String readmeUrl) {
            this.readmeUrl = readmeUrl;
        }

        public final String getSpdxLicenseId() {
            return this.spdxLicenseId;
        }

        @Override
        public final Builder spdxLicenseId(String spdxLicenseId) {
            this.spdxLicenseId = spdxLicenseId;
            return this;
        }

        public final void setSpdxLicenseId(String spdxLicenseId) {
            this.spdxLicenseId = spdxLicenseId;
        }

        public final Version.Builder getVersion() {
            return this.version != null ? this.version.toBuilder() : null;
        }

        @Override
        public final Builder version(Version version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Version.BuilderImpl version) {
            this.version = version != null ? version.build() : null;
        }

        @Override
        public CreateApplicationResponse build() {
            return new CreateApplicationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServerlessApplicationRepositoryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateApplicationResponse> {
        public Builder applicationId(String var1);

        public Builder author(String var1);

        public Builder creationTime(String var1);

        public Builder description(String var1);

        public Builder homePageUrl(String var1);

        public Builder labels(Collection<String> var1);

        public Builder labels(String ... var1);

        public Builder licenseUrl(String var1);

        public Builder name(String var1);

        public Builder readmeUrl(String var1);

        public Builder spdxLicenseId(String var1);

        public Builder version(Version var1);

        default public Builder version(Consumer<Version.Builder> version) {
            return this.version((Version)((Version.Builder)Version.builder().applyMutation(version)).build());
        }
    }
}

