/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.serverlessapplicationrepository.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ParameterValue;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.RollbackConfiguration;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ServerlessApplicationRepositoryRequest;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.Tag;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.___listOfParameterValueCopier;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.___listOfTagCopier;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCloudFormationChangeSetRequest
extends ServerlessApplicationRepositoryRequest
implements ToCopyableBuilder<Builder, CreateCloudFormationChangeSetRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateCloudFormationChangeSetRequest.getter(CreateCloudFormationChangeSetRequest::applicationId)).setter(CreateCloudFormationChangeSetRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()}).build();
    private static final SdkField<List<String>> CAPABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateCloudFormationChangeSetRequest.getter(CreateCloudFormationChangeSetRequest::capabilities)).setter(CreateCloudFormationChangeSetRequest.setter(Builder::capabilities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CHANGE_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateCloudFormationChangeSetRequest.getter(CreateCloudFormationChangeSetRequest::changeSetName)).setter(CreateCloudFormationChangeSetRequest.setter(Builder::changeSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changeSetName").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateCloudFormationChangeSetRequest.getter(CreateCloudFormationChangeSetRequest::clientToken)).setter(CreateCloudFormationChangeSetRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateCloudFormationChangeSetRequest.getter(CreateCloudFormationChangeSetRequest::description)).setter(CreateCloudFormationChangeSetRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<String>> NOTIFICATION_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateCloudFormationChangeSetRequest.getter(CreateCloudFormationChangeSetRequest::notificationArns)).setter(CreateCloudFormationChangeSetRequest.setter(Builder::notificationArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ParameterValue>> PARAMETER_OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateCloudFormationChangeSetRequest.getter(CreateCloudFormationChangeSetRequest::parameterOverrides)).setter(CreateCloudFormationChangeSetRequest.setter(Builder::parameterOverrides)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameterOverrides").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ParameterValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> RESOURCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateCloudFormationChangeSetRequest.getter(CreateCloudFormationChangeSetRequest::resourceTypes)).setter(CreateCloudFormationChangeSetRequest.setter(Builder::resourceTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<RollbackConfiguration> ROLLBACK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateCloudFormationChangeSetRequest.getter(CreateCloudFormationChangeSetRequest::rollbackConfiguration)).setter(CreateCloudFormationChangeSetRequest.setter(Builder::rollbackConfiguration)).constructor(RollbackConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rollbackConfiguration").build()}).build();
    private static final SdkField<String> SEMANTIC_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateCloudFormationChangeSetRequest.getter(CreateCloudFormationChangeSetRequest::semanticVersion)).setter(CreateCloudFormationChangeSetRequest.setter(Builder::semanticVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("semanticVersion").build()}).build();
    private static final SdkField<String> STACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateCloudFormationChangeSetRequest.getter(CreateCloudFormationChangeSetRequest::stackName)).setter(CreateCloudFormationChangeSetRequest.setter(Builder::stackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stackName").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateCloudFormationChangeSetRequest.getter(CreateCloudFormationChangeSetRequest::tags)).setter(CreateCloudFormationChangeSetRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TEMPLATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateCloudFormationChangeSetRequest.getter(CreateCloudFormationChangeSetRequest::templateId)).setter(CreateCloudFormationChangeSetRequest.setter(Builder::templateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, CAPABILITIES_FIELD, CHANGE_SET_NAME_FIELD, CLIENT_TOKEN_FIELD, DESCRIPTION_FIELD, NOTIFICATION_ARNS_FIELD, PARAMETER_OVERRIDES_FIELD, RESOURCE_TYPES_FIELD, ROLLBACK_CONFIGURATION_FIELD, SEMANTIC_VERSION_FIELD, STACK_NAME_FIELD, TAGS_FIELD, TEMPLATE_ID_FIELD));
    private final String applicationId;
    private final List<String> capabilities;
    private final String changeSetName;
    private final String clientToken;
    private final String description;
    private final List<String> notificationArns;
    private final List<ParameterValue> parameterOverrides;
    private final List<String> resourceTypes;
    private final RollbackConfiguration rollbackConfiguration;
    private final String semanticVersion;
    private final String stackName;
    private final List<Tag> tags;
    private final String templateId;

    private CreateCloudFormationChangeSetRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.capabilities = builder.capabilities;
        this.changeSetName = builder.changeSetName;
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.notificationArns = builder.notificationArns;
        this.parameterOverrides = builder.parameterOverrides;
        this.resourceTypes = builder.resourceTypes;
        this.rollbackConfiguration = builder.rollbackConfiguration;
        this.semanticVersion = builder.semanticVersion;
        this.stackName = builder.stackName;
        this.tags = builder.tags;
        this.templateId = builder.templateId;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public List<String> capabilities() {
        return this.capabilities;
    }

    public String changeSetName() {
        return this.changeSetName;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public String description() {
        return this.description;
    }

    public List<String> notificationArns() {
        return this.notificationArns;
    }

    public List<ParameterValue> parameterOverrides() {
        return this.parameterOverrides;
    }

    public List<String> resourceTypes() {
        return this.resourceTypes;
    }

    public RollbackConfiguration rollbackConfiguration() {
        return this.rollbackConfiguration;
    }

    public String semanticVersion() {
        return this.semanticVersion;
    }

    public String stackName() {
        return this.stackName;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public String templateId() {
        return this.templateId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.capabilities());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationArns());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterOverrides());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypes());
        hashCode = 31 * hashCode + Objects.hashCode(this.rollbackConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.semanticVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCloudFormationChangeSetRequest)) {
            return false;
        }
        CreateCloudFormationChangeSetRequest other = (CreateCloudFormationChangeSetRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.capabilities(), other.capabilities()) && Objects.equals(this.changeSetName(), other.changeSetName()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.notificationArns(), other.notificationArns()) && Objects.equals(this.parameterOverrides(), other.parameterOverrides()) && Objects.equals(this.resourceTypes(), other.resourceTypes()) && Objects.equals(this.rollbackConfiguration(), other.rollbackConfiguration()) && Objects.equals(this.semanticVersion(), other.semanticVersion()) && Objects.equals(this.stackName(), other.stackName()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.templateId(), other.templateId());
    }

    public String toString() {
        return ToString.builder((String)"CreateCloudFormationChangeSetRequest").add("ApplicationId", (Object)this.applicationId()).add("Capabilities", this.capabilities()).add("ChangeSetName", (Object)this.changeSetName()).add("ClientToken", (Object)this.clientToken()).add("Description", (Object)this.description()).add("NotificationArns", this.notificationArns()).add("ParameterOverrides", this.parameterOverrides()).add("ResourceTypes", this.resourceTypes()).add("RollbackConfiguration", (Object)this.rollbackConfiguration()).add("SemanticVersion", (Object)this.semanticVersion()).add("StackName", (Object)this.stackName()).add("Tags", this.tags()).add("TemplateId", (Object)this.templateId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "Capabilities": {
                return Optional.ofNullable(clazz.cast(this.capabilities()));
            }
            case "ChangeSetName": {
                return Optional.ofNullable(clazz.cast(this.changeSetName()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "NotificationArns": {
                return Optional.ofNullable(clazz.cast(this.notificationArns()));
            }
            case "ParameterOverrides": {
                return Optional.ofNullable(clazz.cast(this.parameterOverrides()));
            }
            case "ResourceTypes": {
                return Optional.ofNullable(clazz.cast(this.resourceTypes()));
            }
            case "RollbackConfiguration": {
                return Optional.ofNullable(clazz.cast(this.rollbackConfiguration()));
            }
            case "SemanticVersion": {
                return Optional.ofNullable(clazz.cast(this.semanticVersion()));
            }
            case "StackName": {
                return Optional.ofNullable(clazz.cast(this.stackName()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "TemplateId": {
                return Optional.ofNullable(clazz.cast(this.templateId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCloudFormationChangeSetRequest, T> g) {
        return obj -> g.apply((CreateCloudFormationChangeSetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServerlessApplicationRepositoryRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private List<String> capabilities = DefaultSdkAutoConstructList.getInstance();
        private String changeSetName;
        private String clientToken;
        private String description;
        private List<String> notificationArns = DefaultSdkAutoConstructList.getInstance();
        private List<ParameterValue> parameterOverrides = DefaultSdkAutoConstructList.getInstance();
        private List<String> resourceTypes = DefaultSdkAutoConstructList.getInstance();
        private RollbackConfiguration rollbackConfiguration;
        private String semanticVersion;
        private String stackName;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String templateId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCloudFormationChangeSetRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.capabilities(model.capabilities);
            this.changeSetName(model.changeSetName);
            this.clientToken(model.clientToken);
            this.description(model.description);
            this.notificationArns(model.notificationArns);
            this.parameterOverrides(model.parameterOverrides);
            this.resourceTypes(model.resourceTypes);
            this.rollbackConfiguration(model.rollbackConfiguration);
            this.semanticVersion(model.semanticVersion);
            this.stackName(model.stackName);
            this.tags(model.tags);
            this.templateId(model.templateId);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final Collection<String> getCapabilities() {
            return this.capabilities;
        }

        @Override
        public final Builder capabilities(Collection<String> capabilities) {
            this.capabilities = ___listOf__stringCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(String ... capabilities) {
            this.capabilities(Arrays.asList(capabilities));
            return this;
        }

        public final void setCapabilities(Collection<String> capabilities) {
            this.capabilities = ___listOf__stringCopier.copy(capabilities);
        }

        public final String getChangeSetName() {
            return this.changeSetName;
        }

        @Override
        public final Builder changeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
            return this;
        }

        public final void setChangeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<String> getNotificationArns() {
            return this.notificationArns;
        }

        @Override
        public final Builder notificationArns(Collection<String> notificationArns) {
            this.notificationArns = ___listOf__stringCopier.copy(notificationArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationArns(String ... notificationArns) {
            this.notificationArns(Arrays.asList(notificationArns));
            return this;
        }

        public final void setNotificationArns(Collection<String> notificationArns) {
            this.notificationArns = ___listOf__stringCopier.copy(notificationArns);
        }

        public final Collection<ParameterValue.Builder> getParameterOverrides() {
            return this.parameterOverrides != null ? (Collection)this.parameterOverrides.stream().map(ParameterValue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameterOverrides(Collection<ParameterValue> parameterOverrides) {
            this.parameterOverrides = ___listOfParameterValueCopier.copy(parameterOverrides);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterOverrides(ParameterValue ... parameterOverrides) {
            this.parameterOverrides(Arrays.asList(parameterOverrides));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterOverrides(Consumer<ParameterValue.Builder> ... parameterOverrides) {
            this.parameterOverrides(Stream.of(parameterOverrides).map(c -> (ParameterValue)((ParameterValue.Builder)ParameterValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setParameterOverrides(Collection<ParameterValue.BuilderImpl> parameterOverrides) {
            this.parameterOverrides = ___listOfParameterValueCopier.copyFromBuilder(parameterOverrides);
        }

        public final Collection<String> getResourceTypes() {
            return this.resourceTypes;
        }

        @Override
        public final Builder resourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ___listOf__stringCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(String ... resourceTypes) {
            this.resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ___listOf__stringCopier.copy(resourceTypes);
        }

        public final RollbackConfiguration.Builder getRollbackConfiguration() {
            return this.rollbackConfiguration != null ? this.rollbackConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder rollbackConfiguration(RollbackConfiguration rollbackConfiguration) {
            this.rollbackConfiguration = rollbackConfiguration;
            return this;
        }

        public final void setRollbackConfiguration(RollbackConfiguration.BuilderImpl rollbackConfiguration) {
            this.rollbackConfiguration = rollbackConfiguration != null ? rollbackConfiguration.build() : null;
        }

        public final String getSemanticVersion() {
            return this.semanticVersion;
        }

        @Override
        public final Builder semanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
            return this;
        }

        public final void setSemanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
        }

        public final String getStackName() {
            return this.stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = ___listOfTagCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = ___listOfTagCopier.copyFromBuilder(tags);
        }

        public final String getTemplateId() {
            return this.templateId;
        }

        @Override
        public final Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public final void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCloudFormationChangeSetRequest build() {
            return new CreateCloudFormationChangeSetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServerlessApplicationRepositoryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCloudFormationChangeSetRequest> {
        public Builder applicationId(String var1);

        public Builder capabilities(Collection<String> var1);

        public Builder capabilities(String ... var1);

        public Builder changeSetName(String var1);

        public Builder clientToken(String var1);

        public Builder description(String var1);

        public Builder notificationArns(Collection<String> var1);

        public Builder notificationArns(String ... var1);

        public Builder parameterOverrides(Collection<ParameterValue> var1);

        public Builder parameterOverrides(ParameterValue ... var1);

        public Builder parameterOverrides(Consumer<ParameterValue.Builder> ... var1);

        public Builder resourceTypes(Collection<String> var1);

        public Builder resourceTypes(String ... var1);

        public Builder rollbackConfiguration(RollbackConfiguration var1);

        default public Builder rollbackConfiguration(Consumer<RollbackConfiguration.Builder> rollbackConfiguration) {
            return this.rollbackConfiguration((RollbackConfiguration)((RollbackConfiguration.Builder)RollbackConfiguration.builder().applyMutation(rollbackConfiguration)).build());
        }

        public Builder semanticVersion(String var1);

        public Builder stackName(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder templateId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

