/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.serverlessapplicationrepository.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.serverlessapplicationrepository.ServerlessApplicationRepositoryClient;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationsRequest;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationsResponse;

public class ListApplicationsIterable
implements SdkIterable<ListApplicationsResponse> {
    private final ServerlessApplicationRepositoryClient client;
    private final ListApplicationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListApplicationsIterable(ServerlessApplicationRepositoryClient client, ListApplicationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListApplicationsResponseFetcher();
    }

    public Iterator<ListApplicationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListApplicationsIterable resume(ListApplicationsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListApplicationsIterable(this.client, (ListApplicationsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListApplicationsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListApplicationsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListApplicationsResponseFetcher
    implements SyncPageFetcher<ListApplicationsResponse> {
        private ListApplicationsResponseFetcher() {
        }

        public boolean hasNextPage(ListApplicationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListApplicationsResponse nextPage(ListApplicationsResponse previousPage) {
            if (previousPage == null) {
                return ListApplicationsIterable.this.client.listApplications(ListApplicationsIterable.this.firstRequest);
            }
            return ListApplicationsIterable.this.client.listApplications((ListApplicationsRequest)((Object)ListApplicationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

