/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.serverlessapplicationrepository.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplicationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApplicationSummary> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(ApplicationSummary.getter(ApplicationSummary::applicationId)).setter(ApplicationSummary.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()}).build();
    private static final SdkField<String> AUTHOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Author").getter(ApplicationSummary.getter(ApplicationSummary::author)).setter(ApplicationSummary.setter(Builder::author)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("author").build()}).build();
    private static final SdkField<String> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreationTime").getter(ApplicationSummary.getter(ApplicationSummary::creationTime)).setter(ApplicationSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ApplicationSummary.getter(ApplicationSummary::description)).setter(ApplicationSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> HOME_PAGE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HomePageUrl").getter(ApplicationSummary.getter(ApplicationSummary::homePageUrl)).setter(ApplicationSummary.setter(Builder::homePageUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("homePageUrl").build()}).build();
    private static final SdkField<List<String>> LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Labels").getter(ApplicationSummary.getter(ApplicationSummary::labels)).setter(ApplicationSummary.setter(Builder::labels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("labels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ApplicationSummary.getter(ApplicationSummary::name)).setter(ApplicationSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> SPDX_LICENSE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SpdxLicenseId").getter(ApplicationSummary.getter(ApplicationSummary::spdxLicenseId)).setter(ApplicationSummary.setter(Builder::spdxLicenseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spdxLicenseId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, AUTHOR_FIELD, CREATION_TIME_FIELD, DESCRIPTION_FIELD, HOME_PAGE_URL_FIELD, LABELS_FIELD, NAME_FIELD, SPDX_LICENSE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("applicationId", APPLICATION_ID_FIELD);
            this.put("author", AUTHOR_FIELD);
            this.put("creationTime", CREATION_TIME_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("homePageUrl", HOME_PAGE_URL_FIELD);
            this.put("labels", LABELS_FIELD);
            this.put("name", NAME_FIELD);
            this.put("spdxLicenseId", SPDX_LICENSE_ID_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String applicationId;
    private final String author;
    private final String creationTime;
    private final String description;
    private final String homePageUrl;
    private final List<String> labels;
    private final String name;
    private final String spdxLicenseId;

    private ApplicationSummary(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.author = builder.author;
        this.creationTime = builder.creationTime;
        this.description = builder.description;
        this.homePageUrl = builder.homePageUrl;
        this.labels = builder.labels;
        this.name = builder.name;
        this.spdxLicenseId = builder.spdxLicenseId;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String author() {
        return this.author;
    }

    public final String creationTime() {
        return this.creationTime;
    }

    public final String description() {
        return this.description;
    }

    public final String homePageUrl() {
        return this.homePageUrl;
    }

    public final boolean hasLabels() {
        return this.labels != null && !(this.labels instanceof SdkAutoConstructList);
    }

    public final List<String> labels() {
        return this.labels;
    }

    public final String name() {
        return this.name;
    }

    public final String spdxLicenseId() {
        return this.spdxLicenseId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.author());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.homePageUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLabels() ? this.labels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.spdxLicenseId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationSummary)) {
            return false;
        }
        ApplicationSummary other = (ApplicationSummary)obj;
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.author(), other.author()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.homePageUrl(), other.homePageUrl()) && this.hasLabels() == other.hasLabels() && Objects.equals(this.labels(), other.labels()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.spdxLicenseId(), other.spdxLicenseId());
    }

    public final String toString() {
        return ToString.builder((String)"ApplicationSummary").add("ApplicationId", (Object)this.applicationId()).add("Author", (Object)this.author()).add("CreationTime", (Object)this.creationTime()).add("Description", (Object)this.description()).add("HomePageUrl", (Object)this.homePageUrl()).add("Labels", this.hasLabels() ? this.labels() : null).add("Name", (Object)this.name()).add("SpdxLicenseId", (Object)this.spdxLicenseId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "Author": {
                return Optional.ofNullable(clazz.cast(this.author()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "HomePageUrl": {
                return Optional.ofNullable(clazz.cast(this.homePageUrl()));
            }
            case "Labels": {
                return Optional.ofNullable(clazz.cast(this.labels()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "SpdxLicenseId": {
                return Optional.ofNullable(clazz.cast(this.spdxLicenseId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationSummary, T> g) {
        return obj -> g.apply((ApplicationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private String author;
        private String creationTime;
        private String description;
        private String homePageUrl;
        private List<String> labels = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private String spdxLicenseId;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationSummary model) {
            this.applicationId(model.applicationId);
            this.author(model.author);
            this.creationTime(model.creationTime);
            this.description(model.description);
            this.homePageUrl(model.homePageUrl);
            this.labels(model.labels);
            this.name(model.name);
            this.spdxLicenseId(model.spdxLicenseId);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getAuthor() {
            return this.author;
        }

        public final void setAuthor(String author) {
            this.author = author;
        }

        @Override
        public final Builder author(String author) {
            this.author = author;
            return this;
        }

        public final String getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(String creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(String creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getHomePageUrl() {
            return this.homePageUrl;
        }

        public final void setHomePageUrl(String homePageUrl) {
            this.homePageUrl = homePageUrl;
        }

        @Override
        public final Builder homePageUrl(String homePageUrl) {
            this.homePageUrl = homePageUrl;
            return this;
        }

        public final Collection<String> getLabels() {
            if (this.labels instanceof SdkAutoConstructList) {
                return null;
            }
            return this.labels;
        }

        public final void setLabels(Collection<String> labels) {
            this.labels = ___listOf__stringCopier.copy(labels);
        }

        @Override
        public final Builder labels(Collection<String> labels) {
            this.labels = ___listOf__stringCopier.copy(labels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(String ... labels) {
            this.labels(Arrays.asList(labels));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSpdxLicenseId() {
            return this.spdxLicenseId;
        }

        public final void setSpdxLicenseId(String spdxLicenseId) {
            this.spdxLicenseId = spdxLicenseId;
        }

        @Override
        public final Builder spdxLicenseId(String spdxLicenseId) {
            this.spdxLicenseId = spdxLicenseId;
            return this;
        }

        public ApplicationSummary build() {
            return new ApplicationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApplicationSummary> {
        public Builder applicationId(String var1);

        public Builder author(String var1);

        public Builder creationTime(String var1);

        public Builder description(String var1);

        public Builder homePageUrl(String var1);

        public Builder labels(Collection<String> var1);

        public Builder labels(String ... var1);

        public Builder name(String var1);

        public Builder spdxLicenseId(String var1);
    }
}

