/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.serverlessapplicationrepository.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.Capability;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ParameterDefinition;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ServerlessApplicationRepositoryResponse;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.___listOfCapabilityCopier;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.___listOfParameterDefinitionCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateApplicationVersionResponse
extends ServerlessApplicationRepositoryResponse
implements ToCopyableBuilder<Builder, CreateApplicationVersionResponse> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(CreateApplicationVersionResponse.getter(CreateApplicationVersionResponse::applicationId)).setter(CreateApplicationVersionResponse.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()}).build();
    private static final SdkField<String> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreationTime").getter(CreateApplicationVersionResponse.getter(CreateApplicationVersionResponse::creationTime)).setter(CreateApplicationVersionResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<List<ParameterDefinition>> PARAMETER_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ParameterDefinitions").getter(CreateApplicationVersionResponse.getter(CreateApplicationVersionResponse::parameterDefinitions)).setter(CreateApplicationVersionResponse.setter(Builder::parameterDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameterDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ParameterDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REQUIRED_CAPABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RequiredCapabilities").getter(CreateApplicationVersionResponse.getter(CreateApplicationVersionResponse::requiredCapabilitiesAsStrings)).setter(CreateApplicationVersionResponse.setter(Builder::requiredCapabilitiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requiredCapabilities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> RESOURCES_SUPPORTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ResourcesSupported").getter(CreateApplicationVersionResponse.getter(CreateApplicationVersionResponse::resourcesSupported)).setter(CreateApplicationVersionResponse.setter(Builder::resourcesSupported)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourcesSupported").build()}).build();
    private static final SdkField<String> SEMANTIC_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SemanticVersion").getter(CreateApplicationVersionResponse.getter(CreateApplicationVersionResponse::semanticVersion)).setter(CreateApplicationVersionResponse.setter(Builder::semanticVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("semanticVersion").build()}).build();
    private static final SdkField<String> SOURCE_CODE_ARCHIVE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceCodeArchiveUrl").getter(CreateApplicationVersionResponse.getter(CreateApplicationVersionResponse::sourceCodeArchiveUrl)).setter(CreateApplicationVersionResponse.setter(Builder::sourceCodeArchiveUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceCodeArchiveUrl").build()}).build();
    private static final SdkField<String> SOURCE_CODE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceCodeUrl").getter(CreateApplicationVersionResponse.getter(CreateApplicationVersionResponse::sourceCodeUrl)).setter(CreateApplicationVersionResponse.setter(Builder::sourceCodeUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceCodeUrl").build()}).build();
    private static final SdkField<String> TEMPLATE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateUrl").getter(CreateApplicationVersionResponse.getter(CreateApplicationVersionResponse::templateUrl)).setter(CreateApplicationVersionResponse.setter(Builder::templateUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateUrl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, CREATION_TIME_FIELD, PARAMETER_DEFINITIONS_FIELD, REQUIRED_CAPABILITIES_FIELD, RESOURCES_SUPPORTED_FIELD, SEMANTIC_VERSION_FIELD, SOURCE_CODE_ARCHIVE_URL_FIELD, SOURCE_CODE_URL_FIELD, TEMPLATE_URL_FIELD));
    private final String applicationId;
    private final String creationTime;
    private final List<ParameterDefinition> parameterDefinitions;
    private final List<String> requiredCapabilities;
    private final Boolean resourcesSupported;
    private final String semanticVersion;
    private final String sourceCodeArchiveUrl;
    private final String sourceCodeUrl;
    private final String templateUrl;

    private CreateApplicationVersionResponse(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.creationTime = builder.creationTime;
        this.parameterDefinitions = builder.parameterDefinitions;
        this.requiredCapabilities = builder.requiredCapabilities;
        this.resourcesSupported = builder.resourcesSupported;
        this.semanticVersion = builder.semanticVersion;
        this.sourceCodeArchiveUrl = builder.sourceCodeArchiveUrl;
        this.sourceCodeUrl = builder.sourceCodeUrl;
        this.templateUrl = builder.templateUrl;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String creationTime() {
        return this.creationTime;
    }

    public final boolean hasParameterDefinitions() {
        return this.parameterDefinitions != null && !(this.parameterDefinitions instanceof SdkAutoConstructList);
    }

    public final List<ParameterDefinition> parameterDefinitions() {
        return this.parameterDefinitions;
    }

    public final List<Capability> requiredCapabilities() {
        return ___listOfCapabilityCopier.copyStringToEnum(this.requiredCapabilities);
    }

    public final boolean hasRequiredCapabilities() {
        return this.requiredCapabilities != null && !(this.requiredCapabilities instanceof SdkAutoConstructList);
    }

    public final List<String> requiredCapabilitiesAsStrings() {
        return this.requiredCapabilities;
    }

    public final Boolean resourcesSupported() {
        return this.resourcesSupported;
    }

    public final String semanticVersion() {
        return this.semanticVersion;
    }

    public final String sourceCodeArchiveUrl() {
        return this.sourceCodeArchiveUrl;
    }

    public final String sourceCodeUrl() {
        return this.sourceCodeUrl;
    }

    public final String templateUrl() {
        return this.templateUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameterDefinitions() ? this.parameterDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequiredCapabilities() ? this.requiredCapabilitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resourcesSupported());
        hashCode = 31 * hashCode + Objects.hashCode(this.semanticVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceCodeArchiveUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceCodeUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateUrl());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationVersionResponse)) {
            return false;
        }
        CreateApplicationVersionResponse other = (CreateApplicationVersionResponse)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.creationTime(), other.creationTime()) && this.hasParameterDefinitions() == other.hasParameterDefinitions() && Objects.equals(this.parameterDefinitions(), other.parameterDefinitions()) && this.hasRequiredCapabilities() == other.hasRequiredCapabilities() && Objects.equals(this.requiredCapabilitiesAsStrings(), other.requiredCapabilitiesAsStrings()) && Objects.equals(this.resourcesSupported(), other.resourcesSupported()) && Objects.equals(this.semanticVersion(), other.semanticVersion()) && Objects.equals(this.sourceCodeArchiveUrl(), other.sourceCodeArchiveUrl()) && Objects.equals(this.sourceCodeUrl(), other.sourceCodeUrl()) && Objects.equals(this.templateUrl(), other.templateUrl());
    }

    public final String toString() {
        return ToString.builder((String)"CreateApplicationVersionResponse").add("ApplicationId", (Object)this.applicationId()).add("CreationTime", (Object)this.creationTime()).add("ParameterDefinitions", this.hasParameterDefinitions() ? this.parameterDefinitions() : null).add("RequiredCapabilities", this.hasRequiredCapabilities() ? this.requiredCapabilitiesAsStrings() : null).add("ResourcesSupported", (Object)this.resourcesSupported()).add("SemanticVersion", (Object)this.semanticVersion()).add("SourceCodeArchiveUrl", (Object)this.sourceCodeArchiveUrl()).add("SourceCodeUrl", (Object)this.sourceCodeUrl()).add("TemplateUrl", (Object)this.templateUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "ParameterDefinitions": {
                return Optional.ofNullable(clazz.cast(this.parameterDefinitions()));
            }
            case "RequiredCapabilities": {
                return Optional.ofNullable(clazz.cast(this.requiredCapabilitiesAsStrings()));
            }
            case "ResourcesSupported": {
                return Optional.ofNullable(clazz.cast(this.resourcesSupported()));
            }
            case "SemanticVersion": {
                return Optional.ofNullable(clazz.cast(this.semanticVersion()));
            }
            case "SourceCodeArchiveUrl": {
                return Optional.ofNullable(clazz.cast(this.sourceCodeArchiveUrl()));
            }
            case "SourceCodeUrl": {
                return Optional.ofNullable(clazz.cast(this.sourceCodeUrl()));
            }
            case "TemplateUrl": {
                return Optional.ofNullable(clazz.cast(this.templateUrl()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateApplicationVersionResponse, T> g) {
        return obj -> g.apply((CreateApplicationVersionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServerlessApplicationRepositoryResponse.BuilderImpl
    implements Builder {
        private String applicationId;
        private String creationTime;
        private List<ParameterDefinition> parameterDefinitions = DefaultSdkAutoConstructList.getInstance();
        private List<String> requiredCapabilities = DefaultSdkAutoConstructList.getInstance();
        private Boolean resourcesSupported;
        private String semanticVersion;
        private String sourceCodeArchiveUrl;
        private String sourceCodeUrl;
        private String templateUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApplicationVersionResponse model) {
            super(model);
            this.applicationId(model.applicationId);
            this.creationTime(model.creationTime);
            this.parameterDefinitions(model.parameterDefinitions);
            this.requiredCapabilitiesWithStrings(model.requiredCapabilities);
            this.resourcesSupported(model.resourcesSupported);
            this.semanticVersion(model.semanticVersion);
            this.sourceCodeArchiveUrl(model.sourceCodeArchiveUrl);
            this.sourceCodeUrl(model.sourceCodeUrl);
            this.templateUrl(model.templateUrl);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(String creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(String creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final List<ParameterDefinition.Builder> getParameterDefinitions() {
            List<ParameterDefinition.Builder> result = ___listOfParameterDefinitionCopier.copyToBuilder(this.parameterDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameterDefinitions(Collection<ParameterDefinition.BuilderImpl> parameterDefinitions) {
            this.parameterDefinitions = ___listOfParameterDefinitionCopier.copyFromBuilder(parameterDefinitions);
        }

        @Override
        public final Builder parameterDefinitions(Collection<ParameterDefinition> parameterDefinitions) {
            this.parameterDefinitions = ___listOfParameterDefinitionCopier.copy(parameterDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterDefinitions(ParameterDefinition ... parameterDefinitions) {
            this.parameterDefinitions(Arrays.asList(parameterDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterDefinitions(Consumer<ParameterDefinition.Builder> ... parameterDefinitions) {
            this.parameterDefinitions(Stream.of(parameterDefinitions).map(c -> (ParameterDefinition)((ParameterDefinition.Builder)ParameterDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getRequiredCapabilities() {
            if (this.requiredCapabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.requiredCapabilities;
        }

        public final void setRequiredCapabilities(Collection<String> requiredCapabilities) {
            this.requiredCapabilities = ___listOfCapabilityCopier.copy(requiredCapabilities);
        }

        @Override
        public final Builder requiredCapabilitiesWithStrings(Collection<String> requiredCapabilities) {
            this.requiredCapabilities = ___listOfCapabilityCopier.copy(requiredCapabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requiredCapabilitiesWithStrings(String ... requiredCapabilities) {
            this.requiredCapabilitiesWithStrings(Arrays.asList(requiredCapabilities));
            return this;
        }

        @Override
        public final Builder requiredCapabilities(Collection<Capability> requiredCapabilities) {
            this.requiredCapabilities = ___listOfCapabilityCopier.copyEnumToString(requiredCapabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requiredCapabilities(Capability ... requiredCapabilities) {
            this.requiredCapabilities(Arrays.asList(requiredCapabilities));
            return this;
        }

        public final Boolean getResourcesSupported() {
            return this.resourcesSupported;
        }

        public final void setResourcesSupported(Boolean resourcesSupported) {
            this.resourcesSupported = resourcesSupported;
        }

        @Override
        public final Builder resourcesSupported(Boolean resourcesSupported) {
            this.resourcesSupported = resourcesSupported;
            return this;
        }

        public final String getSemanticVersion() {
            return this.semanticVersion;
        }

        public final void setSemanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
        }

        @Override
        public final Builder semanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
            return this;
        }

        public final String getSourceCodeArchiveUrl() {
            return this.sourceCodeArchiveUrl;
        }

        public final void setSourceCodeArchiveUrl(String sourceCodeArchiveUrl) {
            this.sourceCodeArchiveUrl = sourceCodeArchiveUrl;
        }

        @Override
        public final Builder sourceCodeArchiveUrl(String sourceCodeArchiveUrl) {
            this.sourceCodeArchiveUrl = sourceCodeArchiveUrl;
            return this;
        }

        public final String getSourceCodeUrl() {
            return this.sourceCodeUrl;
        }

        public final void setSourceCodeUrl(String sourceCodeUrl) {
            this.sourceCodeUrl = sourceCodeUrl;
        }

        @Override
        public final Builder sourceCodeUrl(String sourceCodeUrl) {
            this.sourceCodeUrl = sourceCodeUrl;
            return this;
        }

        public final String getTemplateUrl() {
            return this.templateUrl;
        }

        public final void setTemplateUrl(String templateUrl) {
            this.templateUrl = templateUrl;
        }

        @Override
        public final Builder templateUrl(String templateUrl) {
            this.templateUrl = templateUrl;
            return this;
        }

        @Override
        public CreateApplicationVersionResponse build() {
            return new CreateApplicationVersionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServerlessApplicationRepositoryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateApplicationVersionResponse> {
        public Builder applicationId(String var1);

        public Builder creationTime(String var1);

        public Builder parameterDefinitions(Collection<ParameterDefinition> var1);

        public Builder parameterDefinitions(ParameterDefinition ... var1);

        public Builder parameterDefinitions(Consumer<ParameterDefinition.Builder> ... var1);

        public Builder requiredCapabilitiesWithStrings(Collection<String> var1);

        public Builder requiredCapabilitiesWithStrings(String ... var1);

        public Builder requiredCapabilities(Collection<Capability> var1);

        public Builder requiredCapabilities(Capability ... var1);

        public Builder resourcesSupported(Boolean var1);

        public Builder semanticVersion(String var1);

        public Builder sourceCodeArchiveUrl(String var1);

        public Builder sourceCodeUrl(String var1);

        public Builder templateUrl(String var1);
    }
}

