/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.serverlessapplicationrepository.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ServerlessApplicationRepositoryRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateApplicationVersionRequest
extends ServerlessApplicationRepositoryRequest
implements ToCopyableBuilder<Builder, CreateApplicationVersionRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(CreateApplicationVersionRequest.getter(CreateApplicationVersionRequest::applicationId)).setter(CreateApplicationVersionRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()}).build();
    private static final SdkField<String> SEMANTIC_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SemanticVersion").getter(CreateApplicationVersionRequest.getter(CreateApplicationVersionRequest::semanticVersion)).setter(CreateApplicationVersionRequest.setter(Builder::semanticVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("semanticVersion").build()}).build();
    private static final SdkField<String> SOURCE_CODE_ARCHIVE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceCodeArchiveUrl").getter(CreateApplicationVersionRequest.getter(CreateApplicationVersionRequest::sourceCodeArchiveUrl)).setter(CreateApplicationVersionRequest.setter(Builder::sourceCodeArchiveUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceCodeArchiveUrl").build()}).build();
    private static final SdkField<String> SOURCE_CODE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceCodeUrl").getter(CreateApplicationVersionRequest.getter(CreateApplicationVersionRequest::sourceCodeUrl)).setter(CreateApplicationVersionRequest.setter(Builder::sourceCodeUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceCodeUrl").build()}).build();
    private static final SdkField<String> TEMPLATE_BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateBody").getter(CreateApplicationVersionRequest.getter(CreateApplicationVersionRequest::templateBody)).setter(CreateApplicationVersionRequest.setter(Builder::templateBody)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateBody").build()}).build();
    private static final SdkField<String> TEMPLATE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateUrl").getter(CreateApplicationVersionRequest.getter(CreateApplicationVersionRequest::templateUrl)).setter(CreateApplicationVersionRequest.setter(Builder::templateUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateUrl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, SEMANTIC_VERSION_FIELD, SOURCE_CODE_ARCHIVE_URL_FIELD, SOURCE_CODE_URL_FIELD, TEMPLATE_BODY_FIELD, TEMPLATE_URL_FIELD));
    private final String applicationId;
    private final String semanticVersion;
    private final String sourceCodeArchiveUrl;
    private final String sourceCodeUrl;
    private final String templateBody;
    private final String templateUrl;

    private CreateApplicationVersionRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.semanticVersion = builder.semanticVersion;
        this.sourceCodeArchiveUrl = builder.sourceCodeArchiveUrl;
        this.sourceCodeUrl = builder.sourceCodeUrl;
        this.templateBody = builder.templateBody;
        this.templateUrl = builder.templateUrl;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String semanticVersion() {
        return this.semanticVersion;
    }

    public final String sourceCodeArchiveUrl() {
        return this.sourceCodeArchiveUrl;
    }

    public final String sourceCodeUrl() {
        return this.sourceCodeUrl;
    }

    public final String templateBody() {
        return this.templateBody;
    }

    public final String templateUrl() {
        return this.templateUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.semanticVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceCodeArchiveUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceCodeUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateUrl());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationVersionRequest)) {
            return false;
        }
        CreateApplicationVersionRequest other = (CreateApplicationVersionRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.semanticVersion(), other.semanticVersion()) && Objects.equals(this.sourceCodeArchiveUrl(), other.sourceCodeArchiveUrl()) && Objects.equals(this.sourceCodeUrl(), other.sourceCodeUrl()) && Objects.equals(this.templateBody(), other.templateBody()) && Objects.equals(this.templateUrl(), other.templateUrl());
    }

    public final String toString() {
        return ToString.builder((String)"CreateApplicationVersionRequest").add("ApplicationId", (Object)this.applicationId()).add("SemanticVersion", (Object)this.semanticVersion()).add("SourceCodeArchiveUrl", (Object)this.sourceCodeArchiveUrl()).add("SourceCodeUrl", (Object)this.sourceCodeUrl()).add("TemplateBody", (Object)this.templateBody()).add("TemplateUrl", (Object)this.templateUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "SemanticVersion": {
                return Optional.ofNullable(clazz.cast(this.semanticVersion()));
            }
            case "SourceCodeArchiveUrl": {
                return Optional.ofNullable(clazz.cast(this.sourceCodeArchiveUrl()));
            }
            case "SourceCodeUrl": {
                return Optional.ofNullable(clazz.cast(this.sourceCodeUrl()));
            }
            case "TemplateBody": {
                return Optional.ofNullable(clazz.cast(this.templateBody()));
            }
            case "TemplateUrl": {
                return Optional.ofNullable(clazz.cast(this.templateUrl()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateApplicationVersionRequest, T> g) {
        return obj -> g.apply((CreateApplicationVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServerlessApplicationRepositoryRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private String semanticVersion;
        private String sourceCodeArchiveUrl;
        private String sourceCodeUrl;
        private String templateBody;
        private String templateUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApplicationVersionRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.semanticVersion(model.semanticVersion);
            this.sourceCodeArchiveUrl(model.sourceCodeArchiveUrl);
            this.sourceCodeUrl(model.sourceCodeUrl);
            this.templateBody(model.templateBody);
            this.templateUrl(model.templateUrl);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getSemanticVersion() {
            return this.semanticVersion;
        }

        @Override
        public final Builder semanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
            return this;
        }

        public final void setSemanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
        }

        public final String getSourceCodeArchiveUrl() {
            return this.sourceCodeArchiveUrl;
        }

        @Override
        public final Builder sourceCodeArchiveUrl(String sourceCodeArchiveUrl) {
            this.sourceCodeArchiveUrl = sourceCodeArchiveUrl;
            return this;
        }

        public final void setSourceCodeArchiveUrl(String sourceCodeArchiveUrl) {
            this.sourceCodeArchiveUrl = sourceCodeArchiveUrl;
        }

        public final String getSourceCodeUrl() {
            return this.sourceCodeUrl;
        }

        @Override
        public final Builder sourceCodeUrl(String sourceCodeUrl) {
            this.sourceCodeUrl = sourceCodeUrl;
            return this;
        }

        public final void setSourceCodeUrl(String sourceCodeUrl) {
            this.sourceCodeUrl = sourceCodeUrl;
        }

        public final String getTemplateBody() {
            return this.templateBody;
        }

        @Override
        public final Builder templateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        public final void setTemplateBody(String templateBody) {
            this.templateBody = templateBody;
        }

        public final String getTemplateUrl() {
            return this.templateUrl;
        }

        @Override
        public final Builder templateUrl(String templateUrl) {
            this.templateUrl = templateUrl;
            return this;
        }

        public final void setTemplateUrl(String templateUrl) {
            this.templateUrl = templateUrl;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateApplicationVersionRequest build() {
            return new CreateApplicationVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServerlessApplicationRepositoryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateApplicationVersionRequest> {
        public Builder applicationId(String var1);

        public Builder semanticVersion(String var1);

        public Builder sourceCodeArchiveUrl(String var1);

        public Builder sourceCodeUrl(String var1);

        public Builder templateBody(String var1);

        public Builder templateUrl(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

