/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.serverlessapplicationrepository.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ApplicationPolicyStatement;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ServerlessApplicationRepositoryRequest;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.___listOfApplicationPolicyStatementCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutApplicationPolicyRequest
extends ServerlessApplicationRepositoryRequest
implements ToCopyableBuilder<Builder, PutApplicationPolicyRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(PutApplicationPolicyRequest.getter(PutApplicationPolicyRequest::applicationId)).setter(PutApplicationPolicyRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()}).build();
    private static final SdkField<List<ApplicationPolicyStatement>> STATEMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Statements").getter(PutApplicationPolicyRequest.getter(PutApplicationPolicyRequest::statements)).setter(PutApplicationPolicyRequest.setter(Builder::statements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ApplicationPolicyStatement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, STATEMENTS_FIELD));
    private final String applicationId;
    private final List<ApplicationPolicyStatement> statements;

    private PutApplicationPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.statements = builder.statements;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public boolean hasStatements() {
        return this.statements != null && !(this.statements instanceof SdkAutoConstructList);
    }

    public List<ApplicationPolicyStatement> statements() {
        return this.statements;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatements() ? this.statements() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutApplicationPolicyRequest)) {
            return false;
        }
        PutApplicationPolicyRequest other = (PutApplicationPolicyRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && this.hasStatements() == other.hasStatements() && Objects.equals(this.statements(), other.statements());
    }

    public String toString() {
        return ToString.builder((String)"PutApplicationPolicyRequest").add("ApplicationId", (Object)this.applicationId()).add("Statements", this.hasStatements() ? this.statements() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "Statements": {
                return Optional.ofNullable(clazz.cast(this.statements()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutApplicationPolicyRequest, T> g) {
        return obj -> g.apply((PutApplicationPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServerlessApplicationRepositoryRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private List<ApplicationPolicyStatement> statements = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutApplicationPolicyRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.statements(model.statements);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final Collection<ApplicationPolicyStatement.Builder> getStatements() {
            if (this.statements instanceof SdkAutoConstructList) {
                return null;
            }
            return this.statements != null ? (Collection)this.statements.stream().map(ApplicationPolicyStatement::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder statements(Collection<ApplicationPolicyStatement> statements) {
            this.statements = ___listOfApplicationPolicyStatementCopier.copy(statements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statements(ApplicationPolicyStatement ... statements) {
            this.statements(Arrays.asList(statements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statements(Consumer<ApplicationPolicyStatement.Builder> ... statements) {
            this.statements(Stream.of(statements).map(c -> (ApplicationPolicyStatement)((ApplicationPolicyStatement.Builder)ApplicationPolicyStatement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStatements(Collection<ApplicationPolicyStatement.BuilderImpl> statements) {
            this.statements = ___listOfApplicationPolicyStatementCopier.copyFromBuilder(statements);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutApplicationPolicyRequest build() {
            return new PutApplicationPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServerlessApplicationRepositoryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutApplicationPolicyRequest> {
        public Builder applicationId(String var1);

        public Builder statements(Collection<ApplicationPolicyStatement> var1);

        public Builder statements(ApplicationPolicyStatement ... var1);

        public Builder statements(Consumer<ApplicationPolicyStatement.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

