/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.serverlessapplicationrepository.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ParameterDefinition;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ParameterDefinitionMarshaller {
    private static final MarshallingInfo<String> ALLOWEDPATTERN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("allowedPattern").isBinary(false).build();
    private static final MarshallingInfo<List> ALLOWEDVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("allowedValues").isBinary(false).build();
    private static final MarshallingInfo<String> CONSTRAINTDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("constraintDescription").isBinary(false).build();
    private static final MarshallingInfo<String> DEFAULTVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("defaultValue").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXLENGTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("maxLength").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("maxValue").isBinary(false).build();
    private static final MarshallingInfo<Integer> MINLENGTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("minLength").isBinary(false).build();
    private static final MarshallingInfo<Integer> MINVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("minValue").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<Boolean> NOECHO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("noEcho").isBinary(false).build();
    private static final MarshallingInfo<List> REFERENCEDBYRESOURCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("referencedByResources").isBinary(false).build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").isBinary(false).build();
    private static final ParameterDefinitionMarshaller INSTANCE = new ParameterDefinitionMarshaller();

    private ParameterDefinitionMarshaller() {
    }

    public static ParameterDefinitionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ParameterDefinition parameterDefinition, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)parameterDefinition, (String)"parameterDefinition");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)parameterDefinition.allowedPattern(), ALLOWEDPATTERN_BINDING);
            protocolMarshaller.marshall(parameterDefinition.allowedValues(), ALLOWEDVALUES_BINDING);
            protocolMarshaller.marshall((Object)parameterDefinition.constraintDescription(), CONSTRAINTDESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)parameterDefinition.defaultValue(), DEFAULTVALUE_BINDING);
            protocolMarshaller.marshall((Object)parameterDefinition.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)parameterDefinition.maxLength(), MAXLENGTH_BINDING);
            protocolMarshaller.marshall((Object)parameterDefinition.maxValue(), MAXVALUE_BINDING);
            protocolMarshaller.marshall((Object)parameterDefinition.minLength(), MINLENGTH_BINDING);
            protocolMarshaller.marshall((Object)parameterDefinition.minValue(), MINVALUE_BINDING);
            protocolMarshaller.marshall((Object)parameterDefinition.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)parameterDefinition.noEcho(), NOECHO_BINDING);
            protocolMarshaller.marshall(parameterDefinition.referencedByResources(), REFERENCEDBYRESOURCES_BINDING);
            protocolMarshaller.marshall((Object)parameterDefinition.type(), TYPE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

