/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.securitylake.model.HttpsNotificationConfiguration;
import software.amazon.awssdk.services.securitylake.model.SqsNotificationConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NotificationConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NotificationConfiguration> {
    private static final SdkField<HttpsNotificationConfiguration> HTTPS_NOTIFICATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("httpsNotificationConfiguration").getter(NotificationConfiguration.getter(NotificationConfiguration::httpsNotificationConfiguration)).setter(NotificationConfiguration.setter(Builder::httpsNotificationConfiguration)).constructor(HttpsNotificationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpsNotificationConfiguration").build()}).build();
    private static final SdkField<SqsNotificationConfiguration> SQS_NOTIFICATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sqsNotificationConfiguration").getter(NotificationConfiguration.getter(NotificationConfiguration::sqsNotificationConfiguration)).setter(NotificationConfiguration.setter(Builder::sqsNotificationConfiguration)).constructor(SqsNotificationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sqsNotificationConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HTTPS_NOTIFICATION_CONFIGURATION_FIELD, SQS_NOTIFICATION_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NotificationConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final HttpsNotificationConfiguration httpsNotificationConfiguration;
    private final SqsNotificationConfiguration sqsNotificationConfiguration;
    private final Type type;

    private NotificationConfiguration(BuilderImpl builder) {
        this.httpsNotificationConfiguration = builder.httpsNotificationConfiguration;
        this.sqsNotificationConfiguration = builder.sqsNotificationConfiguration;
        this.type = builder.type;
    }

    public final HttpsNotificationConfiguration httpsNotificationConfiguration() {
        return this.httpsNotificationConfiguration;
    }

    public final SqsNotificationConfiguration sqsNotificationConfiguration() {
        return this.sqsNotificationConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.httpsNotificationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.sqsNotificationConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationConfiguration)) {
            return false;
        }
        NotificationConfiguration other = (NotificationConfiguration)obj;
        return Objects.equals(this.httpsNotificationConfiguration(), other.httpsNotificationConfiguration()) && Objects.equals(this.sqsNotificationConfiguration(), other.sqsNotificationConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"NotificationConfiguration").add("HttpsNotificationConfiguration", (Object)this.httpsNotificationConfiguration()).add("SqsNotificationConfiguration", (Object)this.sqsNotificationConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "httpsNotificationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.httpsNotificationConfiguration()));
            }
            case "sqsNotificationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.sqsNotificationConfiguration()));
            }
        }
        return Optional.empty();
    }

    public static NotificationConfiguration fromHttpsNotificationConfiguration(HttpsNotificationConfiguration httpsNotificationConfiguration) {
        return (NotificationConfiguration)NotificationConfiguration.builder().httpsNotificationConfiguration(httpsNotificationConfiguration).build();
    }

    public static NotificationConfiguration fromHttpsNotificationConfiguration(Consumer<HttpsNotificationConfiguration.Builder> httpsNotificationConfiguration) {
        HttpsNotificationConfiguration.Builder builder = HttpsNotificationConfiguration.builder();
        httpsNotificationConfiguration.accept(builder);
        return NotificationConfiguration.fromHttpsNotificationConfiguration((HttpsNotificationConfiguration)builder.build());
    }

    public static NotificationConfiguration fromSqsNotificationConfiguration(SqsNotificationConfiguration sqsNotificationConfiguration) {
        return (NotificationConfiguration)NotificationConfiguration.builder().sqsNotificationConfiguration(sqsNotificationConfiguration).build();
    }

    public static NotificationConfiguration fromSqsNotificationConfiguration(Consumer<SqsNotificationConfiguration.Builder> sqsNotificationConfiguration) {
        SqsNotificationConfiguration.Builder builder = SqsNotificationConfiguration.builder();
        sqsNotificationConfiguration.accept(builder);
        return NotificationConfiguration.fromSqsNotificationConfiguration((SqsNotificationConfiguration)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("httpsNotificationConfiguration", HTTPS_NOTIFICATION_CONFIGURATION_FIELD);
        map.put("sqsNotificationConfiguration", SQS_NOTIFICATION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NotificationConfiguration, T> g) {
        return obj -> g.apply((NotificationConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        HTTPS_NOTIFICATION_CONFIGURATION,
        SQS_NOTIFICATION_CONFIGURATION,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private HttpsNotificationConfiguration httpsNotificationConfiguration;
        private SqsNotificationConfiguration sqsNotificationConfiguration;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(NotificationConfiguration model) {
            this.httpsNotificationConfiguration(model.httpsNotificationConfiguration);
            this.sqsNotificationConfiguration(model.sqsNotificationConfiguration);
        }

        public final HttpsNotificationConfiguration.Builder getHttpsNotificationConfiguration() {
            return this.httpsNotificationConfiguration != null ? this.httpsNotificationConfiguration.toBuilder() : null;
        }

        public final void setHttpsNotificationConfiguration(HttpsNotificationConfiguration.BuilderImpl httpsNotificationConfiguration) {
            HttpsNotificationConfiguration oldValue = this.httpsNotificationConfiguration;
            this.httpsNotificationConfiguration = httpsNotificationConfiguration != null ? httpsNotificationConfiguration.build() : null;
            this.handleUnionValueChange(Type.HTTPS_NOTIFICATION_CONFIGURATION, oldValue, this.httpsNotificationConfiguration);
        }

        @Override
        public final Builder httpsNotificationConfiguration(HttpsNotificationConfiguration httpsNotificationConfiguration) {
            HttpsNotificationConfiguration oldValue = this.httpsNotificationConfiguration;
            this.httpsNotificationConfiguration = httpsNotificationConfiguration;
            this.handleUnionValueChange(Type.HTTPS_NOTIFICATION_CONFIGURATION, oldValue, this.httpsNotificationConfiguration);
            return this;
        }

        public final SqsNotificationConfiguration.Builder getSqsNotificationConfiguration() {
            return this.sqsNotificationConfiguration != null ? this.sqsNotificationConfiguration.toBuilder() : null;
        }

        public final void setSqsNotificationConfiguration(SqsNotificationConfiguration.BuilderImpl sqsNotificationConfiguration) {
            SqsNotificationConfiguration oldValue = this.sqsNotificationConfiguration;
            this.sqsNotificationConfiguration = sqsNotificationConfiguration != null ? sqsNotificationConfiguration.build() : null;
            this.handleUnionValueChange(Type.SQS_NOTIFICATION_CONFIGURATION, oldValue, this.sqsNotificationConfiguration);
        }

        @Override
        public final Builder sqsNotificationConfiguration(SqsNotificationConfiguration sqsNotificationConfiguration) {
            SqsNotificationConfiguration oldValue = this.sqsNotificationConfiguration;
            this.sqsNotificationConfiguration = sqsNotificationConfiguration;
            this.handleUnionValueChange(Type.SQS_NOTIFICATION_CONFIGURATION, oldValue, this.sqsNotificationConfiguration);
            return this;
        }

        public NotificationConfiguration build() {
            return new NotificationConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NotificationConfiguration> {
        public Builder httpsNotificationConfiguration(HttpsNotificationConfiguration var1);

        default public Builder httpsNotificationConfiguration(Consumer<HttpsNotificationConfiguration.Builder> httpsNotificationConfiguration) {
            return this.httpsNotificationConfiguration((HttpsNotificationConfiguration)((HttpsNotificationConfiguration.Builder)HttpsNotificationConfiguration.builder().applyMutation(httpsNotificationConfiguration)).build());
        }

        public Builder sqsNotificationConfiguration(SqsNotificationConfiguration var1);

        default public Builder sqsNotificationConfiguration(Consumer<SqsNotificationConfiguration.Builder> sqsNotificationConfiguration) {
            return this.sqsNotificationConfiguration((SqsNotificationConfiguration)((SqsNotificationConfiguration.Builder)SqsNotificationConfiguration.builder().applyMutation(sqsNotificationConfiguration)).build());
        }
    }
}

