/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securitylake.model.SecurityLakeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDataLakeExceptionSubscriptionRequest
extends SecurityLakeRequest
implements ToCopyableBuilder<Builder, CreateDataLakeExceptionSubscriptionRequest> {
    private static final SdkField<Long> EXCEPTION_TIME_TO_LIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("exceptionTimeToLive").getter(CreateDataLakeExceptionSubscriptionRequest.getter(CreateDataLakeExceptionSubscriptionRequest::exceptionTimeToLive)).setter(CreateDataLakeExceptionSubscriptionRequest.setter(Builder::exceptionTimeToLive)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exceptionTimeToLive").build()}).build();
    private static final SdkField<String> NOTIFICATION_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("notificationEndpoint").getter(CreateDataLakeExceptionSubscriptionRequest.getter(CreateDataLakeExceptionSubscriptionRequest::notificationEndpoint)).setter(CreateDataLakeExceptionSubscriptionRequest.setter(Builder::notificationEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationEndpoint").build()}).build();
    private static final SdkField<String> SUBSCRIPTION_PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subscriptionProtocol").getter(CreateDataLakeExceptionSubscriptionRequest.getter(CreateDataLakeExceptionSubscriptionRequest::subscriptionProtocol)).setter(CreateDataLakeExceptionSubscriptionRequest.setter(Builder::subscriptionProtocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriptionProtocol").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXCEPTION_TIME_TO_LIVE_FIELD, NOTIFICATION_ENDPOINT_FIELD, SUBSCRIPTION_PROTOCOL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateDataLakeExceptionSubscriptionRequest.memberNameToFieldInitializer();
    private final Long exceptionTimeToLive;
    private final String notificationEndpoint;
    private final String subscriptionProtocol;

    private CreateDataLakeExceptionSubscriptionRequest(BuilderImpl builder) {
        super(builder);
        this.exceptionTimeToLive = builder.exceptionTimeToLive;
        this.notificationEndpoint = builder.notificationEndpoint;
        this.subscriptionProtocol = builder.subscriptionProtocol;
    }

    public final Long exceptionTimeToLive() {
        return this.exceptionTimeToLive;
    }

    public final String notificationEndpoint() {
        return this.notificationEndpoint;
    }

    public final String subscriptionProtocol() {
        return this.subscriptionProtocol;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.exceptionTimeToLive());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionProtocol());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataLakeExceptionSubscriptionRequest)) {
            return false;
        }
        CreateDataLakeExceptionSubscriptionRequest other = (CreateDataLakeExceptionSubscriptionRequest)((Object)obj);
        return Objects.equals(this.exceptionTimeToLive(), other.exceptionTimeToLive()) && Objects.equals(this.notificationEndpoint(), other.notificationEndpoint()) && Objects.equals(this.subscriptionProtocol(), other.subscriptionProtocol());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDataLakeExceptionSubscriptionRequest").add("ExceptionTimeToLive", (Object)this.exceptionTimeToLive()).add("NotificationEndpoint", (Object)this.notificationEndpoint()).add("SubscriptionProtocol", (Object)this.subscriptionProtocol()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "exceptionTimeToLive": {
                return Optional.ofNullable(clazz.cast(this.exceptionTimeToLive()));
            }
            case "notificationEndpoint": {
                return Optional.ofNullable(clazz.cast(this.notificationEndpoint()));
            }
            case "subscriptionProtocol": {
                return Optional.ofNullable(clazz.cast(this.subscriptionProtocol()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("exceptionTimeToLive", EXCEPTION_TIME_TO_LIVE_FIELD);
        map.put("notificationEndpoint", NOTIFICATION_ENDPOINT_FIELD);
        map.put("subscriptionProtocol", SUBSCRIPTION_PROTOCOL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDataLakeExceptionSubscriptionRequest, T> g) {
        return obj -> g.apply((CreateDataLakeExceptionSubscriptionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityLakeRequest.BuilderImpl
    implements Builder {
        private Long exceptionTimeToLive;
        private String notificationEndpoint;
        private String subscriptionProtocol;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataLakeExceptionSubscriptionRequest model) {
            super(model);
            this.exceptionTimeToLive(model.exceptionTimeToLive);
            this.notificationEndpoint(model.notificationEndpoint);
            this.subscriptionProtocol(model.subscriptionProtocol);
        }

        public final Long getExceptionTimeToLive() {
            return this.exceptionTimeToLive;
        }

        public final void setExceptionTimeToLive(Long exceptionTimeToLive) {
            this.exceptionTimeToLive = exceptionTimeToLive;
        }

        @Override
        public final Builder exceptionTimeToLive(Long exceptionTimeToLive) {
            this.exceptionTimeToLive = exceptionTimeToLive;
            return this;
        }

        public final String getNotificationEndpoint() {
            return this.notificationEndpoint;
        }

        public final void setNotificationEndpoint(String notificationEndpoint) {
            this.notificationEndpoint = notificationEndpoint;
        }

        @Override
        public final Builder notificationEndpoint(String notificationEndpoint) {
            this.notificationEndpoint = notificationEndpoint;
            return this;
        }

        public final String getSubscriptionProtocol() {
            return this.subscriptionProtocol;
        }

        public final void setSubscriptionProtocol(String subscriptionProtocol) {
            this.subscriptionProtocol = subscriptionProtocol;
        }

        @Override
        public final Builder subscriptionProtocol(String subscriptionProtocol) {
            this.subscriptionProtocol = subscriptionProtocol;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDataLakeExceptionSubscriptionRequest build() {
            return new CreateDataLakeExceptionSubscriptionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SecurityLakeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDataLakeExceptionSubscriptionRequest> {
        public Builder exceptionTimeToLive(Long var1);

        public Builder notificationEndpoint(String var1);

        public Builder subscriptionProtocol(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

