/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securitylake.model.DataLakeResource;
import software.amazon.awssdk.services.securitylake.model.DataLakeResourceListCopier;
import software.amazon.awssdk.services.securitylake.model.SecurityLakeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDataLakeResponse
extends SecurityLakeResponse
implements ToCopyableBuilder<Builder, CreateDataLakeResponse> {
    private static final SdkField<List<DataLakeResource>> DATA_LAKES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dataLakes").getter(CreateDataLakeResponse.getter(CreateDataLakeResponse::dataLakes)).setter(CreateDataLakeResponse.setter(Builder::dataLakes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataLakes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataLakeResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_LAKES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateDataLakeResponse.memberNameToFieldInitializer();
    private final List<DataLakeResource> dataLakes;

    private CreateDataLakeResponse(BuilderImpl builder) {
        super(builder);
        this.dataLakes = builder.dataLakes;
    }

    public final boolean hasDataLakes() {
        return this.dataLakes != null && !(this.dataLakes instanceof SdkAutoConstructList);
    }

    public final List<DataLakeResource> dataLakes() {
        return this.dataLakes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataLakes() ? this.dataLakes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataLakeResponse)) {
            return false;
        }
        CreateDataLakeResponse other = (CreateDataLakeResponse)((Object)obj);
        return this.hasDataLakes() == other.hasDataLakes() && Objects.equals(this.dataLakes(), other.dataLakes());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDataLakeResponse").add("DataLakes", this.hasDataLakes() ? this.dataLakes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dataLakes": {
                return Optional.ofNullable(clazz.cast(this.dataLakes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<DataLakeResource>>> map = new HashMap<String, SdkField<List<DataLakeResource>>>();
        map.put("dataLakes", DATA_LAKES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDataLakeResponse, T> g) {
        return obj -> g.apply((CreateDataLakeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityLakeResponse.BuilderImpl
    implements Builder {
        private List<DataLakeResource> dataLakes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataLakeResponse model) {
            super(model);
            this.dataLakes(model.dataLakes);
        }

        public final List<DataLakeResource.Builder> getDataLakes() {
            List<DataLakeResource.Builder> result = DataLakeResourceListCopier.copyToBuilder(this.dataLakes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataLakes(Collection<DataLakeResource.BuilderImpl> dataLakes) {
            this.dataLakes = DataLakeResourceListCopier.copyFromBuilder(dataLakes);
        }

        @Override
        public final Builder dataLakes(Collection<DataLakeResource> dataLakes) {
            this.dataLakes = DataLakeResourceListCopier.copy(dataLakes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataLakes(DataLakeResource ... dataLakes) {
            this.dataLakes(Arrays.asList(dataLakes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataLakes(Consumer<DataLakeResource.Builder> ... dataLakes) {
            this.dataLakes(Stream.of(dataLakes).map(c -> (DataLakeResource)((DataLakeResource.Builder)DataLakeResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CreateDataLakeResponse build() {
            return new CreateDataLakeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SecurityLakeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDataLakeResponse> {
        public Builder dataLakes(Collection<DataLakeResource> var1);

        public Builder dataLakes(DataLakeResource ... var1);

        public Builder dataLakes(Consumer<DataLakeResource.Builder> ... var1);
    }
}

