/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Failures
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Failures> {
    private static final SdkField<String> EXCEPTION_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("exceptionMessage").getter(Failures.getter(Failures::exceptionMessage)).setter(Failures.setter(Builder::exceptionMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exceptionMessage").build()}).build();
    private static final SdkField<String> REMEDIATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("remediation").getter(Failures.getter(Failures::remediation)).setter(Failures.setter(Builder::remediation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remediation").build()}).build();
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("timestamp").getter(Failures.getter(Failures::timestamp)).setter(Failures.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXCEPTION_MESSAGE_FIELD, REMEDIATION_FIELD, TIMESTAMP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String exceptionMessage;
    private final String remediation;
    private final Instant timestamp;

    private Failures(BuilderImpl builder) {
        this.exceptionMessage = builder.exceptionMessage;
        this.remediation = builder.remediation;
        this.timestamp = builder.timestamp;
    }

    public final String exceptionMessage() {
        return this.exceptionMessage;
    }

    public final String remediation() {
        return this.remediation;
    }

    public final Instant timestamp() {
        return this.timestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.exceptionMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.remediation());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Failures)) {
            return false;
        }
        Failures other = (Failures)obj;
        return Objects.equals(this.exceptionMessage(), other.exceptionMessage()) && Objects.equals(this.remediation(), other.remediation()) && Objects.equals(this.timestamp(), other.timestamp());
    }

    public final String toString() {
        return ToString.builder((String)"Failures").add("ExceptionMessage", (Object)this.exceptionMessage()).add("Remediation", (Object)this.remediation()).add("Timestamp", (Object)this.timestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "exceptionMessage": {
                return Optional.ofNullable(clazz.cast(this.exceptionMessage()));
            }
            case "remediation": {
                return Optional.ofNullable(clazz.cast(this.remediation()));
            }
            case "timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Failures, T> g) {
        return obj -> g.apply((Failures)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String exceptionMessage;
        private String remediation;
        private Instant timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(Failures model) {
            this.exceptionMessage(model.exceptionMessage);
            this.remediation(model.remediation);
            this.timestamp(model.timestamp);
        }

        public final String getExceptionMessage() {
            return this.exceptionMessage;
        }

        public final void setExceptionMessage(String exceptionMessage) {
            this.exceptionMessage = exceptionMessage;
        }

        @Override
        public final Builder exceptionMessage(String exceptionMessage) {
            this.exceptionMessage = exceptionMessage;
            return this;
        }

        public final String getRemediation() {
            return this.remediation;
        }

        public final void setRemediation(String remediation) {
            this.remediation = remediation;
        }

        @Override
        public final Builder remediation(String remediation) {
            this.remediation = remediation;
            return this;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Failures build() {
            return new Failures(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Failures> {
        public Builder exceptionMessage(String var1);

        public Builder remediation(String var1);

        public Builder timestamp(Instant var1);
    }
}

