/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securitylake.model.Region;
import software.amazon.awssdk.services.securitylake.model.RegionSetCopier;
import software.amazon.awssdk.services.securitylake.model.SecurityLakeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDatalakeExceptionsRequest
extends SecurityLakeRequest
implements ToCopyableBuilder<Builder, ListDatalakeExceptionsRequest> {
    private static final SdkField<Integer> MAX_FAILURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxFailures").getter(ListDatalakeExceptionsRequest.getter(ListDatalakeExceptionsRequest::maxFailures)).setter(ListDatalakeExceptionsRequest.setter(Builder::maxFailures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxFailures").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListDatalakeExceptionsRequest.getter(ListDatalakeExceptionsRequest::nextToken)).setter(ListDatalakeExceptionsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<String>> REGION_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("regionSet").getter(ListDatalakeExceptionsRequest.getter(ListDatalakeExceptionsRequest::regionSetAsStrings)).setter(ListDatalakeExceptionsRequest.setter(Builder::regionSetWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionSet").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_FAILURES_FIELD, NEXT_TOKEN_FIELD, REGION_SET_FIELD));
    private final Integer maxFailures;
    private final String nextToken;
    private final List<String> regionSet;

    private ListDatalakeExceptionsRequest(BuilderImpl builder) {
        super(builder);
        this.maxFailures = builder.maxFailures;
        this.nextToken = builder.nextToken;
        this.regionSet = builder.regionSet;
    }

    public final Integer maxFailures() {
        return this.maxFailures;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final List<Region> regionSet() {
        return RegionSetCopier.copyStringToEnum(this.regionSet);
    }

    public final boolean hasRegionSet() {
        return this.regionSet != null && !(this.regionSet instanceof SdkAutoConstructList);
    }

    public final List<String> regionSetAsStrings() {
        return this.regionSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.maxFailures());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegionSet() ? this.regionSetAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDatalakeExceptionsRequest)) {
            return false;
        }
        ListDatalakeExceptionsRequest other = (ListDatalakeExceptionsRequest)((Object)obj);
        return Objects.equals(this.maxFailures(), other.maxFailures()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasRegionSet() == other.hasRegionSet() && Objects.equals(this.regionSetAsStrings(), other.regionSetAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ListDatalakeExceptionsRequest").add("MaxFailures", (Object)this.maxFailures()).add("NextToken", (Object)this.nextToken()).add("RegionSet", this.hasRegionSet() ? this.regionSetAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "maxFailures": {
                return Optional.ofNullable(clazz.cast(this.maxFailures()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "regionSet": {
                return Optional.ofNullable(clazz.cast(this.regionSetAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDatalakeExceptionsRequest, T> g) {
        return obj -> g.apply((ListDatalakeExceptionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityLakeRequest.BuilderImpl
    implements Builder {
        private Integer maxFailures;
        private String nextToken;
        private List<String> regionSet = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListDatalakeExceptionsRequest model) {
            super(model);
            this.maxFailures(model.maxFailures);
            this.nextToken(model.nextToken);
            this.regionSetWithStrings(model.regionSet);
        }

        public final Integer getMaxFailures() {
            return this.maxFailures;
        }

        public final void setMaxFailures(Integer maxFailures) {
            this.maxFailures = maxFailures;
        }

        @Override
        public final Builder maxFailures(Integer maxFailures) {
            this.maxFailures = maxFailures;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Collection<String> getRegionSet() {
            if (this.regionSet instanceof SdkAutoConstructList) {
                return null;
            }
            return this.regionSet;
        }

        public final void setRegionSet(Collection<String> regionSet) {
            this.regionSet = RegionSetCopier.copy(regionSet);
        }

        @Override
        public final Builder regionSetWithStrings(Collection<String> regionSet) {
            this.regionSet = RegionSetCopier.copy(regionSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regionSetWithStrings(String ... regionSet) {
            this.regionSetWithStrings(Arrays.asList(regionSet));
            return this;
        }

        @Override
        public final Builder regionSet(Collection<Region> regionSet) {
            this.regionSet = RegionSetCopier.copyEnumToString(regionSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regionSet(Region ... regionSet) {
            this.regionSet(Arrays.asList(regionSet));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDatalakeExceptionsRequest build() {
            return new ListDatalakeExceptionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SecurityLakeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDatalakeExceptionsRequest> {
        public Builder maxFailures(Integer var1);

        public Builder nextToken(String var1);

        public Builder regionSetWithStrings(Collection<String> var1);

        public Builder regionSetWithStrings(String ... var1);

        public Builder regionSet(Collection<Region> var1);

        public Builder regionSet(Region ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

