/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securitylake.model.OcsfEventClass;
import software.amazon.awssdk.services.securitylake.model.SecurityLakeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCustomLogSourceRequest
extends SecurityLakeRequest
implements ToCopyableBuilder<Builder, CreateCustomLogSourceRequest> {
    private static final SdkField<String> CUSTOM_SOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customSourceName").getter(CreateCustomLogSourceRequest.getter(CreateCustomLogSourceRequest::customSourceName)).setter(CreateCustomLogSourceRequest.setter(Builder::customSourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customSourceName").build()}).build();
    private static final SdkField<String> EVENT_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventClass").getter(CreateCustomLogSourceRequest.getter(CreateCustomLogSourceRequest::eventClassAsString)).setter(CreateCustomLogSourceRequest.setter(Builder::eventClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventClass").build()}).build();
    private static final SdkField<String> GLUE_INVOCATION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("glueInvocationRoleArn").getter(CreateCustomLogSourceRequest.getter(CreateCustomLogSourceRequest::glueInvocationRoleArn)).setter(CreateCustomLogSourceRequest.setter(Builder::glueInvocationRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glueInvocationRoleArn").build()}).build();
    private static final SdkField<String> LOG_PROVIDER_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logProviderAccountId").getter(CreateCustomLogSourceRequest.getter(CreateCustomLogSourceRequest::logProviderAccountId)).setter(CreateCustomLogSourceRequest.setter(Builder::logProviderAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logProviderAccountId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_SOURCE_NAME_FIELD, EVENT_CLASS_FIELD, GLUE_INVOCATION_ROLE_ARN_FIELD, LOG_PROVIDER_ACCOUNT_ID_FIELD));
    private final String customSourceName;
    private final String eventClass;
    private final String glueInvocationRoleArn;
    private final String logProviderAccountId;

    private CreateCustomLogSourceRequest(BuilderImpl builder) {
        super(builder);
        this.customSourceName = builder.customSourceName;
        this.eventClass = builder.eventClass;
        this.glueInvocationRoleArn = builder.glueInvocationRoleArn;
        this.logProviderAccountId = builder.logProviderAccountId;
    }

    public final String customSourceName() {
        return this.customSourceName;
    }

    public final OcsfEventClass eventClass() {
        return OcsfEventClass.fromValue(this.eventClass);
    }

    public final String eventClassAsString() {
        return this.eventClass;
    }

    public final String glueInvocationRoleArn() {
        return this.glueInvocationRoleArn;
    }

    public final String logProviderAccountId() {
        return this.logProviderAccountId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.customSourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.glueInvocationRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.logProviderAccountId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCustomLogSourceRequest)) {
            return false;
        }
        CreateCustomLogSourceRequest other = (CreateCustomLogSourceRequest)((Object)obj);
        return Objects.equals(this.customSourceName(), other.customSourceName()) && Objects.equals(this.eventClassAsString(), other.eventClassAsString()) && Objects.equals(this.glueInvocationRoleArn(), other.glueInvocationRoleArn()) && Objects.equals(this.logProviderAccountId(), other.logProviderAccountId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCustomLogSourceRequest").add("CustomSourceName", (Object)this.customSourceName()).add("EventClass", (Object)this.eventClassAsString()).add("GlueInvocationRoleArn", (Object)this.glueInvocationRoleArn()).add("LogProviderAccountId", (Object)this.logProviderAccountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "customSourceName": {
                return Optional.ofNullable(clazz.cast(this.customSourceName()));
            }
            case "eventClass": {
                return Optional.ofNullable(clazz.cast(this.eventClassAsString()));
            }
            case "glueInvocationRoleArn": {
                return Optional.ofNullable(clazz.cast(this.glueInvocationRoleArn()));
            }
            case "logProviderAccountId": {
                return Optional.ofNullable(clazz.cast(this.logProviderAccountId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCustomLogSourceRequest, T> g) {
        return obj -> g.apply((CreateCustomLogSourceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityLakeRequest.BuilderImpl
    implements Builder {
        private String customSourceName;
        private String eventClass;
        private String glueInvocationRoleArn;
        private String logProviderAccountId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCustomLogSourceRequest model) {
            super(model);
            this.customSourceName(model.customSourceName);
            this.eventClass(model.eventClass);
            this.glueInvocationRoleArn(model.glueInvocationRoleArn);
            this.logProviderAccountId(model.logProviderAccountId);
        }

        public final String getCustomSourceName() {
            return this.customSourceName;
        }

        public final void setCustomSourceName(String customSourceName) {
            this.customSourceName = customSourceName;
        }

        @Override
        public final Builder customSourceName(String customSourceName) {
            this.customSourceName = customSourceName;
            return this;
        }

        public final String getEventClass() {
            return this.eventClass;
        }

        public final void setEventClass(String eventClass) {
            this.eventClass = eventClass;
        }

        @Override
        public final Builder eventClass(String eventClass) {
            this.eventClass = eventClass;
            return this;
        }

        @Override
        public final Builder eventClass(OcsfEventClass eventClass) {
            this.eventClass(eventClass == null ? null : eventClass.toString());
            return this;
        }

        public final String getGlueInvocationRoleArn() {
            return this.glueInvocationRoleArn;
        }

        public final void setGlueInvocationRoleArn(String glueInvocationRoleArn) {
            this.glueInvocationRoleArn = glueInvocationRoleArn;
        }

        @Override
        public final Builder glueInvocationRoleArn(String glueInvocationRoleArn) {
            this.glueInvocationRoleArn = glueInvocationRoleArn;
            return this;
        }

        public final String getLogProviderAccountId() {
            return this.logProviderAccountId;
        }

        public final void setLogProviderAccountId(String logProviderAccountId) {
            this.logProviderAccountId = logProviderAccountId;
        }

        @Override
        public final Builder logProviderAccountId(String logProviderAccountId) {
            this.logProviderAccountId = logProviderAccountId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCustomLogSourceRequest build() {
            return new CreateCustomLogSourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SecurityLakeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCustomLogSourceRequest> {
        public Builder customSourceName(String var1);

        public Builder eventClass(String var1);

        public Builder eventClass(OcsfEventClass var1);

        public Builder glueInvocationRoleArn(String var1);

        public Builder logProviderAccountId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

