/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securitylake.model.Failures;
import software.amazon.awssdk.services.securitylake.model.FailureslistCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FailuresResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FailuresResponse> {
    private static final SdkField<List<Failures>> FAILURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failures").getter(FailuresResponse.getter(FailuresResponse::failures)).setter(FailuresResponse.setter(Builder::failures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failures").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Failures::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("region").getter(FailuresResponse.getter(FailuresResponse::region)).setter(FailuresResponse.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILURES_FIELD, REGION_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<Failures> failures;
    private final String region;

    private FailuresResponse(BuilderImpl builder) {
        this.failures = builder.failures;
        this.region = builder.region;
    }

    public final boolean hasFailures() {
        return this.failures != null && !(this.failures instanceof SdkAutoConstructList);
    }

    public final List<Failures> failures() {
        return this.failures;
    }

    public final String region() {
        return this.region;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailures() ? this.failures() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailuresResponse)) {
            return false;
        }
        FailuresResponse other = (FailuresResponse)obj;
        return this.hasFailures() == other.hasFailures() && Objects.equals(this.failures(), other.failures()) && Objects.equals(this.region(), other.region());
    }

    public final String toString() {
        return ToString.builder((String)"FailuresResponse").add("Failures", this.hasFailures() ? this.failures() : null).add("Region", (Object)this.region()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "failures": {
                return Optional.ofNullable(clazz.cast(this.failures()));
            }
            case "region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FailuresResponse, T> g) {
        return obj -> g.apply((FailuresResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Failures> failures = DefaultSdkAutoConstructList.getInstance();
        private String region;

        private BuilderImpl() {
        }

        private BuilderImpl(FailuresResponse model) {
            this.failures(model.failures);
            this.region(model.region);
        }

        public final List<Failures.Builder> getFailures() {
            List<Failures.Builder> result = FailureslistCopier.copyToBuilder(this.failures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailures(Collection<Failures.BuilderImpl> failures) {
            this.failures = FailureslistCopier.copyFromBuilder(failures);
        }

        @Override
        public final Builder failures(Collection<Failures> failures) {
            this.failures = FailureslistCopier.copy(failures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(Failures ... failures) {
            this.failures(Arrays.asList(failures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(Consumer<Failures.Builder> ... failures) {
            this.failures(Stream.of(failures).map(c -> (Failures)((Failures.Builder)Failures.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public FailuresResponse build() {
            return new FailuresResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FailuresResponse> {
        public Builder failures(Collection<Failures> var1);

        public Builder failures(Failures ... var1);

        public Builder failures(Consumer<Failures.Builder> ... var1);

        public Builder region(String var1);
    }
}

