/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AwsLogSourceName {
    ROUTE53("ROUTE53"),
    VPC_FLOW("VPC_FLOW"),
    SH_FINDINGS("SH_FINDINGS"),
    CLOUD_TRAIL_MGMT("CLOUD_TRAIL_MGMT"),
    LAMBDA_EXECUTION("LAMBDA_EXECUTION"),
    S3_DATA("S3_DATA"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AwsLogSourceName> VALUE_MAP;
    private final String value;

    private AwsLogSourceName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AwsLogSourceName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AwsLogSourceName> knownValues() {
        EnumSet<AwsLogSourceName> knownValues = EnumSet.allOf(AwsLogSourceName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AwsLogSourceName.class, AwsLogSourceName::toString);
    }
}

