/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OcsfEventClass {
    ACCESS_ACTIVITY("ACCESS_ACTIVITY"),
    FILE_ACTIVITY("FILE_ACTIVITY"),
    KERNEL_ACTIVITY("KERNEL_ACTIVITY"),
    KERNEL_EXTENSION("KERNEL_EXTENSION"),
    MEMORY_ACTIVITY("MEMORY_ACTIVITY"),
    MODULE_ACTIVITY("MODULE_ACTIVITY"),
    PROCESS_ACTIVITY("PROCESS_ACTIVITY"),
    REGISTRY_KEY_ACTIVITY("REGISTRY_KEY_ACTIVITY"),
    REGISTRY_VALUE_ACTIVITY("REGISTRY_VALUE_ACTIVITY"),
    RESOURCE_ACTIVITY("RESOURCE_ACTIVITY"),
    SCHEDULED_JOB_ACTIVITY("SCHEDULED_JOB_ACTIVITY"),
    SECURITY_FINDING("SECURITY_FINDING"),
    ACCOUNT_CHANGE("ACCOUNT_CHANGE"),
    AUTHENTICATION("AUTHENTICATION"),
    AUTHORIZATION("AUTHORIZATION"),
    ENTITY_MANAGEMENT_AUDIT("ENTITY_MANAGEMENT_AUDIT"),
    DHCP_ACTIVITY("DHCP_ACTIVITY"),
    NETWORK_ACTIVITY("NETWORK_ACTIVITY"),
    DNS_ACTIVITY("DNS_ACTIVITY"),
    FTP_ACTIVITY("FTP_ACTIVITY"),
    HTTP_ACTIVITY("HTTP_ACTIVITY"),
    RDP_ACTIVITY("RDP_ACTIVITY"),
    SMB_ACTIVITY("SMB_ACTIVITY"),
    SSH_ACTIVITY("SSH_ACTIVITY"),
    CLOUD_API("CLOUD_API"),
    CONTAINER_LIFECYCLE("CONTAINER_LIFECYCLE"),
    DATABASE_LIFECYCLE("DATABASE_LIFECYCLE"),
    CONFIG_STATE("CONFIG_STATE"),
    CLOUD_STORAGE("CLOUD_STORAGE"),
    INVENTORY_INFO("INVENTORY_INFO"),
    RFB_ACTIVITY("RFB_ACTIVITY"),
    SMTP_ACTIVITY("SMTP_ACTIVITY"),
    VIRTUAL_MACHINE_ACTIVITY("VIRTUAL_MACHINE_ACTIVITY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OcsfEventClass> VALUE_MAP;
    private final String value;

    private OcsfEventClass(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OcsfEventClass fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OcsfEventClass> knownValues() {
        EnumSet<OcsfEventClass> knownValues = EnumSet.allOf(OcsfEventClass.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OcsfEventClass.class, OcsfEventClass::toString);
    }
}

