/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AwsLogSourceType {
    ROUTE53("ROUTE53"),
    VPC_FLOW("VPC_FLOW"),
    CLOUD_TRAIL("CLOUD_TRAIL"),
    SH_FINDINGS("SH_FINDINGS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AwsLogSourceType> VALUE_MAP;
    private final String value;

    private AwsLogSourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AwsLogSourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AwsLogSourceType> knownValues() {
        EnumSet<AwsLogSourceType> knownValues = EnumSet.allOf(AwsLogSourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AwsLogSourceType.class, AwsLogSourceType::toString);
    }
}

