/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securitylake.SecurityLakeAsyncClient;
import software.amazon.awssdk.services.securitylake.model.FailuresResponse;
import software.amazon.awssdk.services.securitylake.model.ListDatalakeExceptionsRequest;
import software.amazon.awssdk.services.securitylake.model.ListDatalakeExceptionsResponse;

public class ListDatalakeExceptionsPublisher
implements SdkPublisher<ListDatalakeExceptionsResponse> {
    private final SecurityLakeAsyncClient client;
    private final ListDatalakeExceptionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDatalakeExceptionsPublisher(SecurityLakeAsyncClient client, ListDatalakeExceptionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDatalakeExceptionsPublisher(SecurityLakeAsyncClient client, ListDatalakeExceptionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDatalakeExceptionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDatalakeExceptionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FailuresResponse> nonRetryableFailures() {
        Function<ListDatalakeExceptionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.nonRetryableFailures() != null) {
                return response.nonRetryableFailures().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDatalakeExceptionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDatalakeExceptionsResponseFetcher
    implements AsyncPageFetcher<ListDatalakeExceptionsResponse> {
        private ListDatalakeExceptionsResponseFetcher() {
        }

        public boolean hasNextPage(ListDatalakeExceptionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDatalakeExceptionsResponse> nextPage(ListDatalakeExceptionsResponse previousPage) {
            if (previousPage == null) {
                return ListDatalakeExceptionsPublisher.this.client.listDatalakeExceptions(ListDatalakeExceptionsPublisher.this.firstRequest);
            }
            return ListDatalakeExceptionsPublisher.this.client.listDatalakeExceptions((ListDatalakeExceptionsRequest)((Object)ListDatalakeExceptionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

