/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securitylake.model.RegionSourceTypesAccountsListCopier;
import software.amazon.awssdk.services.securitylake.model.SecurityLakeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListLogSourcesResponse
extends SecurityLakeResponse
implements ToCopyableBuilder<Builder, ListLogSourcesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListLogSourcesResponse.getter(ListLogSourcesResponse::nextToken)).setter(ListLogSourcesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<Map<String, Map<String, List<String>>>>> REGION_SOURCE_TYPES_ACCOUNTS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("regionSourceTypesAccountsList").getter(ListLogSourcesResponse.getter(ListLogSourcesResponse::regionSourceTypesAccountsList)).setter(ListLogSourcesResponse.setter(Builder::regionSourceTypesAccountsList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionSourceTypesAccountsList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.MAP).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.MAP).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, REGION_SOURCE_TYPES_ACCOUNTS_LIST_FIELD));
    private final String nextToken;
    private final List<Map<String, Map<String, List<String>>>> regionSourceTypesAccountsList;

    private ListLogSourcesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.regionSourceTypesAccountsList = builder.regionSourceTypesAccountsList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasRegionSourceTypesAccountsList() {
        return this.regionSourceTypesAccountsList != null && !(this.regionSourceTypesAccountsList instanceof SdkAutoConstructList);
    }

    public final List<Map<String, Map<String, List<String>>>> regionSourceTypesAccountsList() {
        return this.regionSourceTypesAccountsList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegionSourceTypesAccountsList() ? this.regionSourceTypesAccountsList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLogSourcesResponse)) {
            return false;
        }
        ListLogSourcesResponse other = (ListLogSourcesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasRegionSourceTypesAccountsList() == other.hasRegionSourceTypesAccountsList() && Objects.equals(this.regionSourceTypesAccountsList(), other.regionSourceTypesAccountsList());
    }

    public final String toString() {
        return ToString.builder((String)"ListLogSourcesResponse").add("NextToken", (Object)this.nextToken()).add("RegionSourceTypesAccountsList", this.hasRegionSourceTypesAccountsList() ? this.regionSourceTypesAccountsList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "regionSourceTypesAccountsList": {
                return Optional.ofNullable(clazz.cast(this.regionSourceTypesAccountsList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLogSourcesResponse, T> g) {
        return obj -> g.apply((ListLogSourcesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityLakeResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<Map<String, Map<String, List<String>>>> regionSourceTypesAccountsList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListLogSourcesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.regionSourceTypesAccountsList(model.regionSourceTypesAccountsList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Collection<? extends Map<String, ? extends Map<String, ? extends Collection<String>>>> getRegionSourceTypesAccountsList() {
            if (this.regionSourceTypesAccountsList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.regionSourceTypesAccountsList;
        }

        public final void setRegionSourceTypesAccountsList(Collection<? extends Map<String, ? extends Map<String, ? extends Collection<String>>>> regionSourceTypesAccountsList) {
            this.regionSourceTypesAccountsList = RegionSourceTypesAccountsListCopier.copy(regionSourceTypesAccountsList);
        }

        @Override
        public final Builder regionSourceTypesAccountsList(Collection<? extends Map<String, ? extends Map<String, ? extends Collection<String>>>> regionSourceTypesAccountsList) {
            this.regionSourceTypesAccountsList = RegionSourceTypesAccountsListCopier.copy(regionSourceTypesAccountsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regionSourceTypesAccountsList(Map<String, ? extends Map<String, ? extends Collection<String>>> ... regionSourceTypesAccountsList) {
            this.regionSourceTypesAccountsList(Arrays.asList(regionSourceTypesAccountsList));
            return this;
        }

        @Override
        public ListLogSourcesResponse build() {
            return new ListLogSourcesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SecurityLakeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListLogSourcesResponse> {
        public Builder nextToken(String var1);

        public Builder regionSourceTypesAccountsList(Collection<? extends Map<String, ? extends Map<String, ? extends Collection<String>>>> var1);

        public Builder regionSourceTypesAccountsList(Map<String, ? extends Map<String, ? extends Collection<String>>> ... var1);
    }
}

