/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityir.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityir.model.InvestigationAction;
import software.amazon.awssdk.services.securityir.model.InvestigationActionListCopier;
import software.amazon.awssdk.services.securityir.model.SecurityIrResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListInvestigationsResponse
extends SecurityIrResponse
implements ToCopyableBuilder<Builder, ListInvestigationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListInvestigationsResponse.getter(ListInvestigationsResponse::nextToken)).setter(ListInvestigationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<InvestigationAction>> INVESTIGATION_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("investigationActions").getter(ListInvestigationsResponse.getter(ListInvestigationsResponse::investigationActions)).setter(ListInvestigationsResponse.setter(Builder::investigationActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("investigationActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InvestigationAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, INVESTIGATION_ACTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListInvestigationsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<InvestigationAction> investigationActions;

    private ListInvestigationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.investigationActions = builder.investigationActions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasInvestigationActions() {
        return this.investigationActions != null && !(this.investigationActions instanceof SdkAutoConstructList);
    }

    public final List<InvestigationAction> investigationActions() {
        return this.investigationActions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInvestigationActions() ? this.investigationActions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInvestigationsResponse)) {
            return false;
        }
        ListInvestigationsResponse other = (ListInvestigationsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasInvestigationActions() == other.hasInvestigationActions() && Objects.equals(this.investigationActions(), other.investigationActions());
    }

    public final String toString() {
        return ToString.builder((String)"ListInvestigationsResponse").add("NextToken", (Object)this.nextToken()).add("InvestigationActions", this.hasInvestigationActions() ? this.investigationActions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "investigationActions": {
                return Optional.ofNullable(clazz.cast(this.investigationActions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("investigationActions", INVESTIGATION_ACTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListInvestigationsResponse, T> g) {
        return obj -> g.apply((ListInvestigationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityIrResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<InvestigationAction> investigationActions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListInvestigationsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.investigationActions(model.investigationActions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<InvestigationAction.Builder> getInvestigationActions() {
            List<InvestigationAction.Builder> result = InvestigationActionListCopier.copyToBuilder(this.investigationActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInvestigationActions(Collection<InvestigationAction.BuilderImpl> investigationActions) {
            this.investigationActions = InvestigationActionListCopier.copyFromBuilder(investigationActions);
        }

        @Override
        public final Builder investigationActions(Collection<InvestigationAction> investigationActions) {
            this.investigationActions = InvestigationActionListCopier.copy(investigationActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder investigationActions(InvestigationAction ... investigationActions) {
            this.investigationActions(Arrays.asList(investigationActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder investigationActions(Consumer<InvestigationAction.Builder> ... investigationActions) {
            this.investigationActions(Stream.of(investigationActions).map(c -> (InvestigationAction)((InvestigationAction.Builder)InvestigationAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListInvestigationsResponse build() {
            return new ListInvestigationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SecurityIrResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListInvestigationsResponse> {
        public Builder nextToken(String var1);

        public Builder investigationActions(Collection<InvestigationAction> var1);

        public Builder investigationActions(InvestigationAction ... var1);

        public Builder investigationActions(Consumer<InvestigationAction.Builder> ... var1);
    }
}

