/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityir.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityir.model.CommunicationPreferencesCopier;
import software.amazon.awssdk.services.securityir.model.CommunicationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IncidentResponder
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IncidentResponder> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(IncidentResponder.getter(IncidentResponder::name)).setter(IncidentResponder.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> JOB_TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobTitle").getter(IncidentResponder.getter(IncidentResponder::jobTitle)).setter(IncidentResponder.setter(Builder::jobTitle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobTitle").build()}).build();
    private static final SdkField<String> EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("email").getter(IncidentResponder.getter(IncidentResponder::email)).setter(IncidentResponder.setter(Builder::email)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("email").build()}).build();
    private static final SdkField<List<String>> COMMUNICATION_PREFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("communicationPreferences").getter(IncidentResponder.getter(IncidentResponder::communicationPreferencesAsStrings)).setter(IncidentResponder.setter(Builder::communicationPreferencesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("communicationPreferences").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, JOB_TITLE_FIELD, EMAIL_FIELD, COMMUNICATION_PREFERENCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IncidentResponder.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String jobTitle;
    private final String email;
    private final List<String> communicationPreferences;

    private IncidentResponder(BuilderImpl builder) {
        this.name = builder.name;
        this.jobTitle = builder.jobTitle;
        this.email = builder.email;
        this.communicationPreferences = builder.communicationPreferences;
    }

    public final String name() {
        return this.name;
    }

    public final String jobTitle() {
        return this.jobTitle;
    }

    public final String email() {
        return this.email;
    }

    public final List<CommunicationType> communicationPreferences() {
        return CommunicationPreferencesCopier.copyStringToEnum(this.communicationPreferences);
    }

    public final boolean hasCommunicationPreferences() {
        return this.communicationPreferences != null && !(this.communicationPreferences instanceof SdkAutoConstructList);
    }

    public final List<String> communicationPreferencesAsStrings() {
        return this.communicationPreferences;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobTitle());
        hashCode = 31 * hashCode + Objects.hashCode(this.email());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCommunicationPreferences() ? this.communicationPreferencesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IncidentResponder)) {
            return false;
        }
        IncidentResponder other = (IncidentResponder)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.jobTitle(), other.jobTitle()) && Objects.equals(this.email(), other.email()) && this.hasCommunicationPreferences() == other.hasCommunicationPreferences() && Objects.equals(this.communicationPreferencesAsStrings(), other.communicationPreferencesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"IncidentResponder").add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("JobTitle", (Object)(this.jobTitle() == null ? null : "*** Sensitive Data Redacted ***")).add("Email", (Object)(this.email() == null ? null : "*** Sensitive Data Redacted ***")).add("CommunicationPreferences", this.hasCommunicationPreferences() ? this.communicationPreferencesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "jobTitle": {
                return Optional.ofNullable(clazz.cast(this.jobTitle()));
            }
            case "email": {
                return Optional.ofNullable(clazz.cast(this.email()));
            }
            case "communicationPreferences": {
                return Optional.ofNullable(clazz.cast(this.communicationPreferencesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("jobTitle", JOB_TITLE_FIELD);
        map.put("email", EMAIL_FIELD);
        map.put("communicationPreferences", COMMUNICATION_PREFERENCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IncidentResponder, T> g) {
        return obj -> g.apply((IncidentResponder)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String jobTitle;
        private String email;
        private List<String> communicationPreferences = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IncidentResponder model) {
            this.name(model.name);
            this.jobTitle(model.jobTitle);
            this.email(model.email);
            this.communicationPreferencesWithStrings(model.communicationPreferences);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getJobTitle() {
            return this.jobTitle;
        }

        public final void setJobTitle(String jobTitle) {
            this.jobTitle = jobTitle;
        }

        @Override
        public final Builder jobTitle(String jobTitle) {
            this.jobTitle = jobTitle;
            return this;
        }

        public final String getEmail() {
            return this.email;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final Collection<String> getCommunicationPreferences() {
            if (this.communicationPreferences instanceof SdkAutoConstructList) {
                return null;
            }
            return this.communicationPreferences;
        }

        public final void setCommunicationPreferences(Collection<String> communicationPreferences) {
            this.communicationPreferences = CommunicationPreferencesCopier.copy(communicationPreferences);
        }

        @Override
        public final Builder communicationPreferencesWithStrings(Collection<String> communicationPreferences) {
            this.communicationPreferences = CommunicationPreferencesCopier.copy(communicationPreferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder communicationPreferencesWithStrings(String ... communicationPreferences) {
            this.communicationPreferencesWithStrings(Arrays.asList(communicationPreferences));
            return this;
        }

        @Override
        public final Builder communicationPreferences(Collection<CommunicationType> communicationPreferences) {
            this.communicationPreferences = CommunicationPreferencesCopier.copyEnumToString(communicationPreferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder communicationPreferences(CommunicationType ... communicationPreferences) {
            this.communicationPreferences(Arrays.asList(communicationPreferences));
            return this;
        }

        public IncidentResponder build() {
            return new IncidentResponder(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IncidentResponder> {
        public Builder name(String var1);

        public Builder jobTitle(String var1);

        public Builder email(String var1);

        public Builder communicationPreferencesWithStrings(Collection<String> var1);

        public Builder communicationPreferencesWithStrings(String ... var1);

        public Builder communicationPreferences(Collection<CommunicationType> var1);

        public Builder communicationPreferences(CommunicationType ... var1);
    }
}

