/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityir.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CommunicationType {
    CASE_CREATED("Case Created"),
    CASE_UPDATED("Case Updated"),
    CASE_ACKNOWLEDGED("Case Acknowledged"),
    CASE_CLOSED("Case Closed"),
    CASE_UPDATED_TO_SERVICE_MANAGED("Case Updated To Service Managed"),
    CASE_STATUS_UPDATED("Case Status Updated"),
    CASE_PENDING_CUSTOMER_ACTION_REMINDER("Case Pending Customer Action Reminder"),
    CASE_ATTACHMENT_URL_UPLOADED("Case Attachment Url Uploaded"),
    CASE_COMMENT_ADDED("Case Comment Added"),
    CASE_COMMENT_UPDATED("Case Comment Updated"),
    MEMBERSHIP_CREATED("Membership Created"),
    MEMBERSHIP_UPDATED("Membership Updated"),
    MEMBERSHIP_CANCELLED("Membership Cancelled"),
    REGISTER_DELEGATED_ADMINISTRATOR("Register Delegated Administrator"),
    DEREGISTER_DELEGATED_ADMINISTRATOR("Deregister Delegated Administrator"),
    DISABLE_AWS_SERVICE_ACCESS("Disable AWS Service Access"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CommunicationType> VALUE_MAP;
    private final String value;

    private CommunicationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CommunicationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CommunicationType> knownValues() {
        EnumSet<CommunicationType> knownValues = EnumSet.allOf(CommunicationType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CommunicationType.class, CommunicationType::toString);
    }
}

