/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityir.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendFeedbackRequest extends SecurityIrRequest implements
        ToCopyableBuilder<SendFeedbackRequest.Builder, SendFeedbackRequest> {
    private static final SdkField<String> CASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("caseId")
            .getter(getter(SendFeedbackRequest::caseId)).setter(setter(Builder::caseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("caseId").build()).build();

    private static final SdkField<String> RESULT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resultId").getter(getter(SendFeedbackRequest::resultId)).setter(setter(Builder::resultId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("resultId").build()).build();

    private static final SdkField<String> USEFULNESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("usefulness").getter(getter(SendFeedbackRequest::usefulnessAsString)).setter(setter(Builder::usefulness))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usefulness").build()).build();

    private static final SdkField<String> COMMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("comment")
            .getter(getter(SendFeedbackRequest::comment)).setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CASE_ID_FIELD,
            RESULT_ID_FIELD, USEFULNESS_FIELD, COMMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String caseId;

    private final String resultId;

    private final String usefulness;

    private final String comment;

    private SendFeedbackRequest(BuilderImpl builder) {
        super(builder);
        this.caseId = builder.caseId;
        this.resultId = builder.resultId;
        this.usefulness = builder.usefulness;
        this.comment = builder.comment;
    }

    /**
     * <p>
     * Send feedback based on request caseID
     * </p>
     * 
     * @return Send feedback based on request caseID
     */
    public final String caseId() {
        return caseId;
    }

    /**
     * <p>
     * Send feedback based on request result ID
     * </p>
     * 
     * @return Send feedback based on request result ID
     */
    public final String resultId() {
        return resultId;
    }

    /**
     * <p>
     * Required enum value indicating user assessment of result q.....
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #usefulness} will
     * return {@link UsefulnessRating#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #usefulnessAsString}.
     * </p>
     * 
     * @return Required enum value indicating user assessment of result q.....
     * @see UsefulnessRating
     */
    public final UsefulnessRating usefulness() {
        return UsefulnessRating.fromValue(usefulness);
    }

    /**
     * <p>
     * Required enum value indicating user assessment of result q.....
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #usefulness} will
     * return {@link UsefulnessRating#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #usefulnessAsString}.
     * </p>
     * 
     * @return Required enum value indicating user assessment of result q.....
     * @see UsefulnessRating
     */
    public final String usefulnessAsString() {
        return usefulness;
    }

    /**
     * <p>
     * Send feedback based on request comments
     * </p>
     * 
     * @return Send feedback based on request comments
     */
    public final String comment() {
        return comment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(caseId());
        hashCode = 31 * hashCode + Objects.hashCode(resultId());
        hashCode = 31 * hashCode + Objects.hashCode(usefulnessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendFeedbackRequest)) {
            return false;
        }
        SendFeedbackRequest other = (SendFeedbackRequest) obj;
        return Objects.equals(caseId(), other.caseId()) && Objects.equals(resultId(), other.resultId())
                && Objects.equals(usefulnessAsString(), other.usefulnessAsString()) && Objects.equals(comment(), other.comment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SendFeedbackRequest").add("CaseId", caseId()).add("ResultId", resultId())
                .add("Usefulness", usefulnessAsString()).add("Comment", comment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "caseId":
            return Optional.ofNullable(clazz.cast(caseId()));
        case "resultId":
            return Optional.ofNullable(clazz.cast(resultId()));
        case "usefulness":
            return Optional.ofNullable(clazz.cast(usefulnessAsString()));
        case "comment":
            return Optional.ofNullable(clazz.cast(comment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("caseId", CASE_ID_FIELD);
        map.put("resultId", RESULT_ID_FIELD);
        map.put("usefulness", USEFULNESS_FIELD);
        map.put("comment", COMMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SendFeedbackRequest, T> g) {
        return obj -> g.apply((SendFeedbackRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SecurityIrRequest.Builder, SdkPojo, CopyableBuilder<Builder, SendFeedbackRequest> {
        /**
         * <p>
         * Send feedback based on request caseID
         * </p>
         * 
         * @param caseId
         *        Send feedback based on request caseID
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caseId(String caseId);

        /**
         * <p>
         * Send feedback based on request result ID
         * </p>
         * 
         * @param resultId
         *        Send feedback based on request result ID
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultId(String resultId);

        /**
         * <p>
         * Required enum value indicating user assessment of result q.....
         * </p>
         * 
         * @param usefulness
         *        Required enum value indicating user assessment of result q.....
         * @see UsefulnessRating
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UsefulnessRating
         */
        Builder usefulness(String usefulness);

        /**
         * <p>
         * Required enum value indicating user assessment of result q.....
         * </p>
         * 
         * @param usefulness
         *        Required enum value indicating user assessment of result q.....
         * @see UsefulnessRating
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UsefulnessRating
         */
        Builder usefulness(UsefulnessRating usefulness);

        /**
         * <p>
         * Send feedback based on request comments
         * </p>
         * 
         * @param comment
         *        Send feedback based on request comments
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityIrRequest.BuilderImpl implements Builder {
        private String caseId;

        private String resultId;

        private String usefulness;

        private String comment;

        private BuilderImpl() {
        }

        private BuilderImpl(SendFeedbackRequest model) {
            super(model);
            caseId(model.caseId);
            resultId(model.resultId);
            usefulness(model.usefulness);
            comment(model.comment);
        }

        public final String getCaseId() {
            return caseId;
        }

        public final void setCaseId(String caseId) {
            this.caseId = caseId;
        }

        @Override
        public final Builder caseId(String caseId) {
            this.caseId = caseId;
            return this;
        }

        public final String getResultId() {
            return resultId;
        }

        public final void setResultId(String resultId) {
            this.resultId = resultId;
        }

        @Override
        public final Builder resultId(String resultId) {
            this.resultId = resultId;
            return this;
        }

        public final String getUsefulness() {
            return usefulness;
        }

        public final void setUsefulness(String usefulness) {
            this.usefulness = usefulness;
        }

        @Override
        public final Builder usefulness(String usefulness) {
            this.usefulness = usefulness;
            return this;
        }

        @Override
        public final Builder usefulness(UsefulnessRating usefulness) {
            this.usefulness(usefulness == null ? null : usefulness.toString());
            return this;
        }

        public final String getComment() {
            return comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendFeedbackRequest build() {
            return new SendFeedbackRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
