/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityir.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCommentsItem implements SdkPojo, Serializable,
        ToCopyableBuilder<ListCommentsItem.Builder, ListCommentsItem> {
    private static final SdkField<String> COMMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("commentId").getter(getter(ListCommentsItem::commentId)).setter(setter(Builder::commentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commentId").build()).build();

    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdDate").getter(getter(ListCommentsItem::createdDate)).setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDate").getter(getter(ListCommentsItem::lastUpdatedDate))
            .setter(setter(Builder::lastUpdatedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDate").build()).build();

    private static final SdkField<String> CREATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("creator")
            .getter(getter(ListCommentsItem::creator)).setter(setter(Builder::creator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creator").build()).build();

    private static final SdkField<String> LAST_UPDATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastUpdatedBy").getter(getter(ListCommentsItem::lastUpdatedBy)).setter(setter(Builder::lastUpdatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedBy").build()).build();

    private static final SdkField<String> BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("body")
            .getter(getter(ListCommentsItem::body)).setter(setter(Builder::body))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("body").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMENT_ID_FIELD,
            CREATED_DATE_FIELD, LAST_UPDATED_DATE_FIELD, CREATOR_FIELD, LAST_UPDATED_BY_FIELD, BODY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String commentId;

    private final Instant createdDate;

    private final Instant lastUpdatedDate;

    private final String creator;

    private final String lastUpdatedBy;

    private final String body;

    private ListCommentsItem(BuilderImpl builder) {
        this.commentId = builder.commentId;
        this.createdDate = builder.createdDate;
        this.lastUpdatedDate = builder.lastUpdatedDate;
        this.creator = builder.creator;
        this.lastUpdatedBy = builder.lastUpdatedBy;
        this.body = builder.body;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String commentId() {
        return commentId;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final Instant createdDate() {
        return createdDate;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final Instant lastUpdatedDate() {
        return lastUpdatedDate;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String creator() {
        return creator;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String lastUpdatedBy() {
        return lastUpdatedBy;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String body() {
        return body;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(commentId());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(creator());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(body());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCommentsItem)) {
            return false;
        }
        ListCommentsItem other = (ListCommentsItem) obj;
        return Objects.equals(commentId(), other.commentId()) && Objects.equals(createdDate(), other.createdDate())
                && Objects.equals(lastUpdatedDate(), other.lastUpdatedDate()) && Objects.equals(creator(), other.creator())
                && Objects.equals(lastUpdatedBy(), other.lastUpdatedBy()) && Objects.equals(body(), other.body());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCommentsItem").add("CommentId", commentId()).add("CreatedDate", createdDate())
                .add("LastUpdatedDate", lastUpdatedDate()).add("Creator", creator()).add("LastUpdatedBy", lastUpdatedBy())
                .add("Body", body() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "commentId":
            return Optional.ofNullable(clazz.cast(commentId()));
        case "createdDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "lastUpdatedDate":
            return Optional.ofNullable(clazz.cast(lastUpdatedDate()));
        case "creator":
            return Optional.ofNullable(clazz.cast(creator()));
        case "lastUpdatedBy":
            return Optional.ofNullable(clazz.cast(lastUpdatedBy()));
        case "body":
            return Optional.ofNullable(clazz.cast(body()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("commentId", COMMENT_ID_FIELD);
        map.put("createdDate", CREATED_DATE_FIELD);
        map.put("lastUpdatedDate", LAST_UPDATED_DATE_FIELD);
        map.put("creator", CREATOR_FIELD);
        map.put("lastUpdatedBy", LAST_UPDATED_BY_FIELD);
        map.put("body", BODY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCommentsItem, T> g) {
        return obj -> g.apply((ListCommentsItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListCommentsItem> {
        /**
         * <p/>
         * 
         * @param commentId
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commentId(String commentId);

        /**
         * <p/>
         * 
         * @param createdDate
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p/>
         * 
         * @param lastUpdatedDate
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDate(Instant lastUpdatedDate);

        /**
         * <p/>
         * 
         * @param creator
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creator(String creator);

        /**
         * <p/>
         * 
         * @param lastUpdatedBy
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedBy(String lastUpdatedBy);

        /**
         * <p/>
         * 
         * @param body
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder body(String body);
    }

    static final class BuilderImpl implements Builder {
        private String commentId;

        private Instant createdDate;

        private Instant lastUpdatedDate;

        private String creator;

        private String lastUpdatedBy;

        private String body;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCommentsItem model) {
            commentId(model.commentId);
            createdDate(model.createdDate);
            lastUpdatedDate(model.lastUpdatedDate);
            creator(model.creator);
            lastUpdatedBy(model.lastUpdatedBy);
            body(model.body);
        }

        public final String getCommentId() {
            return commentId;
        }

        public final void setCommentId(String commentId) {
            this.commentId = commentId;
        }

        @Override
        public final Builder commentId(String commentId) {
            this.commentId = commentId;
            return this;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final Instant getLastUpdatedDate() {
            return lastUpdatedDate;
        }

        public final void setLastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        @Override
        public final Builder lastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        public final String getCreator() {
            return creator;
        }

        public final void setCreator(String creator) {
            this.creator = creator;
        }

        @Override
        public final Builder creator(String creator) {
            this.creator = creator;
            return this;
        }

        public final String getLastUpdatedBy() {
            return lastUpdatedBy;
        }

        public final void setLastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
        }

        @Override
        public final Builder lastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
            return this;
        }

        public final String getBody() {
            return body;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        @Override
        public ListCommentsItem build() {
            return new ListCommentsItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
