/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityir.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCaseAttachmentDownloadUrlResponse extends SecurityIrResponse implements
        ToCopyableBuilder<GetCaseAttachmentDownloadUrlResponse.Builder, GetCaseAttachmentDownloadUrlResponse> {
    private static final SdkField<String> ATTACHMENT_PRESIGNED_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("attachmentPresignedUrl").getter(getter(GetCaseAttachmentDownloadUrlResponse::attachmentPresignedUrl))
            .setter(setter(Builder::attachmentPresignedUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachmentPresignedUrl").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ATTACHMENT_PRESIGNED_URL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String attachmentPresignedUrl;

    private GetCaseAttachmentDownloadUrlResponse(BuilderImpl builder) {
        super(builder);
        this.attachmentPresignedUrl = builder.attachmentPresignedUrl;
    }

    /**
     * <p>
     * Response element providing the Amazon S3 presigned URL to download an attachment.
     * </p>
     * 
     * @return Response element providing the Amazon S3 presigned URL to download an attachment.
     */
    public final String attachmentPresignedUrl() {
        return attachmentPresignedUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(attachmentPresignedUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCaseAttachmentDownloadUrlResponse)) {
            return false;
        }
        GetCaseAttachmentDownloadUrlResponse other = (GetCaseAttachmentDownloadUrlResponse) obj;
        return Objects.equals(attachmentPresignedUrl(), other.attachmentPresignedUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCaseAttachmentDownloadUrlResponse")
                .add("AttachmentPresignedUrl", attachmentPresignedUrl() == null ? null : "*** Sensitive Data Redacted ***")
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attachmentPresignedUrl":
            return Optional.ofNullable(clazz.cast(attachmentPresignedUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("attachmentPresignedUrl", ATTACHMENT_PRESIGNED_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCaseAttachmentDownloadUrlResponse, T> g) {
        return obj -> g.apply((GetCaseAttachmentDownloadUrlResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SecurityIrResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetCaseAttachmentDownloadUrlResponse> {
        /**
         * <p>
         * Response element providing the Amazon S3 presigned URL to download an attachment.
         * </p>
         * 
         * @param attachmentPresignedUrl
         *        Response element providing the Amazon S3 presigned URL to download an attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentPresignedUrl(String attachmentPresignedUrl);
    }

    static final class BuilderImpl extends SecurityIrResponse.BuilderImpl implements Builder {
        private String attachmentPresignedUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCaseAttachmentDownloadUrlResponse model) {
            super(model);
            attachmentPresignedUrl(model.attachmentPresignedUrl);
        }

        public final String getAttachmentPresignedUrl() {
            return attachmentPresignedUrl;
        }

        public final void setAttachmentPresignedUrl(String attachmentPresignedUrl) {
            this.attachmentPresignedUrl = attachmentPresignedUrl;
        }

        @Override
        public final Builder attachmentPresignedUrl(String attachmentPresignedUrl) {
            this.attachmentPresignedUrl = attachmentPresignedUrl;
            return this;
        }

        @Override
        public GetCaseAttachmentDownloadUrlResponse build() {
            return new GetCaseAttachmentDownloadUrlResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
