/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityir.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityir.model.EngagementType;
import software.amazon.awssdk.services.securityir.model.ImpactedAccountsCopier;
import software.amazon.awssdk.services.securityir.model.ImpactedAwsRegion;
import software.amazon.awssdk.services.securityir.model.ImpactedAwsRegionListCopier;
import software.amazon.awssdk.services.securityir.model.ImpactedServicesListCopier;
import software.amazon.awssdk.services.securityir.model.SecurityIrRequest;
import software.amazon.awssdk.services.securityir.model.ThreatActorIp;
import software.amazon.awssdk.services.securityir.model.ThreatActorIpListCopier;
import software.amazon.awssdk.services.securityir.model.Watcher;
import software.amazon.awssdk.services.securityir.model.WatchersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateCaseRequest
extends SecurityIrRequest
implements ToCopyableBuilder<Builder, UpdateCaseRequest> {
    private static final SdkField<String> CASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("caseId").getter(UpdateCaseRequest.getter(UpdateCaseRequest::caseId)).setter(UpdateCaseRequest.setter(Builder::caseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("caseId").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("title").getter(UpdateCaseRequest.getter(UpdateCaseRequest::title)).setter(UpdateCaseRequest.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateCaseRequest.getter(UpdateCaseRequest::description)).setter(UpdateCaseRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Instant> REPORTED_INCIDENT_START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("reportedIncidentStartDate").getter(UpdateCaseRequest.getter(UpdateCaseRequest::reportedIncidentStartDate)).setter(UpdateCaseRequest.setter(Builder::reportedIncidentStartDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportedIncidentStartDate").build()}).build();
    private static final SdkField<Instant> ACTUAL_INCIDENT_START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("actualIncidentStartDate").getter(UpdateCaseRequest.getter(UpdateCaseRequest::actualIncidentStartDate)).setter(UpdateCaseRequest.setter(Builder::actualIncidentStartDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actualIncidentStartDate").build()}).build();
    private static final SdkField<String> ENGAGEMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("engagementType").getter(UpdateCaseRequest.getter(UpdateCaseRequest::engagementTypeAsString)).setter(UpdateCaseRequest.setter(Builder::engagementType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engagementType").build()}).build();
    private static final SdkField<List<Watcher>> WATCHERS_TO_ADD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("watchersToAdd").getter(UpdateCaseRequest.getter(UpdateCaseRequest::watchersToAdd)).setter(UpdateCaseRequest.setter(Builder::watchersToAdd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("watchersToAdd").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Watcher::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Watcher>> WATCHERS_TO_DELETE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("watchersToDelete").getter(UpdateCaseRequest.getter(UpdateCaseRequest::watchersToDelete)).setter(UpdateCaseRequest.setter(Builder::watchersToDelete)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("watchersToDelete").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Watcher::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ThreatActorIp>> THREAT_ACTOR_IP_ADDRESSES_TO_ADD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("threatActorIpAddressesToAdd").getter(UpdateCaseRequest.getter(UpdateCaseRequest::threatActorIpAddressesToAdd)).setter(UpdateCaseRequest.setter(Builder::threatActorIpAddressesToAdd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("threatActorIpAddressesToAdd").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ThreatActorIp::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ThreatActorIp>> THREAT_ACTOR_IP_ADDRESSES_TO_DELETE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("threatActorIpAddressesToDelete").getter(UpdateCaseRequest.getter(UpdateCaseRequest::threatActorIpAddressesToDelete)).setter(UpdateCaseRequest.setter(Builder::threatActorIpAddressesToDelete)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("threatActorIpAddressesToDelete").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ThreatActorIp::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> IMPACTED_SERVICES_TO_ADD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("impactedServicesToAdd").getter(UpdateCaseRequest.getter(UpdateCaseRequest::impactedServicesToAdd)).setter(UpdateCaseRequest.setter(Builder::impactedServicesToAdd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("impactedServicesToAdd").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> IMPACTED_SERVICES_TO_DELETE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("impactedServicesToDelete").getter(UpdateCaseRequest.getter(UpdateCaseRequest::impactedServicesToDelete)).setter(UpdateCaseRequest.setter(Builder::impactedServicesToDelete)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("impactedServicesToDelete").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ImpactedAwsRegion>> IMPACTED_AWS_REGIONS_TO_ADD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("impactedAwsRegionsToAdd").getter(UpdateCaseRequest.getter(UpdateCaseRequest::impactedAwsRegionsToAdd)).setter(UpdateCaseRequest.setter(Builder::impactedAwsRegionsToAdd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("impactedAwsRegionsToAdd").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ImpactedAwsRegion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ImpactedAwsRegion>> IMPACTED_AWS_REGIONS_TO_DELETE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("impactedAwsRegionsToDelete").getter(UpdateCaseRequest.getter(UpdateCaseRequest::impactedAwsRegionsToDelete)).setter(UpdateCaseRequest.setter(Builder::impactedAwsRegionsToDelete)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("impactedAwsRegionsToDelete").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ImpactedAwsRegion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> IMPACTED_ACCOUNTS_TO_ADD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("impactedAccountsToAdd").getter(UpdateCaseRequest.getter(UpdateCaseRequest::impactedAccountsToAdd)).setter(UpdateCaseRequest.setter(Builder::impactedAccountsToAdd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("impactedAccountsToAdd").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> IMPACTED_ACCOUNTS_TO_DELETE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("impactedAccountsToDelete").getter(UpdateCaseRequest.getter(UpdateCaseRequest::impactedAccountsToDelete)).setter(UpdateCaseRequest.setter(Builder::impactedAccountsToDelete)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("impactedAccountsToDelete").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CASE_ID_FIELD, TITLE_FIELD, DESCRIPTION_FIELD, REPORTED_INCIDENT_START_DATE_FIELD, ACTUAL_INCIDENT_START_DATE_FIELD, ENGAGEMENT_TYPE_FIELD, WATCHERS_TO_ADD_FIELD, WATCHERS_TO_DELETE_FIELD, THREAT_ACTOR_IP_ADDRESSES_TO_ADD_FIELD, THREAT_ACTOR_IP_ADDRESSES_TO_DELETE_FIELD, IMPACTED_SERVICES_TO_ADD_FIELD, IMPACTED_SERVICES_TO_DELETE_FIELD, IMPACTED_AWS_REGIONS_TO_ADD_FIELD, IMPACTED_AWS_REGIONS_TO_DELETE_FIELD, IMPACTED_ACCOUNTS_TO_ADD_FIELD, IMPACTED_ACCOUNTS_TO_DELETE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateCaseRequest.memberNameToFieldInitializer();
    private final String caseId;
    private final String title;
    private final String description;
    private final Instant reportedIncidentStartDate;
    private final Instant actualIncidentStartDate;
    private final String engagementType;
    private final List<Watcher> watchersToAdd;
    private final List<Watcher> watchersToDelete;
    private final List<ThreatActorIp> threatActorIpAddressesToAdd;
    private final List<ThreatActorIp> threatActorIpAddressesToDelete;
    private final List<String> impactedServicesToAdd;
    private final List<String> impactedServicesToDelete;
    private final List<ImpactedAwsRegion> impactedAwsRegionsToAdd;
    private final List<ImpactedAwsRegion> impactedAwsRegionsToDelete;
    private final List<String> impactedAccountsToAdd;
    private final List<String> impactedAccountsToDelete;

    private UpdateCaseRequest(BuilderImpl builder) {
        super(builder);
        this.caseId = builder.caseId;
        this.title = builder.title;
        this.description = builder.description;
        this.reportedIncidentStartDate = builder.reportedIncidentStartDate;
        this.actualIncidentStartDate = builder.actualIncidentStartDate;
        this.engagementType = builder.engagementType;
        this.watchersToAdd = builder.watchersToAdd;
        this.watchersToDelete = builder.watchersToDelete;
        this.threatActorIpAddressesToAdd = builder.threatActorIpAddressesToAdd;
        this.threatActorIpAddressesToDelete = builder.threatActorIpAddressesToDelete;
        this.impactedServicesToAdd = builder.impactedServicesToAdd;
        this.impactedServicesToDelete = builder.impactedServicesToDelete;
        this.impactedAwsRegionsToAdd = builder.impactedAwsRegionsToAdd;
        this.impactedAwsRegionsToDelete = builder.impactedAwsRegionsToDelete;
        this.impactedAccountsToAdd = builder.impactedAccountsToAdd;
        this.impactedAccountsToDelete = builder.impactedAccountsToDelete;
    }

    public final String caseId() {
        return this.caseId;
    }

    public final String title() {
        return this.title;
    }

    public final String description() {
        return this.description;
    }

    public final Instant reportedIncidentStartDate() {
        return this.reportedIncidentStartDate;
    }

    public final Instant actualIncidentStartDate() {
        return this.actualIncidentStartDate;
    }

    public final EngagementType engagementType() {
        return EngagementType.fromValue(this.engagementType);
    }

    public final String engagementTypeAsString() {
        return this.engagementType;
    }

    public final boolean hasWatchersToAdd() {
        return this.watchersToAdd != null && !(this.watchersToAdd instanceof SdkAutoConstructList);
    }

    public final List<Watcher> watchersToAdd() {
        return this.watchersToAdd;
    }

    public final boolean hasWatchersToDelete() {
        return this.watchersToDelete != null && !(this.watchersToDelete instanceof SdkAutoConstructList);
    }

    public final List<Watcher> watchersToDelete() {
        return this.watchersToDelete;
    }

    public final boolean hasThreatActorIpAddressesToAdd() {
        return this.threatActorIpAddressesToAdd != null && !(this.threatActorIpAddressesToAdd instanceof SdkAutoConstructList);
    }

    public final List<ThreatActorIp> threatActorIpAddressesToAdd() {
        return this.threatActorIpAddressesToAdd;
    }

    public final boolean hasThreatActorIpAddressesToDelete() {
        return this.threatActorIpAddressesToDelete != null && !(this.threatActorIpAddressesToDelete instanceof SdkAutoConstructList);
    }

    public final List<ThreatActorIp> threatActorIpAddressesToDelete() {
        return this.threatActorIpAddressesToDelete;
    }

    public final boolean hasImpactedServicesToAdd() {
        return this.impactedServicesToAdd != null && !(this.impactedServicesToAdd instanceof SdkAutoConstructList);
    }

    public final List<String> impactedServicesToAdd() {
        return this.impactedServicesToAdd;
    }

    public final boolean hasImpactedServicesToDelete() {
        return this.impactedServicesToDelete != null && !(this.impactedServicesToDelete instanceof SdkAutoConstructList);
    }

    public final List<String> impactedServicesToDelete() {
        return this.impactedServicesToDelete;
    }

    public final boolean hasImpactedAwsRegionsToAdd() {
        return this.impactedAwsRegionsToAdd != null && !(this.impactedAwsRegionsToAdd instanceof SdkAutoConstructList);
    }

    public final List<ImpactedAwsRegion> impactedAwsRegionsToAdd() {
        return this.impactedAwsRegionsToAdd;
    }

    public final boolean hasImpactedAwsRegionsToDelete() {
        return this.impactedAwsRegionsToDelete != null && !(this.impactedAwsRegionsToDelete instanceof SdkAutoConstructList);
    }

    public final List<ImpactedAwsRegion> impactedAwsRegionsToDelete() {
        return this.impactedAwsRegionsToDelete;
    }

    public final boolean hasImpactedAccountsToAdd() {
        return this.impactedAccountsToAdd != null && !(this.impactedAccountsToAdd instanceof SdkAutoConstructList);
    }

    public final List<String> impactedAccountsToAdd() {
        return this.impactedAccountsToAdd;
    }

    public final boolean hasImpactedAccountsToDelete() {
        return this.impactedAccountsToDelete != null && !(this.impactedAccountsToDelete instanceof SdkAutoConstructList);
    }

    public final List<String> impactedAccountsToDelete() {
        return this.impactedAccountsToDelete;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.caseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.reportedIncidentStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.actualIncidentStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.engagementTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWatchersToAdd() ? this.watchersToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWatchersToDelete() ? this.watchersToDelete() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasThreatActorIpAddressesToAdd() ? this.threatActorIpAddressesToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasThreatActorIpAddressesToDelete() ? this.threatActorIpAddressesToDelete() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImpactedServicesToAdd() ? this.impactedServicesToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImpactedServicesToDelete() ? this.impactedServicesToDelete() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImpactedAwsRegionsToAdd() ? this.impactedAwsRegionsToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImpactedAwsRegionsToDelete() ? this.impactedAwsRegionsToDelete() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImpactedAccountsToAdd() ? this.impactedAccountsToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImpactedAccountsToDelete() ? this.impactedAccountsToDelete() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCaseRequest)) {
            return false;
        }
        UpdateCaseRequest other = (UpdateCaseRequest)((Object)obj);
        return Objects.equals(this.caseId(), other.caseId()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.reportedIncidentStartDate(), other.reportedIncidentStartDate()) && Objects.equals(this.actualIncidentStartDate(), other.actualIncidentStartDate()) && Objects.equals(this.engagementTypeAsString(), other.engagementTypeAsString()) && this.hasWatchersToAdd() == other.hasWatchersToAdd() && Objects.equals(this.watchersToAdd(), other.watchersToAdd()) && this.hasWatchersToDelete() == other.hasWatchersToDelete() && Objects.equals(this.watchersToDelete(), other.watchersToDelete()) && this.hasThreatActorIpAddressesToAdd() == other.hasThreatActorIpAddressesToAdd() && Objects.equals(this.threatActorIpAddressesToAdd(), other.threatActorIpAddressesToAdd()) && this.hasThreatActorIpAddressesToDelete() == other.hasThreatActorIpAddressesToDelete() && Objects.equals(this.threatActorIpAddressesToDelete(), other.threatActorIpAddressesToDelete()) && this.hasImpactedServicesToAdd() == other.hasImpactedServicesToAdd() && Objects.equals(this.impactedServicesToAdd(), other.impactedServicesToAdd()) && this.hasImpactedServicesToDelete() == other.hasImpactedServicesToDelete() && Objects.equals(this.impactedServicesToDelete(), other.impactedServicesToDelete()) && this.hasImpactedAwsRegionsToAdd() == other.hasImpactedAwsRegionsToAdd() && Objects.equals(this.impactedAwsRegionsToAdd(), other.impactedAwsRegionsToAdd()) && this.hasImpactedAwsRegionsToDelete() == other.hasImpactedAwsRegionsToDelete() && Objects.equals(this.impactedAwsRegionsToDelete(), other.impactedAwsRegionsToDelete()) && this.hasImpactedAccountsToAdd() == other.hasImpactedAccountsToAdd() && Objects.equals(this.impactedAccountsToAdd(), other.impactedAccountsToAdd()) && this.hasImpactedAccountsToDelete() == other.hasImpactedAccountsToDelete() && Objects.equals(this.impactedAccountsToDelete(), other.impactedAccountsToDelete());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateCaseRequest").add("CaseId", (Object)this.caseId()).add("Title", (Object)(this.title() == null ? null : "*** Sensitive Data Redacted ***")).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("ReportedIncidentStartDate", (Object)this.reportedIncidentStartDate()).add("ActualIncidentStartDate", (Object)this.actualIncidentStartDate()).add("EngagementType", (Object)this.engagementTypeAsString()).add("WatchersToAdd", this.hasWatchersToAdd() ? this.watchersToAdd() : null).add("WatchersToDelete", this.hasWatchersToDelete() ? this.watchersToDelete() : null).add("ThreatActorIpAddressesToAdd", this.hasThreatActorIpAddressesToAdd() ? this.threatActorIpAddressesToAdd() : null).add("ThreatActorIpAddressesToDelete", this.hasThreatActorIpAddressesToDelete() ? this.threatActorIpAddressesToDelete() : null).add("ImpactedServicesToAdd", this.hasImpactedServicesToAdd() ? this.impactedServicesToAdd() : null).add("ImpactedServicesToDelete", this.hasImpactedServicesToDelete() ? this.impactedServicesToDelete() : null).add("ImpactedAwsRegionsToAdd", this.hasImpactedAwsRegionsToAdd() ? this.impactedAwsRegionsToAdd() : null).add("ImpactedAwsRegionsToDelete", this.hasImpactedAwsRegionsToDelete() ? this.impactedAwsRegionsToDelete() : null).add("ImpactedAccountsToAdd", this.hasImpactedAccountsToAdd() ? this.impactedAccountsToAdd() : null).add("ImpactedAccountsToDelete", this.hasImpactedAccountsToDelete() ? this.impactedAccountsToDelete() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "caseId": {
                return Optional.ofNullable(clazz.cast(this.caseId()));
            }
            case "title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "reportedIncidentStartDate": {
                return Optional.ofNullable(clazz.cast(this.reportedIncidentStartDate()));
            }
            case "actualIncidentStartDate": {
                return Optional.ofNullable(clazz.cast(this.actualIncidentStartDate()));
            }
            case "engagementType": {
                return Optional.ofNullable(clazz.cast(this.engagementTypeAsString()));
            }
            case "watchersToAdd": {
                return Optional.ofNullable(clazz.cast(this.watchersToAdd()));
            }
            case "watchersToDelete": {
                return Optional.ofNullable(clazz.cast(this.watchersToDelete()));
            }
            case "threatActorIpAddressesToAdd": {
                return Optional.ofNullable(clazz.cast(this.threatActorIpAddressesToAdd()));
            }
            case "threatActorIpAddressesToDelete": {
                return Optional.ofNullable(clazz.cast(this.threatActorIpAddressesToDelete()));
            }
            case "impactedServicesToAdd": {
                return Optional.ofNullable(clazz.cast(this.impactedServicesToAdd()));
            }
            case "impactedServicesToDelete": {
                return Optional.ofNullable(clazz.cast(this.impactedServicesToDelete()));
            }
            case "impactedAwsRegionsToAdd": {
                return Optional.ofNullable(clazz.cast(this.impactedAwsRegionsToAdd()));
            }
            case "impactedAwsRegionsToDelete": {
                return Optional.ofNullable(clazz.cast(this.impactedAwsRegionsToDelete()));
            }
            case "impactedAccountsToAdd": {
                return Optional.ofNullable(clazz.cast(this.impactedAccountsToAdd()));
            }
            case "impactedAccountsToDelete": {
                return Optional.ofNullable(clazz.cast(this.impactedAccountsToDelete()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("caseId", CASE_ID_FIELD);
        map.put("title", TITLE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("reportedIncidentStartDate", REPORTED_INCIDENT_START_DATE_FIELD);
        map.put("actualIncidentStartDate", ACTUAL_INCIDENT_START_DATE_FIELD);
        map.put("engagementType", ENGAGEMENT_TYPE_FIELD);
        map.put("watchersToAdd", WATCHERS_TO_ADD_FIELD);
        map.put("watchersToDelete", WATCHERS_TO_DELETE_FIELD);
        map.put("threatActorIpAddressesToAdd", THREAT_ACTOR_IP_ADDRESSES_TO_ADD_FIELD);
        map.put("threatActorIpAddressesToDelete", THREAT_ACTOR_IP_ADDRESSES_TO_DELETE_FIELD);
        map.put("impactedServicesToAdd", IMPACTED_SERVICES_TO_ADD_FIELD);
        map.put("impactedServicesToDelete", IMPACTED_SERVICES_TO_DELETE_FIELD);
        map.put("impactedAwsRegionsToAdd", IMPACTED_AWS_REGIONS_TO_ADD_FIELD);
        map.put("impactedAwsRegionsToDelete", IMPACTED_AWS_REGIONS_TO_DELETE_FIELD);
        map.put("impactedAccountsToAdd", IMPACTED_ACCOUNTS_TO_ADD_FIELD);
        map.put("impactedAccountsToDelete", IMPACTED_ACCOUNTS_TO_DELETE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateCaseRequest, T> g) {
        return obj -> g.apply((UpdateCaseRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityIrRequest.BuilderImpl
    implements Builder {
        private String caseId;
        private String title;
        private String description;
        private Instant reportedIncidentStartDate;
        private Instant actualIncidentStartDate;
        private String engagementType;
        private List<Watcher> watchersToAdd = DefaultSdkAutoConstructList.getInstance();
        private List<Watcher> watchersToDelete = DefaultSdkAutoConstructList.getInstance();
        private List<ThreatActorIp> threatActorIpAddressesToAdd = DefaultSdkAutoConstructList.getInstance();
        private List<ThreatActorIp> threatActorIpAddressesToDelete = DefaultSdkAutoConstructList.getInstance();
        private List<String> impactedServicesToAdd = DefaultSdkAutoConstructList.getInstance();
        private List<String> impactedServicesToDelete = DefaultSdkAutoConstructList.getInstance();
        private List<ImpactedAwsRegion> impactedAwsRegionsToAdd = DefaultSdkAutoConstructList.getInstance();
        private List<ImpactedAwsRegion> impactedAwsRegionsToDelete = DefaultSdkAutoConstructList.getInstance();
        private List<String> impactedAccountsToAdd = DefaultSdkAutoConstructList.getInstance();
        private List<String> impactedAccountsToDelete = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCaseRequest model) {
            super(model);
            this.caseId(model.caseId);
            this.title(model.title);
            this.description(model.description);
            this.reportedIncidentStartDate(model.reportedIncidentStartDate);
            this.actualIncidentStartDate(model.actualIncidentStartDate);
            this.engagementType(model.engagementType);
            this.watchersToAdd(model.watchersToAdd);
            this.watchersToDelete(model.watchersToDelete);
            this.threatActorIpAddressesToAdd(model.threatActorIpAddressesToAdd);
            this.threatActorIpAddressesToDelete(model.threatActorIpAddressesToDelete);
            this.impactedServicesToAdd(model.impactedServicesToAdd);
            this.impactedServicesToDelete(model.impactedServicesToDelete);
            this.impactedAwsRegionsToAdd(model.impactedAwsRegionsToAdd);
            this.impactedAwsRegionsToDelete(model.impactedAwsRegionsToDelete);
            this.impactedAccountsToAdd(model.impactedAccountsToAdd);
            this.impactedAccountsToDelete(model.impactedAccountsToDelete);
        }

        public final String getCaseId() {
            return this.caseId;
        }

        public final void setCaseId(String caseId) {
            this.caseId = caseId;
        }

        @Override
        public final Builder caseId(String caseId) {
            this.caseId = caseId;
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getReportedIncidentStartDate() {
            return this.reportedIncidentStartDate;
        }

        public final void setReportedIncidentStartDate(Instant reportedIncidentStartDate) {
            this.reportedIncidentStartDate = reportedIncidentStartDate;
        }

        @Override
        public final Builder reportedIncidentStartDate(Instant reportedIncidentStartDate) {
            this.reportedIncidentStartDate = reportedIncidentStartDate;
            return this;
        }

        public final Instant getActualIncidentStartDate() {
            return this.actualIncidentStartDate;
        }

        public final void setActualIncidentStartDate(Instant actualIncidentStartDate) {
            this.actualIncidentStartDate = actualIncidentStartDate;
        }

        @Override
        public final Builder actualIncidentStartDate(Instant actualIncidentStartDate) {
            this.actualIncidentStartDate = actualIncidentStartDate;
            return this;
        }

        public final String getEngagementType() {
            return this.engagementType;
        }

        public final void setEngagementType(String engagementType) {
            this.engagementType = engagementType;
        }

        @Override
        public final Builder engagementType(String engagementType) {
            this.engagementType = engagementType;
            return this;
        }

        @Override
        public final Builder engagementType(EngagementType engagementType) {
            this.engagementType(engagementType == null ? null : engagementType.toString());
            return this;
        }

        public final List<Watcher.Builder> getWatchersToAdd() {
            List<Watcher.Builder> result = WatchersCopier.copyToBuilder(this.watchersToAdd);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWatchersToAdd(Collection<Watcher.BuilderImpl> watchersToAdd) {
            this.watchersToAdd = WatchersCopier.copyFromBuilder(watchersToAdd);
        }

        @Override
        public final Builder watchersToAdd(Collection<Watcher> watchersToAdd) {
            this.watchersToAdd = WatchersCopier.copy(watchersToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder watchersToAdd(Watcher ... watchersToAdd) {
            this.watchersToAdd(Arrays.asList(watchersToAdd));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder watchersToAdd(Consumer<Watcher.Builder> ... watchersToAdd) {
            this.watchersToAdd(Stream.of(watchersToAdd).map(c -> (Watcher)((Watcher.Builder)Watcher.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Watcher.Builder> getWatchersToDelete() {
            List<Watcher.Builder> result = WatchersCopier.copyToBuilder(this.watchersToDelete);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWatchersToDelete(Collection<Watcher.BuilderImpl> watchersToDelete) {
            this.watchersToDelete = WatchersCopier.copyFromBuilder(watchersToDelete);
        }

        @Override
        public final Builder watchersToDelete(Collection<Watcher> watchersToDelete) {
            this.watchersToDelete = WatchersCopier.copy(watchersToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder watchersToDelete(Watcher ... watchersToDelete) {
            this.watchersToDelete(Arrays.asList(watchersToDelete));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder watchersToDelete(Consumer<Watcher.Builder> ... watchersToDelete) {
            this.watchersToDelete(Stream.of(watchersToDelete).map(c -> (Watcher)((Watcher.Builder)Watcher.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ThreatActorIp.Builder> getThreatActorIpAddressesToAdd() {
            List<ThreatActorIp.Builder> result = ThreatActorIpListCopier.copyToBuilder(this.threatActorIpAddressesToAdd);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setThreatActorIpAddressesToAdd(Collection<ThreatActorIp.BuilderImpl> threatActorIpAddressesToAdd) {
            this.threatActorIpAddressesToAdd = ThreatActorIpListCopier.copyFromBuilder(threatActorIpAddressesToAdd);
        }

        @Override
        public final Builder threatActorIpAddressesToAdd(Collection<ThreatActorIp> threatActorIpAddressesToAdd) {
            this.threatActorIpAddressesToAdd = ThreatActorIpListCopier.copy(threatActorIpAddressesToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threatActorIpAddressesToAdd(ThreatActorIp ... threatActorIpAddressesToAdd) {
            this.threatActorIpAddressesToAdd(Arrays.asList(threatActorIpAddressesToAdd));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threatActorIpAddressesToAdd(Consumer<ThreatActorIp.Builder> ... threatActorIpAddressesToAdd) {
            this.threatActorIpAddressesToAdd(Stream.of(threatActorIpAddressesToAdd).map(c -> (ThreatActorIp)((ThreatActorIp.Builder)ThreatActorIp.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ThreatActorIp.Builder> getThreatActorIpAddressesToDelete() {
            List<ThreatActorIp.Builder> result = ThreatActorIpListCopier.copyToBuilder(this.threatActorIpAddressesToDelete);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setThreatActorIpAddressesToDelete(Collection<ThreatActorIp.BuilderImpl> threatActorIpAddressesToDelete) {
            this.threatActorIpAddressesToDelete = ThreatActorIpListCopier.copyFromBuilder(threatActorIpAddressesToDelete);
        }

        @Override
        public final Builder threatActorIpAddressesToDelete(Collection<ThreatActorIp> threatActorIpAddressesToDelete) {
            this.threatActorIpAddressesToDelete = ThreatActorIpListCopier.copy(threatActorIpAddressesToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threatActorIpAddressesToDelete(ThreatActorIp ... threatActorIpAddressesToDelete) {
            this.threatActorIpAddressesToDelete(Arrays.asList(threatActorIpAddressesToDelete));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threatActorIpAddressesToDelete(Consumer<ThreatActorIp.Builder> ... threatActorIpAddressesToDelete) {
            this.threatActorIpAddressesToDelete(Stream.of(threatActorIpAddressesToDelete).map(c -> (ThreatActorIp)((ThreatActorIp.Builder)ThreatActorIp.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getImpactedServicesToAdd() {
            if (this.impactedServicesToAdd instanceof SdkAutoConstructList) {
                return null;
            }
            return this.impactedServicesToAdd;
        }

        public final void setImpactedServicesToAdd(Collection<String> impactedServicesToAdd) {
            this.impactedServicesToAdd = ImpactedServicesListCopier.copy(impactedServicesToAdd);
        }

        @Override
        public final Builder impactedServicesToAdd(Collection<String> impactedServicesToAdd) {
            this.impactedServicesToAdd = ImpactedServicesListCopier.copy(impactedServicesToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder impactedServicesToAdd(String ... impactedServicesToAdd) {
            this.impactedServicesToAdd(Arrays.asList(impactedServicesToAdd));
            return this;
        }

        public final Collection<String> getImpactedServicesToDelete() {
            if (this.impactedServicesToDelete instanceof SdkAutoConstructList) {
                return null;
            }
            return this.impactedServicesToDelete;
        }

        public final void setImpactedServicesToDelete(Collection<String> impactedServicesToDelete) {
            this.impactedServicesToDelete = ImpactedServicesListCopier.copy(impactedServicesToDelete);
        }

        @Override
        public final Builder impactedServicesToDelete(Collection<String> impactedServicesToDelete) {
            this.impactedServicesToDelete = ImpactedServicesListCopier.copy(impactedServicesToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder impactedServicesToDelete(String ... impactedServicesToDelete) {
            this.impactedServicesToDelete(Arrays.asList(impactedServicesToDelete));
            return this;
        }

        public final List<ImpactedAwsRegion.Builder> getImpactedAwsRegionsToAdd() {
            List<ImpactedAwsRegion.Builder> result = ImpactedAwsRegionListCopier.copyToBuilder(this.impactedAwsRegionsToAdd);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImpactedAwsRegionsToAdd(Collection<ImpactedAwsRegion.BuilderImpl> impactedAwsRegionsToAdd) {
            this.impactedAwsRegionsToAdd = ImpactedAwsRegionListCopier.copyFromBuilder(impactedAwsRegionsToAdd);
        }

        @Override
        public final Builder impactedAwsRegionsToAdd(Collection<ImpactedAwsRegion> impactedAwsRegionsToAdd) {
            this.impactedAwsRegionsToAdd = ImpactedAwsRegionListCopier.copy(impactedAwsRegionsToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder impactedAwsRegionsToAdd(ImpactedAwsRegion ... impactedAwsRegionsToAdd) {
            this.impactedAwsRegionsToAdd(Arrays.asList(impactedAwsRegionsToAdd));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder impactedAwsRegionsToAdd(Consumer<ImpactedAwsRegion.Builder> ... impactedAwsRegionsToAdd) {
            this.impactedAwsRegionsToAdd(Stream.of(impactedAwsRegionsToAdd).map(c -> (ImpactedAwsRegion)((ImpactedAwsRegion.Builder)ImpactedAwsRegion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ImpactedAwsRegion.Builder> getImpactedAwsRegionsToDelete() {
            List<ImpactedAwsRegion.Builder> result = ImpactedAwsRegionListCopier.copyToBuilder(this.impactedAwsRegionsToDelete);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImpactedAwsRegionsToDelete(Collection<ImpactedAwsRegion.BuilderImpl> impactedAwsRegionsToDelete) {
            this.impactedAwsRegionsToDelete = ImpactedAwsRegionListCopier.copyFromBuilder(impactedAwsRegionsToDelete);
        }

        @Override
        public final Builder impactedAwsRegionsToDelete(Collection<ImpactedAwsRegion> impactedAwsRegionsToDelete) {
            this.impactedAwsRegionsToDelete = ImpactedAwsRegionListCopier.copy(impactedAwsRegionsToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder impactedAwsRegionsToDelete(ImpactedAwsRegion ... impactedAwsRegionsToDelete) {
            this.impactedAwsRegionsToDelete(Arrays.asList(impactedAwsRegionsToDelete));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder impactedAwsRegionsToDelete(Consumer<ImpactedAwsRegion.Builder> ... impactedAwsRegionsToDelete) {
            this.impactedAwsRegionsToDelete(Stream.of(impactedAwsRegionsToDelete).map(c -> (ImpactedAwsRegion)((ImpactedAwsRegion.Builder)ImpactedAwsRegion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getImpactedAccountsToAdd() {
            if (this.impactedAccountsToAdd instanceof SdkAutoConstructList) {
                return null;
            }
            return this.impactedAccountsToAdd;
        }

        public final void setImpactedAccountsToAdd(Collection<String> impactedAccountsToAdd) {
            this.impactedAccountsToAdd = ImpactedAccountsCopier.copy(impactedAccountsToAdd);
        }

        @Override
        public final Builder impactedAccountsToAdd(Collection<String> impactedAccountsToAdd) {
            this.impactedAccountsToAdd = ImpactedAccountsCopier.copy(impactedAccountsToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder impactedAccountsToAdd(String ... impactedAccountsToAdd) {
            this.impactedAccountsToAdd(Arrays.asList(impactedAccountsToAdd));
            return this;
        }

        public final Collection<String> getImpactedAccountsToDelete() {
            if (this.impactedAccountsToDelete instanceof SdkAutoConstructList) {
                return null;
            }
            return this.impactedAccountsToDelete;
        }

        public final void setImpactedAccountsToDelete(Collection<String> impactedAccountsToDelete) {
            this.impactedAccountsToDelete = ImpactedAccountsCopier.copy(impactedAccountsToDelete);
        }

        @Override
        public final Builder impactedAccountsToDelete(Collection<String> impactedAccountsToDelete) {
            this.impactedAccountsToDelete = ImpactedAccountsCopier.copy(impactedAccountsToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder impactedAccountsToDelete(String ... impactedAccountsToDelete) {
            this.impactedAccountsToDelete(Arrays.asList(impactedAccountsToDelete));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCaseRequest build() {
            return new UpdateCaseRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SecurityIrRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateCaseRequest> {
        public Builder caseId(String var1);

        public Builder title(String var1);

        public Builder description(String var1);

        public Builder reportedIncidentStartDate(Instant var1);

        public Builder actualIncidentStartDate(Instant var1);

        public Builder engagementType(String var1);

        public Builder engagementType(EngagementType var1);

        public Builder watchersToAdd(Collection<Watcher> var1);

        public Builder watchersToAdd(Watcher ... var1);

        public Builder watchersToAdd(Consumer<Watcher.Builder> ... var1);

        public Builder watchersToDelete(Collection<Watcher> var1);

        public Builder watchersToDelete(Watcher ... var1);

        public Builder watchersToDelete(Consumer<Watcher.Builder> ... var1);

        public Builder threatActorIpAddressesToAdd(Collection<ThreatActorIp> var1);

        public Builder threatActorIpAddressesToAdd(ThreatActorIp ... var1);

        public Builder threatActorIpAddressesToAdd(Consumer<ThreatActorIp.Builder> ... var1);

        public Builder threatActorIpAddressesToDelete(Collection<ThreatActorIp> var1);

        public Builder threatActorIpAddressesToDelete(ThreatActorIp ... var1);

        public Builder threatActorIpAddressesToDelete(Consumer<ThreatActorIp.Builder> ... var1);

        public Builder impactedServicesToAdd(Collection<String> var1);

        public Builder impactedServicesToAdd(String ... var1);

        public Builder impactedServicesToDelete(Collection<String> var1);

        public Builder impactedServicesToDelete(String ... var1);

        public Builder impactedAwsRegionsToAdd(Collection<ImpactedAwsRegion> var1);

        public Builder impactedAwsRegionsToAdd(ImpactedAwsRegion ... var1);

        public Builder impactedAwsRegionsToAdd(Consumer<ImpactedAwsRegion.Builder> ... var1);

        public Builder impactedAwsRegionsToDelete(Collection<ImpactedAwsRegion> var1);

        public Builder impactedAwsRegionsToDelete(ImpactedAwsRegion ... var1);

        public Builder impactedAwsRegionsToDelete(Consumer<ImpactedAwsRegion.Builder> ... var1);

        public Builder impactedAccountsToAdd(Collection<String> var1);

        public Builder impactedAccountsToAdd(String ... var1);

        public Builder impactedAccountsToDelete(Collection<String> var1);

        public Builder impactedAccountsToDelete(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

