/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityir.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securityir.SecurityIrClient;
import software.amazon.awssdk.services.securityir.internal.UserAgentUtils;
import software.amazon.awssdk.services.securityir.model.CaseEditItem;
import software.amazon.awssdk.services.securityir.model.ListCaseEditsRequest;
import software.amazon.awssdk.services.securityir.model.ListCaseEditsResponse;

public class ListCaseEditsIterable
implements SdkIterable<ListCaseEditsResponse> {
    private final SecurityIrClient client;
    private final ListCaseEditsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCaseEditsIterable(SecurityIrClient client, ListCaseEditsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCaseEditsResponseFetcher();
    }

    public Iterator<ListCaseEditsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CaseEditItem> items() {
        Function<ListCaseEditsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCaseEditsResponseFetcher
    implements SyncPageFetcher<ListCaseEditsResponse> {
        private ListCaseEditsResponseFetcher() {
        }

        public boolean hasNextPage(ListCaseEditsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCaseEditsResponse nextPage(ListCaseEditsResponse previousPage) {
            if (previousPage == null) {
                return ListCaseEditsIterable.this.client.listCaseEdits(ListCaseEditsIterable.this.firstRequest);
            }
            return ListCaseEditsIterable.this.client.listCaseEdits((ListCaseEditsRequest)((Object)ListCaseEditsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

