/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityir.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EngagementType {
    SECURITY_INCIDENT("Security Incident"),
    INVESTIGATION("Investigation"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EngagementType> VALUE_MAP;
    private final String value;

    private EngagementType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EngagementType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EngagementType> knownValues() {
        EnumSet<EngagementType> knownValues = EnumSet.allOf(EngagementType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EngagementType.class, EngagementType::toString);
    }
}

