/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ThreatIntelIndicatorCategory {
    BACKDOOR("BACKDOOR"),
    CARD_STEALER("CARD_STEALER"),
    COMMAND_AND_CONTROL("COMMAND_AND_CONTROL"),
    DROP_SITE("DROP_SITE"),
    EXPLOIT_SITE("EXPLOIT_SITE"),
    KEYLOGGER("KEYLOGGER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ThreatIntelIndicatorCategory(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ThreatIntelIndicatorCategory fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ThreatIntelIndicatorCategory.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ThreatIntelIndicatorCategory> knownValues() {
        return Stream.of(ThreatIntelIndicatorCategory.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

