/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securityhub.SecurityHubClient;
import software.amazon.awssdk.services.securityhub.model.ListProductSubscribersRequest;
import software.amazon.awssdk.services.securityhub.model.ListProductSubscribersResponse;

public class ListProductSubscribersIterable
implements SdkIterable<ListProductSubscribersResponse> {
    private final SecurityHubClient client;
    private final ListProductSubscribersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListProductSubscribersIterable(SecurityHubClient client, ListProductSubscribersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListProductSubscribersResponseFetcher();
    }

    public Iterator<ListProductSubscribersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListProductSubscribersResponseFetcher
    implements SyncPageFetcher<ListProductSubscribersResponse> {
        private ListProductSubscribersResponseFetcher() {
        }

        public boolean hasNextPage(ListProductSubscribersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListProductSubscribersResponse nextPage(ListProductSubscribersResponse previousPage) {
            if (previousPage == null) {
                return ListProductSubscribersIterable.this.client.listProductSubscribers(ListProductSubscribersIterable.this.firstRequest);
            }
            return ListProductSubscribersIterable.this.client.listProductSubscribers((ListProductSubscribersRequest)((Object)ListProductSubscribersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

