/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.AwsSecurityFindingFilters;
import software.amazon.awssdk.services.securityhub.model.NoteUpdate;
import software.amazon.awssdk.services.securityhub.model.RecordState;
import software.amazon.awssdk.services.securityhub.model.SecurityHubRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateFindingsRequest
extends SecurityHubRequest
implements ToCopyableBuilder<Builder, UpdateFindingsRequest> {
    private static final SdkField<AwsSecurityFindingFilters> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateFindingsRequest.getter(UpdateFindingsRequest::filters)).setter(UpdateFindingsRequest.setter(Builder::filters)).constructor(AwsSecurityFindingFilters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()}).build();
    private static final SdkField<NoteUpdate> NOTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateFindingsRequest.getter(UpdateFindingsRequest::note)).setter(UpdateFindingsRequest.setter(Builder::note)).constructor(NoteUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Note").build()}).build();
    private static final SdkField<String> RECORD_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateFindingsRequest.getter(UpdateFindingsRequest::recordStateAsString)).setter(UpdateFindingsRequest.setter(Builder::recordState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD, NOTE_FIELD, RECORD_STATE_FIELD));
    private final AwsSecurityFindingFilters filters;
    private final NoteUpdate note;
    private final String recordState;

    private UpdateFindingsRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.note = builder.note;
        this.recordState = builder.recordState;
    }

    public AwsSecurityFindingFilters filters() {
        return this.filters;
    }

    public NoteUpdate note() {
        return this.note;
    }

    public RecordState recordState() {
        return RecordState.fromValue(this.recordState);
    }

    public String recordStateAsString() {
        return this.recordState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.note());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordStateAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFindingsRequest)) {
            return false;
        }
        UpdateFindingsRequest other = (UpdateFindingsRequest)((Object)obj);
        return Objects.equals(this.filters(), other.filters()) && Objects.equals(this.note(), other.note()) && Objects.equals(this.recordStateAsString(), other.recordStateAsString());
    }

    public String toString() {
        return ToString.builder((String)"UpdateFindingsRequest").add("Filters", (Object)this.filters()).add("Note", (Object)this.note()).add("RecordState", (Object)this.recordStateAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "Note": {
                return Optional.ofNullable(clazz.cast(this.note()));
            }
            case "RecordState": {
                return Optional.ofNullable(clazz.cast(this.recordStateAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFindingsRequest, T> g) {
        return obj -> g.apply((UpdateFindingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubRequest.BuilderImpl
    implements Builder {
        private AwsSecurityFindingFilters filters;
        private NoteUpdate note;
        private String recordState;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFindingsRequest model) {
            super(model);
            this.filters(model.filters);
            this.note(model.note);
            this.recordState(model.recordState);
        }

        public final AwsSecurityFindingFilters.Builder getFilters() {
            return this.filters != null ? this.filters.toBuilder() : null;
        }

        @Override
        public final Builder filters(AwsSecurityFindingFilters filters) {
            this.filters = filters;
            return this;
        }

        public final void setFilters(AwsSecurityFindingFilters.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        public final NoteUpdate.Builder getNote() {
            return this.note != null ? this.note.toBuilder() : null;
        }

        @Override
        public final Builder note(NoteUpdate note) {
            this.note = note;
            return this;
        }

        public final void setNote(NoteUpdate.BuilderImpl note) {
            this.note = note != null ? note.build() : null;
        }

        public final String getRecordStateAsString() {
            return this.recordState;
        }

        @Override
        public final Builder recordState(String recordState) {
            this.recordState = recordState;
            return this;
        }

        @Override
        public final Builder recordState(RecordState recordState) {
            this.recordState(recordState.toString());
            return this;
        }

        public final void setRecordState(String recordState) {
            this.recordState = recordState;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFindingsRequest build() {
            return new UpdateFindingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SecurityHubRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateFindingsRequest> {
        public Builder filters(AwsSecurityFindingFilters var1);

        default public Builder filters(Consumer<AwsSecurityFindingFilters.Builder> filters) {
            return this.filters((AwsSecurityFindingFilters)((AwsSecurityFindingFilters.Builder)AwsSecurityFindingFilters.builder().applyMutation(filters)).build());
        }

        public Builder note(NoteUpdate var1);

        default public Builder note(Consumer<NoteUpdate.Builder> note) {
            return this.note((NoteUpdate)((NoteUpdate.Builder)NoteUpdate.builder().applyMutation(note)).build());
        }

        public Builder recordState(String var1);

        public Builder recordState(RecordState var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

