/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.SecurityHubRequest;
import software.amazon.awssdk.services.securityhub.model.StandardsSubscriptionRequest;
import software.amazon.awssdk.services.securityhub.model.StandardsSubscriptionRequestsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchEnableStandardsRequest
extends SecurityHubRequest
implements ToCopyableBuilder<Builder, BatchEnableStandardsRequest> {
    private static final SdkField<List<StandardsSubscriptionRequest>> STANDARDS_SUBSCRIPTION_REQUESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(BatchEnableStandardsRequest.getter(BatchEnableStandardsRequest::standardsSubscriptionRequests)).setter(BatchEnableStandardsRequest.setter(Builder::standardsSubscriptionRequests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardsSubscriptionRequests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StandardsSubscriptionRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STANDARDS_SUBSCRIPTION_REQUESTS_FIELD));
    private final List<StandardsSubscriptionRequest> standardsSubscriptionRequests;

    private BatchEnableStandardsRequest(BuilderImpl builder) {
        super(builder);
        this.standardsSubscriptionRequests = builder.standardsSubscriptionRequests;
    }

    public List<StandardsSubscriptionRequest> standardsSubscriptionRequests() {
        return this.standardsSubscriptionRequests;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.standardsSubscriptionRequests());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchEnableStandardsRequest)) {
            return false;
        }
        BatchEnableStandardsRequest other = (BatchEnableStandardsRequest)((Object)obj);
        return Objects.equals(this.standardsSubscriptionRequests(), other.standardsSubscriptionRequests());
    }

    public String toString() {
        return ToString.builder((String)"BatchEnableStandardsRequest").add("StandardsSubscriptionRequests", this.standardsSubscriptionRequests()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StandardsSubscriptionRequests": {
                return Optional.ofNullable(clazz.cast(this.standardsSubscriptionRequests()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchEnableStandardsRequest, T> g) {
        return obj -> g.apply((BatchEnableStandardsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubRequest.BuilderImpl
    implements Builder {
        private List<StandardsSubscriptionRequest> standardsSubscriptionRequests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchEnableStandardsRequest model) {
            super(model);
            this.standardsSubscriptionRequests(model.standardsSubscriptionRequests);
        }

        public final Collection<StandardsSubscriptionRequest.Builder> getStandardsSubscriptionRequests() {
            return this.standardsSubscriptionRequests != null ? (Collection)this.standardsSubscriptionRequests.stream().map(StandardsSubscriptionRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder standardsSubscriptionRequests(Collection<StandardsSubscriptionRequest> standardsSubscriptionRequests) {
            this.standardsSubscriptionRequests = StandardsSubscriptionRequestsCopier.copy(standardsSubscriptionRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder standardsSubscriptionRequests(StandardsSubscriptionRequest ... standardsSubscriptionRequests) {
            this.standardsSubscriptionRequests(Arrays.asList(standardsSubscriptionRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder standardsSubscriptionRequests(Consumer<StandardsSubscriptionRequest.Builder> ... standardsSubscriptionRequests) {
            this.standardsSubscriptionRequests(Stream.of(standardsSubscriptionRequests).map(c -> (StandardsSubscriptionRequest)((StandardsSubscriptionRequest.Builder)StandardsSubscriptionRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStandardsSubscriptionRequests(Collection<StandardsSubscriptionRequest.BuilderImpl> standardsSubscriptionRequests) {
            this.standardsSubscriptionRequests = StandardsSubscriptionRequestsCopier.copyFromBuilder(standardsSubscriptionRequests);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchEnableStandardsRequest build() {
            return new BatchEnableStandardsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SecurityHubRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchEnableStandardsRequest> {
        public Builder standardsSubscriptionRequests(Collection<StandardsSubscriptionRequest> var1);

        public Builder standardsSubscriptionRequests(StandardsSubscriptionRequest ... var1);

        public Builder standardsSubscriptionRequests(Consumer<StandardsSubscriptionRequest.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

