/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details about the IPv6 CIDR blocks for the VPC.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VpcInfoIpv6CidrBlockSetDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<VpcInfoIpv6CidrBlockSetDetails.Builder, VpcInfoIpv6CidrBlockSetDetails> {
    private static final SdkField<String> IPV6_CIDR_BLOCK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Ipv6CidrBlock").getter(getter(VpcInfoIpv6CidrBlockSetDetails::ipv6CidrBlock))
            .setter(setter(Builder::ipv6CidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6CidrBlock").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPV6_CIDR_BLOCK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String ipv6CidrBlock;

    private VpcInfoIpv6CidrBlockSetDetails(BuilderImpl builder) {
        this.ipv6CidrBlock = builder.ipv6CidrBlock;
    }

    /**
     * <p>
     * The IPv6 CIDR block for the VPC.
     * </p>
     * 
     * @return The IPv6 CIDR block for the VPC.
     */
    public final String ipv6CidrBlock() {
        return ipv6CidrBlock;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ipv6CidrBlock());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcInfoIpv6CidrBlockSetDetails)) {
            return false;
        }
        VpcInfoIpv6CidrBlockSetDetails other = (VpcInfoIpv6CidrBlockSetDetails) obj;
        return Objects.equals(ipv6CidrBlock(), other.ipv6CidrBlock());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VpcInfoIpv6CidrBlockSetDetails").add("Ipv6CidrBlock", ipv6CidrBlock()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Ipv6CidrBlock":
            return Optional.ofNullable(clazz.cast(ipv6CidrBlock()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Ipv6CidrBlock", IPV6_CIDR_BLOCK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VpcInfoIpv6CidrBlockSetDetails, T> g) {
        return obj -> g.apply((VpcInfoIpv6CidrBlockSetDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VpcInfoIpv6CidrBlockSetDetails> {
        /**
         * <p>
         * The IPv6 CIDR block for the VPC.
         * </p>
         * 
         * @param ipv6CidrBlock
         *        The IPv6 CIDR block for the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6CidrBlock(String ipv6CidrBlock);
    }

    static final class BuilderImpl implements Builder {
        private String ipv6CidrBlock;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcInfoIpv6CidrBlockSetDetails model) {
            ipv6CidrBlock(model.ipv6CidrBlock);
        }

        public final String getIpv6CidrBlock() {
            return ipv6CidrBlock;
        }

        public final void setIpv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
        }

        @Override
        public final Builder ipv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
            return this;
        }

        @Override
        public VpcInfoIpv6CidrBlockSetDetails build() {
            return new VpcInfoIpv6CidrBlockSetDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
