/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSecurityHubConfigurationRequest extends SecurityHubRequest implements
        ToCopyableBuilder<UpdateSecurityHubConfigurationRequest.Builder, UpdateSecurityHubConfigurationRequest> {
    private static final SdkField<Boolean> AUTO_ENABLE_CONTROLS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoEnableControls").getter(getter(UpdateSecurityHubConfigurationRequest::autoEnableControls))
            .setter(setter(Builder::autoEnableControls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoEnableControls").build())
            .build();

    private static final SdkField<String> CONTROL_FINDING_GENERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ControlFindingGenerator")
            .getter(getter(UpdateSecurityHubConfigurationRequest::controlFindingGeneratorAsString))
            .setter(setter(Builder::controlFindingGenerator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ControlFindingGenerator").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_ENABLE_CONTROLS_FIELD,
            CONTROL_FINDING_GENERATOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Boolean autoEnableControls;

    private final String controlFindingGenerator;

    private UpdateSecurityHubConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.autoEnableControls = builder.autoEnableControls;
        this.controlFindingGenerator = builder.controlFindingGenerator;
    }

    /**
     * <p>
     * Whether to automatically enable new controls when they are added to standards that are enabled.
     * </p>
     * <p>
     * By default, this is set to <code>true</code>, and new controls are enabled automatically. To not automatically
     * enable new controls, set this to <code>false</code>.
     * </p>
     * <p>
     * When you automatically enable new controls, you can interact with the controls in the console and
     * programmatically immediately after release. However, automatically enabled controls have a temporary default
     * status of <code>DISABLED</code>. It can take up to several days for Security Hub to process the control release
     * and designate the control as <code>ENABLED</code> in your account. During the processing period, you can manually
     * enable or disable a control, and Security Hub will maintain that designation regardless of whether you have
     * <code>AutoEnableControls</code> set to <code>true</code>.
     * </p>
     * 
     * @return Whether to automatically enable new controls when they are added to standards that are enabled.</p>
     *         <p>
     *         By default, this is set to <code>true</code>, and new controls are enabled automatically. To not
     *         automatically enable new controls, set this to <code>false</code>.
     *         </p>
     *         <p>
     *         When you automatically enable new controls, you can interact with the controls in the console and
     *         programmatically immediately after release. However, automatically enabled controls have a temporary
     *         default status of <code>DISABLED</code>. It can take up to several days for Security Hub to process the
     *         control release and designate the control as <code>ENABLED</code> in your account. During the processing
     *         period, you can manually enable or disable a control, and Security Hub will maintain that designation
     *         regardless of whether you have <code>AutoEnableControls</code> set to <code>true</code>.
     */
    public final Boolean autoEnableControls() {
        return autoEnableControls;
    }

    /**
     * <p>
     * Updates whether the calling account has consolidated control findings turned on. If the value for this field is
     * set to <code>SECURITY_CONTROL</code>, Security Hub generates a single finding for a control check even when the
     * check applies to multiple enabled standards.
     * </p>
     * <p>
     * If the value for this field is set to <code>STANDARD_CONTROL</code>, Security Hub generates separate findings for
     * a control check when the check applies to multiple enabled standards.
     * </p>
     * <p>
     * For accounts that are part of an organization, this value can only be updated in the administrator account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #controlFindingGenerator} will return {@link ControlFindingGenerator#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #controlFindingGeneratorAsString}.
     * </p>
     * 
     * @return Updates whether the calling account has consolidated control findings turned on. If the value for this
     *         field is set to <code>SECURITY_CONTROL</code>, Security Hub generates a single finding for a control
     *         check even when the check applies to multiple enabled standards.</p>
     *         <p>
     *         If the value for this field is set to <code>STANDARD_CONTROL</code>, Security Hub generates separate
     *         findings for a control check when the check applies to multiple enabled standards.
     *         </p>
     *         <p>
     *         For accounts that are part of an organization, this value can only be updated in the administrator
     *         account.
     * @see ControlFindingGenerator
     */
    public final ControlFindingGenerator controlFindingGenerator() {
        return ControlFindingGenerator.fromValue(controlFindingGenerator);
    }

    /**
     * <p>
     * Updates whether the calling account has consolidated control findings turned on. If the value for this field is
     * set to <code>SECURITY_CONTROL</code>, Security Hub generates a single finding for a control check even when the
     * check applies to multiple enabled standards.
     * </p>
     * <p>
     * If the value for this field is set to <code>STANDARD_CONTROL</code>, Security Hub generates separate findings for
     * a control check when the check applies to multiple enabled standards.
     * </p>
     * <p>
     * For accounts that are part of an organization, this value can only be updated in the administrator account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #controlFindingGenerator} will return {@link ControlFindingGenerator#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #controlFindingGeneratorAsString}.
     * </p>
     * 
     * @return Updates whether the calling account has consolidated control findings turned on. If the value for this
     *         field is set to <code>SECURITY_CONTROL</code>, Security Hub generates a single finding for a control
     *         check even when the check applies to multiple enabled standards.</p>
     *         <p>
     *         If the value for this field is set to <code>STANDARD_CONTROL</code>, Security Hub generates separate
     *         findings for a control check when the check applies to multiple enabled standards.
     *         </p>
     *         <p>
     *         For accounts that are part of an organization, this value can only be updated in the administrator
     *         account.
     * @see ControlFindingGenerator
     */
    public final String controlFindingGeneratorAsString() {
        return controlFindingGenerator;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(autoEnableControls());
        hashCode = 31 * hashCode + Objects.hashCode(controlFindingGeneratorAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSecurityHubConfigurationRequest)) {
            return false;
        }
        UpdateSecurityHubConfigurationRequest other = (UpdateSecurityHubConfigurationRequest) obj;
        return Objects.equals(autoEnableControls(), other.autoEnableControls())
                && Objects.equals(controlFindingGeneratorAsString(), other.controlFindingGeneratorAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSecurityHubConfigurationRequest").add("AutoEnableControls", autoEnableControls())
                .add("ControlFindingGenerator", controlFindingGeneratorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoEnableControls":
            return Optional.ofNullable(clazz.cast(autoEnableControls()));
        case "ControlFindingGenerator":
            return Optional.ofNullable(clazz.cast(controlFindingGeneratorAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AutoEnableControls", AUTO_ENABLE_CONTROLS_FIELD);
        map.put("ControlFindingGenerator", CONTROL_FINDING_GENERATOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSecurityHubConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateSecurityHubConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SecurityHubRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateSecurityHubConfigurationRequest> {
        /**
         * <p>
         * Whether to automatically enable new controls when they are added to standards that are enabled.
         * </p>
         * <p>
         * By default, this is set to <code>true</code>, and new controls are enabled automatically. To not
         * automatically enable new controls, set this to <code>false</code>.
         * </p>
         * <p>
         * When you automatically enable new controls, you can interact with the controls in the console and
         * programmatically immediately after release. However, automatically enabled controls have a temporary default
         * status of <code>DISABLED</code>. It can take up to several days for Security Hub to process the control
         * release and designate the control as <code>ENABLED</code> in your account. During the processing period, you
         * can manually enable or disable a control, and Security Hub will maintain that designation regardless of
         * whether you have <code>AutoEnableControls</code> set to <code>true</code>.
         * </p>
         * 
         * @param autoEnableControls
         *        Whether to automatically enable new controls when they are added to standards that are enabled.</p>
         *        <p>
         *        By default, this is set to <code>true</code>, and new controls are enabled automatically. To not
         *        automatically enable new controls, set this to <code>false</code>.
         *        </p>
         *        <p>
         *        When you automatically enable new controls, you can interact with the controls in the console and
         *        programmatically immediately after release. However, automatically enabled controls have a temporary
         *        default status of <code>DISABLED</code>. It can take up to several days for Security Hub to process
         *        the control release and designate the control as <code>ENABLED</code> in your account. During the
         *        processing period, you can manually enable or disable a control, and Security Hub will maintain that
         *        designation regardless of whether you have <code>AutoEnableControls</code> set to <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoEnableControls(Boolean autoEnableControls);

        /**
         * <p>
         * Updates whether the calling account has consolidated control findings turned on. If the value for this field
         * is set to <code>SECURITY_CONTROL</code>, Security Hub generates a single finding for a control check even
         * when the check applies to multiple enabled standards.
         * </p>
         * <p>
         * If the value for this field is set to <code>STANDARD_CONTROL</code>, Security Hub generates separate findings
         * for a control check when the check applies to multiple enabled standards.
         * </p>
         * <p>
         * For accounts that are part of an organization, this value can only be updated in the administrator account.
         * </p>
         * 
         * @param controlFindingGenerator
         *        Updates whether the calling account has consolidated control findings turned on. If the value for this
         *        field is set to <code>SECURITY_CONTROL</code>, Security Hub generates a single finding for a control
         *        check even when the check applies to multiple enabled standards.</p>
         *        <p>
         *        If the value for this field is set to <code>STANDARD_CONTROL</code>, Security Hub generates separate
         *        findings for a control check when the check applies to multiple enabled standards.
         *        </p>
         *        <p>
         *        For accounts that are part of an organization, this value can only be updated in the administrator
         *        account.
         * @see ControlFindingGenerator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ControlFindingGenerator
         */
        Builder controlFindingGenerator(String controlFindingGenerator);

        /**
         * <p>
         * Updates whether the calling account has consolidated control findings turned on. If the value for this field
         * is set to <code>SECURITY_CONTROL</code>, Security Hub generates a single finding for a control check even
         * when the check applies to multiple enabled standards.
         * </p>
         * <p>
         * If the value for this field is set to <code>STANDARD_CONTROL</code>, Security Hub generates separate findings
         * for a control check when the check applies to multiple enabled standards.
         * </p>
         * <p>
         * For accounts that are part of an organization, this value can only be updated in the administrator account.
         * </p>
         * 
         * @param controlFindingGenerator
         *        Updates whether the calling account has consolidated control findings turned on. If the value for this
         *        field is set to <code>SECURITY_CONTROL</code>, Security Hub generates a single finding for a control
         *        check even when the check applies to multiple enabled standards.</p>
         *        <p>
         *        If the value for this field is set to <code>STANDARD_CONTROL</code>, Security Hub generates separate
         *        findings for a control check when the check applies to multiple enabled standards.
         *        </p>
         *        <p>
         *        For accounts that are part of an organization, this value can only be updated in the administrator
         *        account.
         * @see ControlFindingGenerator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ControlFindingGenerator
         */
        Builder controlFindingGenerator(ControlFindingGenerator controlFindingGenerator);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityHubRequest.BuilderImpl implements Builder {
        private Boolean autoEnableControls;

        private String controlFindingGenerator;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSecurityHubConfigurationRequest model) {
            super(model);
            autoEnableControls(model.autoEnableControls);
            controlFindingGenerator(model.controlFindingGenerator);
        }

        public final Boolean getAutoEnableControls() {
            return autoEnableControls;
        }

        public final void setAutoEnableControls(Boolean autoEnableControls) {
            this.autoEnableControls = autoEnableControls;
        }

        @Override
        public final Builder autoEnableControls(Boolean autoEnableControls) {
            this.autoEnableControls = autoEnableControls;
            return this;
        }

        public final String getControlFindingGenerator() {
            return controlFindingGenerator;
        }

        public final void setControlFindingGenerator(String controlFindingGenerator) {
            this.controlFindingGenerator = controlFindingGenerator;
        }

        @Override
        public final Builder controlFindingGenerator(String controlFindingGenerator) {
            this.controlFindingGenerator = controlFindingGenerator;
            return this;
        }

        @Override
        public final Builder controlFindingGenerator(ControlFindingGenerator controlFindingGenerator) {
            this.controlFindingGenerator(controlFindingGenerator == null ? null : controlFindingGenerator.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSecurityHubConfigurationRequest build() {
            return new UpdateSecurityHubConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
