/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the parameters to update in an existing automation rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAutomationRulesRequestItem implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateAutomationRulesRequestItem.Builder, UpdateAutomationRulesRequestItem> {
    private static final SdkField<String> RULE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleArn").getter(getter(UpdateAutomationRulesRequestItem::ruleArn)).setter(setter(Builder::ruleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleArn").build()).build();

    private static final SdkField<String> RULE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleStatus").getter(getter(UpdateAutomationRulesRequestItem::ruleStatusAsString))
            .setter(setter(Builder::ruleStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleStatus").build()).build();

    private static final SdkField<Integer> RULE_ORDER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RuleOrder").getter(getter(UpdateAutomationRulesRequestItem::ruleOrder))
            .setter(setter(Builder::ruleOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleOrder").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateAutomationRulesRequestItem::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleName").getter(getter(UpdateAutomationRulesRequestItem::ruleName)).setter(setter(Builder::ruleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleName").build()).build();

    private static final SdkField<Boolean> IS_TERMINAL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsTerminal").getter(getter(UpdateAutomationRulesRequestItem::isTerminal))
            .setter(setter(Builder::isTerminal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTerminal").build()).build();

    private static final SdkField<AutomationRulesFindingFilters> CRITERIA_FIELD = SdkField
            .<AutomationRulesFindingFilters> builder(MarshallingType.SDK_POJO).memberName("Criteria")
            .getter(getter(UpdateAutomationRulesRequestItem::criteria)).setter(setter(Builder::criteria))
            .constructor(AutomationRulesFindingFilters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Criteria").build()).build();

    private static final SdkField<List<AutomationRulesAction>> ACTIONS_FIELD = SdkField
            .<List<AutomationRulesAction>> builder(MarshallingType.LIST)
            .memberName("Actions")
            .getter(getter(UpdateAutomationRulesRequestItem::actions))
            .setter(setter(Builder::actions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutomationRulesAction> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutomationRulesAction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_ARN_FIELD,
            RULE_STATUS_FIELD, RULE_ORDER_FIELD, DESCRIPTION_FIELD, RULE_NAME_FIELD, IS_TERMINAL_FIELD, CRITERIA_FIELD,
            ACTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String ruleArn;

    private final String ruleStatus;

    private final Integer ruleOrder;

    private final String description;

    private final String ruleName;

    private final Boolean isTerminal;

    private final AutomationRulesFindingFilters criteria;

    private final List<AutomationRulesAction> actions;

    private UpdateAutomationRulesRequestItem(BuilderImpl builder) {
        this.ruleArn = builder.ruleArn;
        this.ruleStatus = builder.ruleStatus;
        this.ruleOrder = builder.ruleOrder;
        this.description = builder.description;
        this.ruleName = builder.ruleName;
        this.isTerminal = builder.isTerminal;
        this.criteria = builder.criteria;
        this.actions = builder.actions;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the rule.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the rule.
     */
    public final String ruleArn() {
        return ruleArn;
    }

    /**
     * <p>
     * Whether the rule is active after it is created. If this parameter is equal to <code>ENABLED</code>, Security Hub
     * starts applying the rule to findings and finding updates after the rule is created. To change the value of this
     * parameter after creating a rule, use <a
     * href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateAutomationRules.html">
     * <code>BatchUpdateAutomationRules</code> </a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleStatus} will
     * return {@link RuleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ruleStatusAsString}.
     * </p>
     * 
     * @return Whether the rule is active after it is created. If this parameter is equal to <code>ENABLED</code>,
     *         Security Hub starts applying the rule to findings and finding updates after the rule is created. To
     *         change the value of this parameter after creating a rule, use <a
     *         href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateAutomationRules.html">
     *         <code>BatchUpdateAutomationRules</code> </a>.
     * @see RuleStatus
     */
    public final RuleStatus ruleStatus() {
        return RuleStatus.fromValue(ruleStatus);
    }

    /**
     * <p>
     * Whether the rule is active after it is created. If this parameter is equal to <code>ENABLED</code>, Security Hub
     * starts applying the rule to findings and finding updates after the rule is created. To change the value of this
     * parameter after creating a rule, use <a
     * href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateAutomationRules.html">
     * <code>BatchUpdateAutomationRules</code> </a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleStatus} will
     * return {@link RuleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ruleStatusAsString}.
     * </p>
     * 
     * @return Whether the rule is active after it is created. If this parameter is equal to <code>ENABLED</code>,
     *         Security Hub starts applying the rule to findings and finding updates after the rule is created. To
     *         change the value of this parameter after creating a rule, use <a
     *         href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateAutomationRules.html">
     *         <code>BatchUpdateAutomationRules</code> </a>.
     * @see RuleStatus
     */
    public final String ruleStatusAsString() {
        return ruleStatus;
    }

    /**
     * <p>
     * An integer ranging from 1 to 1000 that represents the order in which the rule action is applied to findings.
     * Security Hub applies rules with lower values for this parameter first.
     * </p>
     * 
     * @return An integer ranging from 1 to 1000 that represents the order in which the rule action is applied to
     *         findings. Security Hub applies rules with lower values for this parameter first.
     */
    public final Integer ruleOrder() {
        return ruleOrder;
    }

    /**
     * <p>
     * A description of the rule.
     * </p>
     * 
     * @return A description of the rule.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The name of the rule.
     * </p>
     * 
     * @return The name of the rule.
     */
    public final String ruleName() {
        return ruleName;
    }

    /**
     * <p>
     * Specifies whether a rule is the last to be applied with respect to a finding that matches the rule criteria. This
     * is useful when a finding matches the criteria for multiple rules, and each rule has different actions. If a rule
     * is terminal, Security Hub applies the rule action to a finding that matches the rule criteria and doesn't
     * evaluate other rules for the finding. By default, a rule isn't terminal.
     * </p>
     * 
     * @return Specifies whether a rule is the last to be applied with respect to a finding that matches the rule
     *         criteria. This is useful when a finding matches the criteria for multiple rules, and each rule has
     *         different actions. If a rule is terminal, Security Hub applies the rule action to a finding that matches
     *         the rule criteria and doesn't evaluate other rules for the finding. By default, a rule isn't terminal.
     */
    public final Boolean isTerminal() {
        return isTerminal;
    }

    /**
     * <p>
     * A set of ASFF finding field attributes and corresponding expected values that Security Hub uses to filter
     * findings. If a rule is enabled and a finding matches the conditions specified in this parameter, Security Hub
     * applies the rule action to the finding.
     * </p>
     * 
     * @return A set of ASFF finding field attributes and corresponding expected values that Security Hub uses to filter
     *         findings. If a rule is enabled and a finding matches the conditions specified in this parameter, Security
     *         Hub applies the rule action to the finding.
     */
    public final AutomationRulesFindingFilters criteria() {
        return criteria;
    }

    /**
     * For responses, this returns true if the service returned a value for the Actions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasActions() {
        return actions != null && !(actions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more actions to update finding fields if a finding matches the conditions specified in
     * <code>Criteria</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActions} method.
     * </p>
     * 
     * @return One or more actions to update finding fields if a finding matches the conditions specified in
     *         <code>Criteria</code>.
     */
    public final List<AutomationRulesAction> actions() {
        return actions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ruleArn());
        hashCode = 31 * hashCode + Objects.hashCode(ruleStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ruleOrder());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(isTerminal());
        hashCode = 31 * hashCode + Objects.hashCode(criteria());
        hashCode = 31 * hashCode + Objects.hashCode(hasActions() ? actions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAutomationRulesRequestItem)) {
            return false;
        }
        UpdateAutomationRulesRequestItem other = (UpdateAutomationRulesRequestItem) obj;
        return Objects.equals(ruleArn(), other.ruleArn()) && Objects.equals(ruleStatusAsString(), other.ruleStatusAsString())
                && Objects.equals(ruleOrder(), other.ruleOrder()) && Objects.equals(description(), other.description())
                && Objects.equals(ruleName(), other.ruleName()) && Objects.equals(isTerminal(), other.isTerminal())
                && Objects.equals(criteria(), other.criteria()) && hasActions() == other.hasActions()
                && Objects.equals(actions(), other.actions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAutomationRulesRequestItem").add("RuleArn", ruleArn())
                .add("RuleStatus", ruleStatusAsString()).add("RuleOrder", ruleOrder()).add("Description", description())
                .add("RuleName", ruleName()).add("IsTerminal", isTerminal()).add("Criteria", criteria())
                .add("Actions", hasActions() ? actions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleArn":
            return Optional.ofNullable(clazz.cast(ruleArn()));
        case "RuleStatus":
            return Optional.ofNullable(clazz.cast(ruleStatusAsString()));
        case "RuleOrder":
            return Optional.ofNullable(clazz.cast(ruleOrder()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "RuleName":
            return Optional.ofNullable(clazz.cast(ruleName()));
        case "IsTerminal":
            return Optional.ofNullable(clazz.cast(isTerminal()));
        case "Criteria":
            return Optional.ofNullable(clazz.cast(criteria()));
        case "Actions":
            return Optional.ofNullable(clazz.cast(actions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RuleArn", RULE_ARN_FIELD);
        map.put("RuleStatus", RULE_STATUS_FIELD);
        map.put("RuleOrder", RULE_ORDER_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("RuleName", RULE_NAME_FIELD);
        map.put("IsTerminal", IS_TERMINAL_FIELD);
        map.put("Criteria", CRITERIA_FIELD);
        map.put("Actions", ACTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAutomationRulesRequestItem, T> g) {
        return obj -> g.apply((UpdateAutomationRulesRequestItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateAutomationRulesRequestItem> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the rule.
         * </p>
         * 
         * @param ruleArn
         *        The Amazon Resource Name (ARN) for the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleArn(String ruleArn);

        /**
         * <p>
         * Whether the rule is active after it is created. If this parameter is equal to <code>ENABLED</code>, Security
         * Hub starts applying the rule to findings and finding updates after the rule is created. To change the value
         * of this parameter after creating a rule, use <a
         * href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateAutomationRules.html">
         * <code>BatchUpdateAutomationRules</code> </a>.
         * </p>
         * 
         * @param ruleStatus
         *        Whether the rule is active after it is created. If this parameter is equal to <code>ENABLED</code>,
         *        Security Hub starts applying the rule to findings and finding updates after the rule is created. To
         *        change the value of this parameter after creating a rule, use <a
         *        href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateAutomationRules.html">
         *        <code>BatchUpdateAutomationRules</code> </a>.
         * @see RuleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleStatus
         */
        Builder ruleStatus(String ruleStatus);

        /**
         * <p>
         * Whether the rule is active after it is created. If this parameter is equal to <code>ENABLED</code>, Security
         * Hub starts applying the rule to findings and finding updates after the rule is created. To change the value
         * of this parameter after creating a rule, use <a
         * href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateAutomationRules.html">
         * <code>BatchUpdateAutomationRules</code> </a>.
         * </p>
         * 
         * @param ruleStatus
         *        Whether the rule is active after it is created. If this parameter is equal to <code>ENABLED</code>,
         *        Security Hub starts applying the rule to findings and finding updates after the rule is created. To
         *        change the value of this parameter after creating a rule, use <a
         *        href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateAutomationRules.html">
         *        <code>BatchUpdateAutomationRules</code> </a>.
         * @see RuleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleStatus
         */
        Builder ruleStatus(RuleStatus ruleStatus);

        /**
         * <p>
         * An integer ranging from 1 to 1000 that represents the order in which the rule action is applied to findings.
         * Security Hub applies rules with lower values for this parameter first.
         * </p>
         * 
         * @param ruleOrder
         *        An integer ranging from 1 to 1000 that represents the order in which the rule action is applied to
         *        findings. Security Hub applies rules with lower values for this parameter first.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleOrder(Integer ruleOrder);

        /**
         * <p>
         * A description of the rule.
         * </p>
         * 
         * @param description
         *        A description of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the rule.
         * </p>
         * 
         * @param ruleName
         *        The name of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleName(String ruleName);

        /**
         * <p>
         * Specifies whether a rule is the last to be applied with respect to a finding that matches the rule criteria.
         * This is useful when a finding matches the criteria for multiple rules, and each rule has different actions.
         * If a rule is terminal, Security Hub applies the rule action to a finding that matches the rule criteria and
         * doesn't evaluate other rules for the finding. By default, a rule isn't terminal.
         * </p>
         * 
         * @param isTerminal
         *        Specifies whether a rule is the last to be applied with respect to a finding that matches the rule
         *        criteria. This is useful when a finding matches the criteria for multiple rules, and each rule has
         *        different actions. If a rule is terminal, Security Hub applies the rule action to a finding that
         *        matches the rule criteria and doesn't evaluate other rules for the finding. By default, a rule isn't
         *        terminal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isTerminal(Boolean isTerminal);

        /**
         * <p>
         * A set of ASFF finding field attributes and corresponding expected values that Security Hub uses to filter
         * findings. If a rule is enabled and a finding matches the conditions specified in this parameter, Security Hub
         * applies the rule action to the finding.
         * </p>
         * 
         * @param criteria
         *        A set of ASFF finding field attributes and corresponding expected values that Security Hub uses to
         *        filter findings. If a rule is enabled and a finding matches the conditions specified in this
         *        parameter, Security Hub applies the rule action to the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder criteria(AutomationRulesFindingFilters criteria);

        /**
         * <p>
         * A set of ASFF finding field attributes and corresponding expected values that Security Hub uses to filter
         * findings. If a rule is enabled and a finding matches the conditions specified in this parameter, Security Hub
         * applies the rule action to the finding.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutomationRulesFindingFilters.Builder}
         * avoiding the need to create one manually via {@link AutomationRulesFindingFilters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomationRulesFindingFilters.Builder#build()} is called
         * immediately and its result is passed to {@link #criteria(AutomationRulesFindingFilters)}.
         * 
         * @param criteria
         *        a consumer that will call methods on {@link AutomationRulesFindingFilters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #criteria(AutomationRulesFindingFilters)
         */
        default Builder criteria(Consumer<AutomationRulesFindingFilters.Builder> criteria) {
            return criteria(AutomationRulesFindingFilters.builder().applyMutation(criteria).build());
        }

        /**
         * <p>
         * One or more actions to update finding fields if a finding matches the conditions specified in
         * <code>Criteria</code>.
         * </p>
         * 
         * @param actions
         *        One or more actions to update finding fields if a finding matches the conditions specified in
         *        <code>Criteria</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Collection<AutomationRulesAction> actions);

        /**
         * <p>
         * One or more actions to update finding fields if a finding matches the conditions specified in
         * <code>Criteria</code>.
         * </p>
         * 
         * @param actions
         *        One or more actions to update finding fields if a finding matches the conditions specified in
         *        <code>Criteria</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(AutomationRulesAction... actions);

        /**
         * <p>
         * One or more actions to update finding fields if a finding matches the conditions specified in
         * <code>Criteria</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AutomationRulesAction.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AutomationRulesAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AutomationRulesAction.Builder#build()} is called
         * immediately and its result is passed to {@link #actions(List<AutomationRulesAction>)}.
         * 
         * @param actions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AutomationRulesAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actions(java.util.Collection<AutomationRulesAction>)
         */
        Builder actions(Consumer<AutomationRulesAction.Builder>... actions);
    }

    static final class BuilderImpl implements Builder {
        private String ruleArn;

        private String ruleStatus;

        private Integer ruleOrder;

        private String description;

        private String ruleName;

        private Boolean isTerminal;

        private AutomationRulesFindingFilters criteria;

        private List<AutomationRulesAction> actions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAutomationRulesRequestItem model) {
            ruleArn(model.ruleArn);
            ruleStatus(model.ruleStatus);
            ruleOrder(model.ruleOrder);
            description(model.description);
            ruleName(model.ruleName);
            isTerminal(model.isTerminal);
            criteria(model.criteria);
            actions(model.actions);
        }

        public final String getRuleArn() {
            return ruleArn;
        }

        public final void setRuleArn(String ruleArn) {
            this.ruleArn = ruleArn;
        }

        @Override
        public final Builder ruleArn(String ruleArn) {
            this.ruleArn = ruleArn;
            return this;
        }

        public final String getRuleStatus() {
            return ruleStatus;
        }

        public final void setRuleStatus(String ruleStatus) {
            this.ruleStatus = ruleStatus;
        }

        @Override
        public final Builder ruleStatus(String ruleStatus) {
            this.ruleStatus = ruleStatus;
            return this;
        }

        @Override
        public final Builder ruleStatus(RuleStatus ruleStatus) {
            this.ruleStatus(ruleStatus == null ? null : ruleStatus.toString());
            return this;
        }

        public final Integer getRuleOrder() {
            return ruleOrder;
        }

        public final void setRuleOrder(Integer ruleOrder) {
            this.ruleOrder = ruleOrder;
        }

        @Override
        public final Builder ruleOrder(Integer ruleOrder) {
            this.ruleOrder = ruleOrder;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getRuleName() {
            return ruleName;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final Boolean getIsTerminal() {
            return isTerminal;
        }

        public final void setIsTerminal(Boolean isTerminal) {
            this.isTerminal = isTerminal;
        }

        @Override
        public final Builder isTerminal(Boolean isTerminal) {
            this.isTerminal = isTerminal;
            return this;
        }

        public final AutomationRulesFindingFilters.Builder getCriteria() {
            return criteria != null ? criteria.toBuilder() : null;
        }

        public final void setCriteria(AutomationRulesFindingFilters.BuilderImpl criteria) {
            this.criteria = criteria != null ? criteria.build() : null;
        }

        @Override
        public final Builder criteria(AutomationRulesFindingFilters criteria) {
            this.criteria = criteria;
            return this;
        }

        public final List<AutomationRulesAction.Builder> getActions() {
            List<AutomationRulesAction.Builder> result = ActionListCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActions(Collection<AutomationRulesAction.BuilderImpl> actions) {
            this.actions = ActionListCopier.copyFromBuilder(actions);
        }

        @Override
        public final Builder actions(Collection<AutomationRulesAction> actions) {
            this.actions = ActionListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(AutomationRulesAction... actions) {
            actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<AutomationRulesAction.Builder>... actions) {
            actions(Stream.of(actions).map(c -> AutomationRulesAction.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public UpdateAutomationRulesRequestItem build() {
            return new UpdateAutomationRulesRequestItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
