/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAutomationRuleV2Request extends SecurityHubRequest implements
        ToCopyableBuilder<UpdateAutomationRuleV2Request.Builder, UpdateAutomationRuleV2Request> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identifier").getter(getter(UpdateAutomationRuleV2Request::identifier))
            .setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Identifier").build()).build();

    private static final SdkField<String> RULE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleStatus").getter(getter(UpdateAutomationRuleV2Request::ruleStatusAsString))
            .setter(setter(Builder::ruleStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleStatus").build()).build();

    private static final SdkField<Float> RULE_ORDER_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("RuleOrder").getter(getter(UpdateAutomationRuleV2Request::ruleOrder)).setter(setter(Builder::ruleOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleOrder").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateAutomationRuleV2Request::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleName").getter(getter(UpdateAutomationRuleV2Request::ruleName)).setter(setter(Builder::ruleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleName").build()).build();

    private static final SdkField<Criteria> CRITERIA_FIELD = SdkField.<Criteria> builder(MarshallingType.SDK_POJO)
            .memberName("Criteria").getter(getter(UpdateAutomationRuleV2Request::criteria)).setter(setter(Builder::criteria))
            .constructor(Criteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Criteria").build()).build();

    private static final SdkField<List<AutomationRulesActionV2>> ACTIONS_FIELD = SdkField
            .<List<AutomationRulesActionV2>> builder(MarshallingType.LIST)
            .memberName("Actions")
            .getter(getter(UpdateAutomationRuleV2Request::actions))
            .setter(setter(Builder::actions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutomationRulesActionV2> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutomationRulesActionV2::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD,
            RULE_STATUS_FIELD, RULE_ORDER_FIELD, DESCRIPTION_FIELD, RULE_NAME_FIELD, CRITERIA_FIELD, ACTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String identifier;

    private final String ruleStatus;

    private final Float ruleOrder;

    private final String description;

    private final String ruleName;

    private final Criteria criteria;

    private final List<AutomationRulesActionV2> actions;

    private UpdateAutomationRuleV2Request(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.ruleStatus = builder.ruleStatus;
        this.ruleOrder = builder.ruleOrder;
        this.description = builder.description;
        this.ruleName = builder.ruleName;
        this.criteria = builder.criteria;
        this.actions = builder.actions;
    }

    /**
     * <p>
     * The ARN of the automation rule.
     * </p>
     * 
     * @return The ARN of the automation rule.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * The status of the automation rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleStatus} will
     * return {@link RuleStatusV2#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ruleStatusAsString}.
     * </p>
     * 
     * @return The status of the automation rule.
     * @see RuleStatusV2
     */
    public final RuleStatusV2 ruleStatus() {
        return RuleStatusV2.fromValue(ruleStatus);
    }

    /**
     * <p>
     * The status of the automation rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleStatus} will
     * return {@link RuleStatusV2#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ruleStatusAsString}.
     * </p>
     * 
     * @return The status of the automation rule.
     * @see RuleStatusV2
     */
    public final String ruleStatusAsString() {
        return ruleStatus;
    }

    /**
     * <p>
     * Represents a value for the rule priority.
     * </p>
     * 
     * @return Represents a value for the rule priority.
     */
    public final Float ruleOrder() {
        return ruleOrder;
    }

    /**
     * <p>
     * A description of the automation rule.
     * </p>
     * 
     * @return A description of the automation rule.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The name of the automation rule.
     * </p>
     * 
     * @return The name of the automation rule.
     */
    public final String ruleName() {
        return ruleName;
    }

    /**
     * <p>
     * The filtering type and configuration of the automation rule.
     * </p>
     * 
     * @return The filtering type and configuration of the automation rule.
     */
    public final Criteria criteria() {
        return criteria;
    }

    /**
     * For responses, this returns true if the service returned a value for the Actions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasActions() {
        return actions != null && !(actions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of actions to be performed when the rule criteria is met.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActions} method.
     * </p>
     * 
     * @return A list of actions to be performed when the rule criteria is met.
     */
    public final List<AutomationRulesActionV2> actions() {
        return actions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(ruleStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ruleOrder());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(criteria());
        hashCode = 31 * hashCode + Objects.hashCode(hasActions() ? actions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAutomationRuleV2Request)) {
            return false;
        }
        UpdateAutomationRuleV2Request other = (UpdateAutomationRuleV2Request) obj;
        return Objects.equals(identifier(), other.identifier())
                && Objects.equals(ruleStatusAsString(), other.ruleStatusAsString())
                && Objects.equals(ruleOrder(), other.ruleOrder()) && Objects.equals(description(), other.description())
                && Objects.equals(ruleName(), other.ruleName()) && Objects.equals(criteria(), other.criteria())
                && hasActions() == other.hasActions() && Objects.equals(actions(), other.actions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAutomationRuleV2Request").add("Identifier", identifier())
                .add("RuleStatus", ruleStatusAsString()).add("RuleOrder", ruleOrder()).add("Description", description())
                .add("RuleName", ruleName()).add("Criteria", criteria()).add("Actions", hasActions() ? actions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "RuleStatus":
            return Optional.ofNullable(clazz.cast(ruleStatusAsString()));
        case "RuleOrder":
            return Optional.ofNullable(clazz.cast(ruleOrder()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "RuleName":
            return Optional.ofNullable(clazz.cast(ruleName()));
        case "Criteria":
            return Optional.ofNullable(clazz.cast(criteria()));
        case "Actions":
            return Optional.ofNullable(clazz.cast(actions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Identifier", IDENTIFIER_FIELD);
        map.put("RuleStatus", RULE_STATUS_FIELD);
        map.put("RuleOrder", RULE_ORDER_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("RuleName", RULE_NAME_FIELD);
        map.put("Criteria", CRITERIA_FIELD);
        map.put("Actions", ACTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAutomationRuleV2Request, T> g) {
        return obj -> g.apply((UpdateAutomationRuleV2Request) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SecurityHubRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateAutomationRuleV2Request> {
        /**
         * <p>
         * The ARN of the automation rule.
         * </p>
         * 
         * @param identifier
         *        The ARN of the automation rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * The status of the automation rule.
         * </p>
         * 
         * @param ruleStatus
         *        The status of the automation rule.
         * @see RuleStatusV2
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleStatusV2
         */
        Builder ruleStatus(String ruleStatus);

        /**
         * <p>
         * The status of the automation rule.
         * </p>
         * 
         * @param ruleStatus
         *        The status of the automation rule.
         * @see RuleStatusV2
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleStatusV2
         */
        Builder ruleStatus(RuleStatusV2 ruleStatus);

        /**
         * <p>
         * Represents a value for the rule priority.
         * </p>
         * 
         * @param ruleOrder
         *        Represents a value for the rule priority.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleOrder(Float ruleOrder);

        /**
         * <p>
         * A description of the automation rule.
         * </p>
         * 
         * @param description
         *        A description of the automation rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the automation rule.
         * </p>
         * 
         * @param ruleName
         *        The name of the automation rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleName(String ruleName);

        /**
         * <p>
         * The filtering type and configuration of the automation rule.
         * </p>
         * 
         * @param criteria
         *        The filtering type and configuration of the automation rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder criteria(Criteria criteria);

        /**
         * <p>
         * The filtering type and configuration of the automation rule.
         * </p>
         * This is a convenience method that creates an instance of the {@link Criteria.Builder} avoiding the need to
         * create one manually via {@link Criteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Criteria.Builder#build()} is called immediately and its result is
         * passed to {@link #criteria(Criteria)}.
         * 
         * @param criteria
         *        a consumer that will call methods on {@link Criteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #criteria(Criteria)
         */
        default Builder criteria(Consumer<Criteria.Builder> criteria) {
            return criteria(Criteria.builder().applyMutation(criteria).build());
        }

        /**
         * <p>
         * A list of actions to be performed when the rule criteria is met.
         * </p>
         * 
         * @param actions
         *        A list of actions to be performed when the rule criteria is met.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Collection<AutomationRulesActionV2> actions);

        /**
         * <p>
         * A list of actions to be performed when the rule criteria is met.
         * </p>
         * 
         * @param actions
         *        A list of actions to be performed when the rule criteria is met.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(AutomationRulesActionV2... actions);

        /**
         * <p>
         * A list of actions to be performed when the rule criteria is met.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AutomationRulesActionV2.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AutomationRulesActionV2#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AutomationRulesActionV2.Builder#build()} is called
         * immediately and its result is passed to {@link #actions(List<AutomationRulesActionV2>)}.
         * 
         * @param actions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AutomationRulesActionV2.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actions(java.util.Collection<AutomationRulesActionV2>)
         */
        Builder actions(Consumer<AutomationRulesActionV2.Builder>... actions);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityHubRequest.BuilderImpl implements Builder {
        private String identifier;

        private String ruleStatus;

        private Float ruleOrder;

        private String description;

        private String ruleName;

        private Criteria criteria;

        private List<AutomationRulesActionV2> actions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAutomationRuleV2Request model) {
            super(model);
            identifier(model.identifier);
            ruleStatus(model.ruleStatus);
            ruleOrder(model.ruleOrder);
            description(model.description);
            ruleName(model.ruleName);
            criteria(model.criteria);
            actions(model.actions);
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getRuleStatus() {
            return ruleStatus;
        }

        public final void setRuleStatus(String ruleStatus) {
            this.ruleStatus = ruleStatus;
        }

        @Override
        public final Builder ruleStatus(String ruleStatus) {
            this.ruleStatus = ruleStatus;
            return this;
        }

        @Override
        public final Builder ruleStatus(RuleStatusV2 ruleStatus) {
            this.ruleStatus(ruleStatus == null ? null : ruleStatus.toString());
            return this;
        }

        public final Float getRuleOrder() {
            return ruleOrder;
        }

        public final void setRuleOrder(Float ruleOrder) {
            this.ruleOrder = ruleOrder;
        }

        @Override
        public final Builder ruleOrder(Float ruleOrder) {
            this.ruleOrder = ruleOrder;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getRuleName() {
            return ruleName;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final Criteria.Builder getCriteria() {
            return criteria != null ? criteria.toBuilder() : null;
        }

        public final void setCriteria(Criteria.BuilderImpl criteria) {
            this.criteria = criteria != null ? criteria.build() : null;
        }

        @Override
        public final Builder criteria(Criteria criteria) {
            this.criteria = criteria;
            return this;
        }

        public final List<AutomationRulesActionV2.Builder> getActions() {
            List<AutomationRulesActionV2.Builder> result = AutomationRulesActionListV2Copier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActions(Collection<AutomationRulesActionV2.BuilderImpl> actions) {
            this.actions = AutomationRulesActionListV2Copier.copyFromBuilder(actions);
        }

        @Override
        public final Builder actions(Collection<AutomationRulesActionV2> actions) {
            this.actions = AutomationRulesActionListV2Copier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(AutomationRulesActionV2... actions) {
            actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<AutomationRulesActionV2.Builder>... actions) {
            actions(Stream.of(actions).map(c -> AutomationRulesActionV2.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAutomationRuleV2Request build() {
            return new UpdateAutomationRuleV2Request(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
