/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the findings trend metrics data for a specific time point in the requested time period.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrendsMetricsResult implements SdkPojo, Serializable,
        ToCopyableBuilder<TrendsMetricsResult.Builder, TrendsMetricsResult> {
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("Timestamp")
            .getter(getter(TrendsMetricsResult::timestamp))
            .setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<TrendsValues> TRENDS_VALUES_FIELD = SdkField.<TrendsValues> builder(MarshallingType.SDK_POJO)
            .memberName("TrendsValues").getter(getter(TrendsMetricsResult::trendsValues)).setter(setter(Builder::trendsValues))
            .constructor(TrendsValues::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrendsValues").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMESTAMP_FIELD,
            TRENDS_VALUES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant timestamp;

    private final TrendsValues trendsValues;

    private TrendsMetricsResult(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.trendsValues = builder.trendsValues;
    }

    /**
     * <p>
     * The timestamp for this data point in the findings trend metrics.
     * </p>
     * 
     * @return The timestamp for this data point in the findings trend metrics.
     */
    public final Instant timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * The finding trend metric values associated with this timestamp, including severity counts.
     * </p>
     * 
     * @return The finding trend metric values associated with this timestamp, including severity counts.
     */
    public final TrendsValues trendsValues() {
        return trendsValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(trendsValues());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrendsMetricsResult)) {
            return false;
        }
        TrendsMetricsResult other = (TrendsMetricsResult) obj;
        return Objects.equals(timestamp(), other.timestamp()) && Objects.equals(trendsValues(), other.trendsValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrendsMetricsResult").add("Timestamp", timestamp()).add("TrendsValues", trendsValues()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "TrendsValues":
            return Optional.ofNullable(clazz.cast(trendsValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Timestamp", TIMESTAMP_FIELD);
        map.put("TrendsValues", TRENDS_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TrendsMetricsResult, T> g) {
        return obj -> g.apply((TrendsMetricsResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrendsMetricsResult> {
        /**
         * <p>
         * The timestamp for this data point in the findings trend metrics.
         * </p>
         * 
         * @param timestamp
         *        The timestamp for this data point in the findings trend metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);

        /**
         * <p>
         * The finding trend metric values associated with this timestamp, including severity counts.
         * </p>
         * 
         * @param trendsValues
         *        The finding trend metric values associated with this timestamp, including severity counts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trendsValues(TrendsValues trendsValues);

        /**
         * <p>
         * The finding trend metric values associated with this timestamp, including severity counts.
         * </p>
         * This is a convenience method that creates an instance of the {@link TrendsValues.Builder} avoiding the need
         * to create one manually via {@link TrendsValues#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrendsValues.Builder#build()} is called immediately and its
         * result is passed to {@link #trendsValues(TrendsValues)}.
         * 
         * @param trendsValues
         *        a consumer that will call methods on {@link TrendsValues.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trendsValues(TrendsValues)
         */
        default Builder trendsValues(Consumer<TrendsValues.Builder> trendsValues) {
            return trendsValues(TrendsValues.builder().applyMutation(trendsValues).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Instant timestamp;

        private TrendsValues trendsValues;

        private BuilderImpl() {
        }

        private BuilderImpl(TrendsMetricsResult model) {
            timestamp(model.timestamp);
            trendsValues(model.trendsValues);
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final TrendsValues.Builder getTrendsValues() {
            return trendsValues != null ? trendsValues.toBuilder() : null;
        }

        public final void setTrendsValues(TrendsValues.BuilderImpl trendsValues) {
            this.trendsValues = trendsValues != null ? trendsValues.build() : null;
        }

        @Override
        public final Builder trendsValues(TrendsValues trendsValues) {
            this.trendsValues = trendsValues;
            return this;
        }

        @Override
        public TrendsMetricsResult build() {
            return new TrendsMetricsResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
