/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The options for customizing a security control parameter that is a string.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StringConfigurationOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<StringConfigurationOptions.Builder, StringConfigurationOptions> {
    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultValue").getter(getter(StringConfigurationOptions::defaultValue))
            .setter(setter(Builder::defaultValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultValue").build()).build();

    private static final SdkField<String> RE2_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Re2Expression").getter(getter(StringConfigurationOptions::re2Expression))
            .setter(setter(Builder::re2Expression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Re2Expression").build()).build();

    private static final SdkField<String> EXPRESSION_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExpressionDescription").getter(getter(StringConfigurationOptions::expressionDescription))
            .setter(setter(Builder::expressionDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpressionDescription").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_VALUE_FIELD,
            RE2_EXPRESSION_FIELD, EXPRESSION_DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String defaultValue;

    private final String re2Expression;

    private final String expressionDescription;

    private StringConfigurationOptions(BuilderImpl builder) {
        this.defaultValue = builder.defaultValue;
        this.re2Expression = builder.re2Expression;
        this.expressionDescription = builder.expressionDescription;
    }

    /**
     * <p>
     * The Security Hub default value for a control parameter that is a string.
     * </p>
     * 
     * @return The Security Hub default value for a control parameter that is a string.
     */
    public final String defaultValue() {
        return defaultValue;
    }

    /**
     * <p>
     * An RE2 regular expression that Security Hub uses to validate a user-provided control parameter string.
     * </p>
     * 
     * @return An RE2 regular expression that Security Hub uses to validate a user-provided control parameter string.
     */
    public final String re2Expression() {
        return re2Expression;
    }

    /**
     * <p>
     * The description of the RE2 regular expression.
     * </p>
     * 
     * @return The description of the RE2 regular expression.
     */
    public final String expressionDescription() {
        return expressionDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(re2Expression());
        hashCode = 31 * hashCode + Objects.hashCode(expressionDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StringConfigurationOptions)) {
            return false;
        }
        StringConfigurationOptions other = (StringConfigurationOptions) obj;
        return Objects.equals(defaultValue(), other.defaultValue()) && Objects.equals(re2Expression(), other.re2Expression())
                && Objects.equals(expressionDescription(), other.expressionDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StringConfigurationOptions").add("DefaultValue", defaultValue())
                .add("Re2Expression", re2Expression()).add("ExpressionDescription", expressionDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DefaultValue":
            return Optional.ofNullable(clazz.cast(defaultValue()));
        case "Re2Expression":
            return Optional.ofNullable(clazz.cast(re2Expression()));
        case "ExpressionDescription":
            return Optional.ofNullable(clazz.cast(expressionDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DefaultValue", DEFAULT_VALUE_FIELD);
        map.put("Re2Expression", RE2_EXPRESSION_FIELD);
        map.put("ExpressionDescription", EXPRESSION_DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StringConfigurationOptions, T> g) {
        return obj -> g.apply((StringConfigurationOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StringConfigurationOptions> {
        /**
         * <p>
         * The Security Hub default value for a control parameter that is a string.
         * </p>
         * 
         * @param defaultValue
         *        The Security Hub default value for a control parameter that is a string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValue(String defaultValue);

        /**
         * <p>
         * An RE2 regular expression that Security Hub uses to validate a user-provided control parameter string.
         * </p>
         * 
         * @param re2Expression
         *        An RE2 regular expression that Security Hub uses to validate a user-provided control parameter string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder re2Expression(String re2Expression);

        /**
         * <p>
         * The description of the RE2 regular expression.
         * </p>
         * 
         * @param expressionDescription
         *        The description of the RE2 regular expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expressionDescription(String expressionDescription);
    }

    static final class BuilderImpl implements Builder {
        private String defaultValue;

        private String re2Expression;

        private String expressionDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(StringConfigurationOptions model) {
            defaultValue(model.defaultValue);
            re2Expression(model.re2Expression);
            expressionDescription(model.expressionDescription);
        }

        public final String getDefaultValue() {
            return defaultValue;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final String getRe2Expression() {
            return re2Expression;
        }

        public final void setRe2Expression(String re2Expression) {
            this.re2Expression = re2Expression;
        }

        @Override
        public final Builder re2Expression(String re2Expression) {
            this.re2Expression = re2Expression;
            return this;
        }

        public final String getExpressionDescription() {
            return expressionDescription;
        }

        public final void setExpressionDescription(String expressionDescription) {
            this.expressionDescription = expressionDescription;
        }

        @Override
        public final Builder expressionDescription(String expressionDescription) {
            this.expressionDescription = expressionDescription;
            return this;
        }

        @Override
        public StringConfigurationOptions build() {
            return new StringConfigurationOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
