/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A resource that represents your subscription to a supported standard.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StandardsSubscription implements SdkPojo, Serializable,
        ToCopyableBuilder<StandardsSubscription.Builder, StandardsSubscription> {
    private static final SdkField<String> STANDARDS_SUBSCRIPTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StandardsSubscriptionArn").getter(getter(StandardsSubscription::standardsSubscriptionArn))
            .setter(setter(Builder::standardsSubscriptionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardsSubscriptionArn").build())
            .build();

    private static final SdkField<String> STANDARDS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StandardsArn").getter(getter(StandardsSubscription::standardsArn)).setter(setter(Builder::standardsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardsArn").build()).build();

    private static final SdkField<Map<String, String>> STANDARDS_INPUT_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("StandardsInput")
            .getter(getter(StandardsSubscription::standardsInput))
            .setter(setter(Builder::standardsInput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardsInput").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> STANDARDS_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StandardsStatus").getter(getter(StandardsSubscription::standardsStatusAsString))
            .setter(setter(Builder::standardsStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardsStatus").build()).build();

    private static final SdkField<String> STANDARDS_CONTROLS_UPDATABLE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("StandardsControlsUpdatable")
            .getter(getter(StandardsSubscription::standardsControlsUpdatableAsString))
            .setter(setter(Builder::standardsControlsUpdatable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardsControlsUpdatable").build())
            .build();

    private static final SdkField<StandardsStatusReason> STANDARDS_STATUS_REASON_FIELD = SdkField
            .<StandardsStatusReason> builder(MarshallingType.SDK_POJO).memberName("StandardsStatusReason")
            .getter(getter(StandardsSubscription::standardsStatusReason)).setter(setter(Builder::standardsStatusReason))
            .constructor(StandardsStatusReason::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardsStatusReason").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            STANDARDS_SUBSCRIPTION_ARN_FIELD, STANDARDS_ARN_FIELD, STANDARDS_INPUT_FIELD, STANDARDS_STATUS_FIELD,
            STANDARDS_CONTROLS_UPDATABLE_FIELD, STANDARDS_STATUS_REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String standardsSubscriptionArn;

    private final String standardsArn;

    private final Map<String, String> standardsInput;

    private final String standardsStatus;

    private final String standardsControlsUpdatable;

    private final StandardsStatusReason standardsStatusReason;

    private StandardsSubscription(BuilderImpl builder) {
        this.standardsSubscriptionArn = builder.standardsSubscriptionArn;
        this.standardsArn = builder.standardsArn;
        this.standardsInput = builder.standardsInput;
        this.standardsStatus = builder.standardsStatus;
        this.standardsControlsUpdatable = builder.standardsControlsUpdatable;
        this.standardsStatusReason = builder.standardsStatusReason;
    }

    /**
     * <p>
     * The ARN of the resource that represents your subscription to the standard.
     * </p>
     * 
     * @return The ARN of the resource that represents your subscription to the standard.
     */
    public final String standardsSubscriptionArn() {
        return standardsSubscriptionArn;
    }

    /**
     * <p>
     * The ARN of the standard.
     * </p>
     * 
     * @return The ARN of the standard.
     */
    public final String standardsArn() {
        return standardsArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the StandardsInput property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStandardsInput() {
        return standardsInput != null && !(standardsInput instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A key-value pair of input for the standard.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStandardsInput} method.
     * </p>
     * 
     * @return A key-value pair of input for the standard.
     */
    public final Map<String, String> standardsInput() {
        return standardsInput;
    }

    /**
     * <p>
     * The status of your subscription to the standard. Possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code> - The standard is in the process of being enabled. Or the standard is already enabled and
     * Security Hub is adding new controls to the standard.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>READY</code> - The standard is enabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INCOMPLETE</code> - The standard could not be enabled completely. One or more errors (
     * <code>StandardsStatusReason</code>) occurred when Security Hub attempted to enable the standard.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code> - The standard is in the process of being disabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> - The standard could not be disabled. One or more errors (<code>StandardsStatusReason</code>)
     * occurred when Security Hub attempted to disable the standard.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #standardsStatus}
     * will return {@link StandardsStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #standardsStatusAsString}.
     * </p>
     * 
     * @return The status of your subscription to the standard. Possible values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PENDING</code> - The standard is in the process of being enabled. Or the standard is already
     *         enabled and Security Hub is adding new controls to the standard.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>READY</code> - The standard is enabled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INCOMPLETE</code> - The standard could not be enabled completely. One or more errors (
     *         <code>StandardsStatusReason</code>) occurred when Security Hub attempted to enable the standard.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code> - The standard is in the process of being disabled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> - The standard could not be disabled. One or more errors (
     *         <code>StandardsStatusReason</code>) occurred when Security Hub attempted to disable the standard.
     *         </p>
     *         </li>
     * @see StandardsStatus
     */
    public final StandardsStatus standardsStatus() {
        return StandardsStatus.fromValue(standardsStatus);
    }

    /**
     * <p>
     * The status of your subscription to the standard. Possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code> - The standard is in the process of being enabled. Or the standard is already enabled and
     * Security Hub is adding new controls to the standard.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>READY</code> - The standard is enabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INCOMPLETE</code> - The standard could not be enabled completely. One or more errors (
     * <code>StandardsStatusReason</code>) occurred when Security Hub attempted to enable the standard.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code> - The standard is in the process of being disabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> - The standard could not be disabled. One or more errors (<code>StandardsStatusReason</code>)
     * occurred when Security Hub attempted to disable the standard.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #standardsStatus}
     * will return {@link StandardsStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #standardsStatusAsString}.
     * </p>
     * 
     * @return The status of your subscription to the standard. Possible values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PENDING</code> - The standard is in the process of being enabled. Or the standard is already
     *         enabled and Security Hub is adding new controls to the standard.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>READY</code> - The standard is enabled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INCOMPLETE</code> - The standard could not be enabled completely. One or more errors (
     *         <code>StandardsStatusReason</code>) occurred when Security Hub attempted to enable the standard.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code> - The standard is in the process of being disabled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> - The standard could not be disabled. One or more errors (
     *         <code>StandardsStatusReason</code>) occurred when Security Hub attempted to disable the standard.
     *         </p>
     *         </li>
     * @see StandardsStatus
     */
    public final String standardsStatusAsString() {
        return standardsStatus;
    }

    /**
     * <p>
     * Specifies whether you can retrieve information about and configure individual controls that apply to the
     * standard. Possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>READY_FOR_UPDATES</code> - Controls in the standard can be retrieved and configured.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NOT_READY_FOR_UPDATES</code> - Controls in the standard cannot be retrieved or configured.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #standardsControlsUpdatable} will return {@link StandardsControlsUpdatable#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #standardsControlsUpdatableAsString}.
     * </p>
     * 
     * @return Specifies whether you can retrieve information about and configure individual controls that apply to the
     *         standard. Possible values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>READY_FOR_UPDATES</code> - Controls in the standard can be retrieved and configured.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NOT_READY_FOR_UPDATES</code> - Controls in the standard cannot be retrieved or configured.
     *         </p>
     *         </li>
     * @see StandardsControlsUpdatable
     */
    public final StandardsControlsUpdatable standardsControlsUpdatable() {
        return StandardsControlsUpdatable.fromValue(standardsControlsUpdatable);
    }

    /**
     * <p>
     * Specifies whether you can retrieve information about and configure individual controls that apply to the
     * standard. Possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>READY_FOR_UPDATES</code> - Controls in the standard can be retrieved and configured.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NOT_READY_FOR_UPDATES</code> - Controls in the standard cannot be retrieved or configured.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #standardsControlsUpdatable} will return {@link StandardsControlsUpdatable#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #standardsControlsUpdatableAsString}.
     * </p>
     * 
     * @return Specifies whether you can retrieve information about and configure individual controls that apply to the
     *         standard. Possible values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>READY_FOR_UPDATES</code> - Controls in the standard can be retrieved and configured.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NOT_READY_FOR_UPDATES</code> - Controls in the standard cannot be retrieved or configured.
     *         </p>
     *         </li>
     * @see StandardsControlsUpdatable
     */
    public final String standardsControlsUpdatableAsString() {
        return standardsControlsUpdatable;
    }

    /**
     * <p>
     * The reason for the current status.
     * </p>
     * 
     * @return The reason for the current status.
     */
    public final StandardsStatusReason standardsStatusReason() {
        return standardsStatusReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(standardsSubscriptionArn());
        hashCode = 31 * hashCode + Objects.hashCode(standardsArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasStandardsInput() ? standardsInput() : null);
        hashCode = 31 * hashCode + Objects.hashCode(standardsStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(standardsControlsUpdatableAsString());
        hashCode = 31 * hashCode + Objects.hashCode(standardsStatusReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StandardsSubscription)) {
            return false;
        }
        StandardsSubscription other = (StandardsSubscription) obj;
        return Objects.equals(standardsSubscriptionArn(), other.standardsSubscriptionArn())
                && Objects.equals(standardsArn(), other.standardsArn()) && hasStandardsInput() == other.hasStandardsInput()
                && Objects.equals(standardsInput(), other.standardsInput())
                && Objects.equals(standardsStatusAsString(), other.standardsStatusAsString())
                && Objects.equals(standardsControlsUpdatableAsString(), other.standardsControlsUpdatableAsString())
                && Objects.equals(standardsStatusReason(), other.standardsStatusReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StandardsSubscription").add("StandardsSubscriptionArn", standardsSubscriptionArn())
                .add("StandardsArn", standardsArn()).add("StandardsInput", hasStandardsInput() ? standardsInput() : null)
                .add("StandardsStatus", standardsStatusAsString())
                .add("StandardsControlsUpdatable", standardsControlsUpdatableAsString())
                .add("StandardsStatusReason", standardsStatusReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StandardsSubscriptionArn":
            return Optional.ofNullable(clazz.cast(standardsSubscriptionArn()));
        case "StandardsArn":
            return Optional.ofNullable(clazz.cast(standardsArn()));
        case "StandardsInput":
            return Optional.ofNullable(clazz.cast(standardsInput()));
        case "StandardsStatus":
            return Optional.ofNullable(clazz.cast(standardsStatusAsString()));
        case "StandardsControlsUpdatable":
            return Optional.ofNullable(clazz.cast(standardsControlsUpdatableAsString()));
        case "StandardsStatusReason":
            return Optional.ofNullable(clazz.cast(standardsStatusReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StandardsSubscriptionArn", STANDARDS_SUBSCRIPTION_ARN_FIELD);
        map.put("StandardsArn", STANDARDS_ARN_FIELD);
        map.put("StandardsInput", STANDARDS_INPUT_FIELD);
        map.put("StandardsStatus", STANDARDS_STATUS_FIELD);
        map.put("StandardsControlsUpdatable", STANDARDS_CONTROLS_UPDATABLE_FIELD);
        map.put("StandardsStatusReason", STANDARDS_STATUS_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StandardsSubscription, T> g) {
        return obj -> g.apply((StandardsSubscription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StandardsSubscription> {
        /**
         * <p>
         * The ARN of the resource that represents your subscription to the standard.
         * </p>
         * 
         * @param standardsSubscriptionArn
         *        The ARN of the resource that represents your subscription to the standard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standardsSubscriptionArn(String standardsSubscriptionArn);

        /**
         * <p>
         * The ARN of the standard.
         * </p>
         * 
         * @param standardsArn
         *        The ARN of the standard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standardsArn(String standardsArn);

        /**
         * <p>
         * A key-value pair of input for the standard.
         * </p>
         * 
         * @param standardsInput
         *        A key-value pair of input for the standard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standardsInput(Map<String, String> standardsInput);

        /**
         * <p>
         * The status of your subscription to the standard. Possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PENDING</code> - The standard is in the process of being enabled. Or the standard is already enabled
         * and Security Hub is adding new controls to the standard.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>READY</code> - The standard is enabled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INCOMPLETE</code> - The standard could not be enabled completely. One or more errors (
         * <code>StandardsStatusReason</code>) occurred when Security Hub attempted to enable the standard.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code> - The standard is in the process of being disabled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> - The standard could not be disabled. One or more errors (
         * <code>StandardsStatusReason</code>) occurred when Security Hub attempted to disable the standard.
         * </p>
         * </li>
         * </ul>
         * 
         * @param standardsStatus
         *        The status of your subscription to the standard. Possible values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PENDING</code> - The standard is in the process of being enabled. Or the standard is already
         *        enabled and Security Hub is adding new controls to the standard.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>READY</code> - The standard is enabled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INCOMPLETE</code> - The standard could not be enabled completely. One or more errors (
         *        <code>StandardsStatusReason</code>) occurred when Security Hub attempted to enable the standard.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code> - The standard is in the process of being disabled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> - The standard could not be disabled. One or more errors (
         *        <code>StandardsStatusReason</code>) occurred when Security Hub attempted to disable the standard.
         *        </p>
         *        </li>
         * @see StandardsStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StandardsStatus
         */
        Builder standardsStatus(String standardsStatus);

        /**
         * <p>
         * The status of your subscription to the standard. Possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PENDING</code> - The standard is in the process of being enabled. Or the standard is already enabled
         * and Security Hub is adding new controls to the standard.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>READY</code> - The standard is enabled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INCOMPLETE</code> - The standard could not be enabled completely. One or more errors (
         * <code>StandardsStatusReason</code>) occurred when Security Hub attempted to enable the standard.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code> - The standard is in the process of being disabled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> - The standard could not be disabled. One or more errors (
         * <code>StandardsStatusReason</code>) occurred when Security Hub attempted to disable the standard.
         * </p>
         * </li>
         * </ul>
         * 
         * @param standardsStatus
         *        The status of your subscription to the standard. Possible values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PENDING</code> - The standard is in the process of being enabled. Or the standard is already
         *        enabled and Security Hub is adding new controls to the standard.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>READY</code> - The standard is enabled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INCOMPLETE</code> - The standard could not be enabled completely. One or more errors (
         *        <code>StandardsStatusReason</code>) occurred when Security Hub attempted to enable the standard.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code> - The standard is in the process of being disabled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> - The standard could not be disabled. One or more errors (
         *        <code>StandardsStatusReason</code>) occurred when Security Hub attempted to disable the standard.
         *        </p>
         *        </li>
         * @see StandardsStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StandardsStatus
         */
        Builder standardsStatus(StandardsStatus standardsStatus);

        /**
         * <p>
         * Specifies whether you can retrieve information about and configure individual controls that apply to the
         * standard. Possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>READY_FOR_UPDATES</code> - Controls in the standard can be retrieved and configured.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NOT_READY_FOR_UPDATES</code> - Controls in the standard cannot be retrieved or configured.
         * </p>
         * </li>
         * </ul>
         * 
         * @param standardsControlsUpdatable
         *        Specifies whether you can retrieve information about and configure individual controls that apply to
         *        the standard. Possible values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>READY_FOR_UPDATES</code> - Controls in the standard can be retrieved and configured.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NOT_READY_FOR_UPDATES</code> - Controls in the standard cannot be retrieved or configured.
         *        </p>
         *        </li>
         * @see StandardsControlsUpdatable
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StandardsControlsUpdatable
         */
        Builder standardsControlsUpdatable(String standardsControlsUpdatable);

        /**
         * <p>
         * Specifies whether you can retrieve information about and configure individual controls that apply to the
         * standard. Possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>READY_FOR_UPDATES</code> - Controls in the standard can be retrieved and configured.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NOT_READY_FOR_UPDATES</code> - Controls in the standard cannot be retrieved or configured.
         * </p>
         * </li>
         * </ul>
         * 
         * @param standardsControlsUpdatable
         *        Specifies whether you can retrieve information about and configure individual controls that apply to
         *        the standard. Possible values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>READY_FOR_UPDATES</code> - Controls in the standard can be retrieved and configured.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NOT_READY_FOR_UPDATES</code> - Controls in the standard cannot be retrieved or configured.
         *        </p>
         *        </li>
         * @see StandardsControlsUpdatable
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StandardsControlsUpdatable
         */
        Builder standardsControlsUpdatable(StandardsControlsUpdatable standardsControlsUpdatable);

        /**
         * <p>
         * The reason for the current status.
         * </p>
         * 
         * @param standardsStatusReason
         *        The reason for the current status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standardsStatusReason(StandardsStatusReason standardsStatusReason);

        /**
         * <p>
         * The reason for the current status.
         * </p>
         * This is a convenience method that creates an instance of the {@link StandardsStatusReason.Builder} avoiding
         * the need to create one manually via {@link StandardsStatusReason#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StandardsStatusReason.Builder#build()} is called immediately and
         * its result is passed to {@link #standardsStatusReason(StandardsStatusReason)}.
         * 
         * @param standardsStatusReason
         *        a consumer that will call methods on {@link StandardsStatusReason.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #standardsStatusReason(StandardsStatusReason)
         */
        default Builder standardsStatusReason(Consumer<StandardsStatusReason.Builder> standardsStatusReason) {
            return standardsStatusReason(StandardsStatusReason.builder().applyMutation(standardsStatusReason).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String standardsSubscriptionArn;

        private String standardsArn;

        private Map<String, String> standardsInput = DefaultSdkAutoConstructMap.getInstance();

        private String standardsStatus;

        private String standardsControlsUpdatable;

        private StandardsStatusReason standardsStatusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(StandardsSubscription model) {
            standardsSubscriptionArn(model.standardsSubscriptionArn);
            standardsArn(model.standardsArn);
            standardsInput(model.standardsInput);
            standardsStatus(model.standardsStatus);
            standardsControlsUpdatable(model.standardsControlsUpdatable);
            standardsStatusReason(model.standardsStatusReason);
        }

        public final String getStandardsSubscriptionArn() {
            return standardsSubscriptionArn;
        }

        public final void setStandardsSubscriptionArn(String standardsSubscriptionArn) {
            this.standardsSubscriptionArn = standardsSubscriptionArn;
        }

        @Override
        public final Builder standardsSubscriptionArn(String standardsSubscriptionArn) {
            this.standardsSubscriptionArn = standardsSubscriptionArn;
            return this;
        }

        public final String getStandardsArn() {
            return standardsArn;
        }

        public final void setStandardsArn(String standardsArn) {
            this.standardsArn = standardsArn;
        }

        @Override
        public final Builder standardsArn(String standardsArn) {
            this.standardsArn = standardsArn;
            return this;
        }

        public final Map<String, String> getStandardsInput() {
            if (standardsInput instanceof SdkAutoConstructMap) {
                return null;
            }
            return standardsInput;
        }

        public final void setStandardsInput(Map<String, String> standardsInput) {
            this.standardsInput = StandardsInputParameterMapCopier.copy(standardsInput);
        }

        @Override
        public final Builder standardsInput(Map<String, String> standardsInput) {
            this.standardsInput = StandardsInputParameterMapCopier.copy(standardsInput);
            return this;
        }

        public final String getStandardsStatus() {
            return standardsStatus;
        }

        public final void setStandardsStatus(String standardsStatus) {
            this.standardsStatus = standardsStatus;
        }

        @Override
        public final Builder standardsStatus(String standardsStatus) {
            this.standardsStatus = standardsStatus;
            return this;
        }

        @Override
        public final Builder standardsStatus(StandardsStatus standardsStatus) {
            this.standardsStatus(standardsStatus == null ? null : standardsStatus.toString());
            return this;
        }

        public final String getStandardsControlsUpdatable() {
            return standardsControlsUpdatable;
        }

        public final void setStandardsControlsUpdatable(String standardsControlsUpdatable) {
            this.standardsControlsUpdatable = standardsControlsUpdatable;
        }

        @Override
        public final Builder standardsControlsUpdatable(String standardsControlsUpdatable) {
            this.standardsControlsUpdatable = standardsControlsUpdatable;
            return this;
        }

        @Override
        public final Builder standardsControlsUpdatable(StandardsControlsUpdatable standardsControlsUpdatable) {
            this.standardsControlsUpdatable(standardsControlsUpdatable == null ? null : standardsControlsUpdatable.toString());
            return this;
        }

        public final StandardsStatusReason.Builder getStandardsStatusReason() {
            return standardsStatusReason != null ? standardsStatusReason.toBuilder() : null;
        }

        public final void setStandardsStatusReason(StandardsStatusReason.BuilderImpl standardsStatusReason) {
            this.standardsStatusReason = standardsStatusReason != null ? standardsStatusReason.build() : null;
        }

        @Override
        public final Builder standardsStatusReason(StandardsStatusReason standardsStatusReason) {
            this.standardsStatusReason = standardsStatusReason;
            return this;
        }

        @Override
        public StandardsSubscription build() {
            return new StandardsSubscription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
