/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a software package.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SoftwarePackage implements SdkPojo, Serializable, ToCopyableBuilder<SoftwarePackage.Builder, SoftwarePackage> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(SoftwarePackage::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Version")
            .getter(getter(SoftwarePackage::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final SdkField<String> EPOCH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Epoch")
            .getter(getter(SoftwarePackage::epoch)).setter(setter(Builder::epoch))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Epoch").build()).build();

    private static final SdkField<String> RELEASE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Release")
            .getter(getter(SoftwarePackage::release)).setter(setter(Builder::release))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Release").build()).build();

    private static final SdkField<String> ARCHITECTURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Architecture").getter(getter(SoftwarePackage::architecture)).setter(setter(Builder::architecture))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Architecture").build()).build();

    private static final SdkField<String> PACKAGE_MANAGER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackageManager").getter(getter(SoftwarePackage::packageManager)).setter(setter(Builder::packageManager))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageManager").build()).build();

    private static final SdkField<String> FILE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FilePath").getter(getter(SoftwarePackage::filePath)).setter(setter(Builder::filePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilePath").build()).build();

    private static final SdkField<String> FIXED_IN_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FixedInVersion").getter(getter(SoftwarePackage::fixedInVersion)).setter(setter(Builder::fixedInVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FixedInVersion").build()).build();

    private static final SdkField<String> REMEDIATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Remediation").getter(getter(SoftwarePackage::remediation)).setter(setter(Builder::remediation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Remediation").build()).build();

    private static final SdkField<String> SOURCE_LAYER_HASH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceLayerHash").getter(getter(SoftwarePackage::sourceLayerHash))
            .setter(setter(Builder::sourceLayerHash))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceLayerHash").build()).build();

    private static final SdkField<String> SOURCE_LAYER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceLayerArn").getter(getter(SoftwarePackage::sourceLayerArn)).setter(setter(Builder::sourceLayerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceLayerArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VERSION_FIELD,
            EPOCH_FIELD, RELEASE_FIELD, ARCHITECTURE_FIELD, PACKAGE_MANAGER_FIELD, FILE_PATH_FIELD, FIXED_IN_VERSION_FIELD,
            REMEDIATION_FIELD, SOURCE_LAYER_HASH_FIELD, SOURCE_LAYER_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String version;

    private final String epoch;

    private final String release;

    private final String architecture;

    private final String packageManager;

    private final String filePath;

    private final String fixedInVersion;

    private final String remediation;

    private final String sourceLayerHash;

    private final String sourceLayerArn;

    private SoftwarePackage(BuilderImpl builder) {
        this.name = builder.name;
        this.version = builder.version;
        this.epoch = builder.epoch;
        this.release = builder.release;
        this.architecture = builder.architecture;
        this.packageManager = builder.packageManager;
        this.filePath = builder.filePath;
        this.fixedInVersion = builder.fixedInVersion;
        this.remediation = builder.remediation;
        this.sourceLayerHash = builder.sourceLayerHash;
        this.sourceLayerArn = builder.sourceLayerArn;
    }

    /**
     * <p>
     * The name of the software package.
     * </p>
     * 
     * @return The name of the software package.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The version of the software package.
     * </p>
     * 
     * @return The version of the software package.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * The epoch of the software package.
     * </p>
     * 
     * @return The epoch of the software package.
     */
    public final String epoch() {
        return epoch;
    }

    /**
     * <p>
     * The release of the software package.
     * </p>
     * 
     * @return The release of the software package.
     */
    public final String release() {
        return release;
    }

    /**
     * <p>
     * The architecture used for the software package.
     * </p>
     * 
     * @return The architecture used for the software package.
     */
    public final String architecture() {
        return architecture;
    }

    /**
     * <p>
     * The source of the package.
     * </p>
     * 
     * @return The source of the package.
     */
    public final String packageManager() {
        return packageManager;
    }

    /**
     * <p>
     * The file system path to the package manager inventory file.
     * </p>
     * 
     * @return The file system path to the package manager inventory file.
     */
    public final String filePath() {
        return filePath;
    }

    /**
     * <p>
     * The version of the software package in which the vulnerability has been resolved.
     * </p>
     * 
     * @return The version of the software package in which the vulnerability has been resolved.
     */
    public final String fixedInVersion() {
        return fixedInVersion;
    }

    /**
     * <p>
     * Describes the actions a customer can take to resolve the vulnerability in the software package.
     * </p>
     * 
     * @return Describes the actions a customer can take to resolve the vulnerability in the software package.
     */
    public final String remediation() {
        return remediation;
    }

    /**
     * <p>
     * The source layer hash of the vulnerable package.
     * </p>
     * 
     * @return The source layer hash of the vulnerable package.
     */
    public final String sourceLayerHash() {
        return sourceLayerHash;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the source layer.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the source layer.
     */
    public final String sourceLayerArn() {
        return sourceLayerArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(epoch());
        hashCode = 31 * hashCode + Objects.hashCode(release());
        hashCode = 31 * hashCode + Objects.hashCode(architecture());
        hashCode = 31 * hashCode + Objects.hashCode(packageManager());
        hashCode = 31 * hashCode + Objects.hashCode(filePath());
        hashCode = 31 * hashCode + Objects.hashCode(fixedInVersion());
        hashCode = 31 * hashCode + Objects.hashCode(remediation());
        hashCode = 31 * hashCode + Objects.hashCode(sourceLayerHash());
        hashCode = 31 * hashCode + Objects.hashCode(sourceLayerArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SoftwarePackage)) {
            return false;
        }
        SoftwarePackage other = (SoftwarePackage) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(version(), other.version())
                && Objects.equals(epoch(), other.epoch()) && Objects.equals(release(), other.release())
                && Objects.equals(architecture(), other.architecture())
                && Objects.equals(packageManager(), other.packageManager()) && Objects.equals(filePath(), other.filePath())
                && Objects.equals(fixedInVersion(), other.fixedInVersion()) && Objects.equals(remediation(), other.remediation())
                && Objects.equals(sourceLayerHash(), other.sourceLayerHash())
                && Objects.equals(sourceLayerArn(), other.sourceLayerArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SoftwarePackage").add("Name", name()).add("Version", version()).add("Epoch", epoch())
                .add("Release", release()).add("Architecture", architecture()).add("PackageManager", packageManager())
                .add("FilePath", filePath()).add("FixedInVersion", fixedInVersion()).add("Remediation", remediation())
                .add("SourceLayerHash", sourceLayerHash()).add("SourceLayerArn", sourceLayerArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        case "Epoch":
            return Optional.ofNullable(clazz.cast(epoch()));
        case "Release":
            return Optional.ofNullable(clazz.cast(release()));
        case "Architecture":
            return Optional.ofNullable(clazz.cast(architecture()));
        case "PackageManager":
            return Optional.ofNullable(clazz.cast(packageManager()));
        case "FilePath":
            return Optional.ofNullable(clazz.cast(filePath()));
        case "FixedInVersion":
            return Optional.ofNullable(clazz.cast(fixedInVersion()));
        case "Remediation":
            return Optional.ofNullable(clazz.cast(remediation()));
        case "SourceLayerHash":
            return Optional.ofNullable(clazz.cast(sourceLayerHash()));
        case "SourceLayerArn":
            return Optional.ofNullable(clazz.cast(sourceLayerArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Version", VERSION_FIELD);
        map.put("Epoch", EPOCH_FIELD);
        map.put("Release", RELEASE_FIELD);
        map.put("Architecture", ARCHITECTURE_FIELD);
        map.put("PackageManager", PACKAGE_MANAGER_FIELD);
        map.put("FilePath", FILE_PATH_FIELD);
        map.put("FixedInVersion", FIXED_IN_VERSION_FIELD);
        map.put("Remediation", REMEDIATION_FIELD);
        map.put("SourceLayerHash", SOURCE_LAYER_HASH_FIELD);
        map.put("SourceLayerArn", SOURCE_LAYER_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SoftwarePackage, T> g) {
        return obj -> g.apply((SoftwarePackage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SoftwarePackage> {
        /**
         * <p>
         * The name of the software package.
         * </p>
         * 
         * @param name
         *        The name of the software package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The version of the software package.
         * </p>
         * 
         * @param version
         *        The version of the software package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The epoch of the software package.
         * </p>
         * 
         * @param epoch
         *        The epoch of the software package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder epoch(String epoch);

        /**
         * <p>
         * The release of the software package.
         * </p>
         * 
         * @param release
         *        The release of the software package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder release(String release);

        /**
         * <p>
         * The architecture used for the software package.
         * </p>
         * 
         * @param architecture
         *        The architecture used for the software package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder architecture(String architecture);

        /**
         * <p>
         * The source of the package.
         * </p>
         * 
         * @param packageManager
         *        The source of the package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageManager(String packageManager);

        /**
         * <p>
         * The file system path to the package manager inventory file.
         * </p>
         * 
         * @param filePath
         *        The file system path to the package manager inventory file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filePath(String filePath);

        /**
         * <p>
         * The version of the software package in which the vulnerability has been resolved.
         * </p>
         * 
         * @param fixedInVersion
         *        The version of the software package in which the vulnerability has been resolved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fixedInVersion(String fixedInVersion);

        /**
         * <p>
         * Describes the actions a customer can take to resolve the vulnerability in the software package.
         * </p>
         * 
         * @param remediation
         *        Describes the actions a customer can take to resolve the vulnerability in the software package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remediation(String remediation);

        /**
         * <p>
         * The source layer hash of the vulnerable package.
         * </p>
         * 
         * @param sourceLayerHash
         *        The source layer hash of the vulnerable package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceLayerHash(String sourceLayerHash);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the source layer.
         * </p>
         * 
         * @param sourceLayerArn
         *        The Amazon Resource Name (ARN) of the source layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceLayerArn(String sourceLayerArn);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String version;

        private String epoch;

        private String release;

        private String architecture;

        private String packageManager;

        private String filePath;

        private String fixedInVersion;

        private String remediation;

        private String sourceLayerHash;

        private String sourceLayerArn;

        private BuilderImpl() {
        }

        private BuilderImpl(SoftwarePackage model) {
            name(model.name);
            version(model.version);
            epoch(model.epoch);
            release(model.release);
            architecture(model.architecture);
            packageManager(model.packageManager);
            filePath(model.filePath);
            fixedInVersion(model.fixedInVersion);
            remediation(model.remediation);
            sourceLayerHash(model.sourceLayerHash);
            sourceLayerArn(model.sourceLayerArn);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getEpoch() {
            return epoch;
        }

        public final void setEpoch(String epoch) {
            this.epoch = epoch;
        }

        @Override
        public final Builder epoch(String epoch) {
            this.epoch = epoch;
            return this;
        }

        public final String getRelease() {
            return release;
        }

        public final void setRelease(String release) {
            this.release = release;
        }

        @Override
        public final Builder release(String release) {
            this.release = release;
            return this;
        }

        public final String getArchitecture() {
            return architecture;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        public final String getPackageManager() {
            return packageManager;
        }

        public final void setPackageManager(String packageManager) {
            this.packageManager = packageManager;
        }

        @Override
        public final Builder packageManager(String packageManager) {
            this.packageManager = packageManager;
            return this;
        }

        public final String getFilePath() {
            return filePath;
        }

        public final void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        @Override
        public final Builder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public final String getFixedInVersion() {
            return fixedInVersion;
        }

        public final void setFixedInVersion(String fixedInVersion) {
            this.fixedInVersion = fixedInVersion;
        }

        @Override
        public final Builder fixedInVersion(String fixedInVersion) {
            this.fixedInVersion = fixedInVersion;
            return this;
        }

        public final String getRemediation() {
            return remediation;
        }

        public final void setRemediation(String remediation) {
            this.remediation = remediation;
        }

        @Override
        public final Builder remediation(String remediation) {
            this.remediation = remediation;
            return this;
        }

        public final String getSourceLayerHash() {
            return sourceLayerHash;
        }

        public final void setSourceLayerHash(String sourceLayerHash) {
            this.sourceLayerHash = sourceLayerHash;
        }

        @Override
        public final Builder sourceLayerHash(String sourceLayerHash) {
            this.sourceLayerHash = sourceLayerHash;
            return this;
        }

        public final String getSourceLayerArn() {
            return sourceLayerArn;
        }

        public final void setSourceLayerArn(String sourceLayerArn) {
            this.sourceLayerArn = sourceLayerArn;
        }

        @Override
        public final Builder sourceLayerArn(String sourceLayerArn) {
            this.sourceLayerArn = sourceLayerArn;
            return this;
        }

        @Override
        public SoftwarePackage build() {
            return new SoftwarePackage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
