/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains counts of findings grouped by severity level for trend analysis.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SeverityTrendsCount implements SdkPojo, Serializable,
        ToCopyableBuilder<SeverityTrendsCount.Builder, SeverityTrendsCount> {
    private static final SdkField<Long> UNKNOWN_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Unknown")
            .getter(getter(SeverityTrendsCount::unknown)).setter(setter(Builder::unknown))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unknown").build()).build();

    private static final SdkField<Long> INFORMATIONAL_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("Informational").getter(getter(SeverityTrendsCount::informational))
            .setter(setter(Builder::informational))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Informational").build()).build();

    private static final SdkField<Long> LOW_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Low")
            .getter(getter(SeverityTrendsCount::low)).setter(setter(Builder::low))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Low").build()).build();

    private static final SdkField<Long> MEDIUM_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Medium")
            .getter(getter(SeverityTrendsCount::medium)).setter(setter(Builder::medium))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Medium").build()).build();

    private static final SdkField<Long> HIGH_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("High")
            .getter(getter(SeverityTrendsCount::high)).setter(setter(Builder::high))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("High").build()).build();

    private static final SdkField<Long> CRITICAL_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Critical")
            .getter(getter(SeverityTrendsCount::critical)).setter(setter(Builder::critical))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Critical").build()).build();

    private static final SdkField<Long> FATAL_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Fatal")
            .getter(getter(SeverityTrendsCount::fatal)).setter(setter(Builder::fatal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fatal").build()).build();

    private static final SdkField<Long> OTHER_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Other")
            .getter(getter(SeverityTrendsCount::other)).setter(setter(Builder::other))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Other").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNKNOWN_FIELD,
            INFORMATIONAL_FIELD, LOW_FIELD, MEDIUM_FIELD, HIGH_FIELD, CRITICAL_FIELD, FATAL_FIELD, OTHER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long unknown;

    private final Long informational;

    private final Long low;

    private final Long medium;

    private final Long high;

    private final Long critical;

    private final Long fatal;

    private final Long other;

    private SeverityTrendsCount(BuilderImpl builder) {
        this.unknown = builder.unknown;
        this.informational = builder.informational;
        this.low = builder.low;
        this.medium = builder.medium;
        this.high = builder.high;
        this.critical = builder.critical;
        this.fatal = builder.fatal;
        this.other = builder.other;
    }

    /**
     * <p>
     * The count of findings with Unknown severity level at this point in the trend timeline.
     * </p>
     * 
     * @return The count of findings with Unknown severity level at this point in the trend timeline.
     */
    public final Long unknown() {
        return unknown;
    }

    /**
     * <p>
     * The count of findings with Informational severity level at this point in the trend timeline.
     * </p>
     * 
     * @return The count of findings with Informational severity level at this point in the trend timeline.
     */
    public final Long informational() {
        return informational;
    }

    /**
     * <p>
     * The count of findings with Low severity level at this point in the trend timeline.
     * </p>
     * 
     * @return The count of findings with Low severity level at this point in the trend timeline.
     */
    public final Long low() {
        return low;
    }

    /**
     * <p>
     * The count of findings with Medium severity level at this point in the trend timeline.
     * </p>
     * 
     * @return The count of findings with Medium severity level at this point in the trend timeline.
     */
    public final Long medium() {
        return medium;
    }

    /**
     * <p>
     * The count of findings with High severity level at this point in the trend timeline.
     * </p>
     * 
     * @return The count of findings with High severity level at this point in the trend timeline.
     */
    public final Long high() {
        return high;
    }

    /**
     * <p>
     * The count of findings with Critical severity level at this point in the trend timeline.
     * </p>
     * 
     * @return The count of findings with Critical severity level at this point in the trend timeline.
     */
    public final Long critical() {
        return critical;
    }

    /**
     * <p>
     * The count of findings with Fatal severity level at this point in the trend timeline.
     * </p>
     * 
     * @return The count of findings with Fatal severity level at this point in the trend timeline.
     */
    public final Long fatal() {
        return fatal;
    }

    /**
     * <p>
     * The count of findings with severity levels not fitting into the standard categories at this point in the trend
     * timeline.
     * </p>
     * 
     * @return The count of findings with severity levels not fitting into the standard categories at this point in the
     *         trend timeline.
     */
    public final Long other() {
        return other;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(unknown());
        hashCode = 31 * hashCode + Objects.hashCode(informational());
        hashCode = 31 * hashCode + Objects.hashCode(low());
        hashCode = 31 * hashCode + Objects.hashCode(medium());
        hashCode = 31 * hashCode + Objects.hashCode(high());
        hashCode = 31 * hashCode + Objects.hashCode(critical());
        hashCode = 31 * hashCode + Objects.hashCode(fatal());
        hashCode = 31 * hashCode + Objects.hashCode(other());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SeverityTrendsCount)) {
            return false;
        }
        SeverityTrendsCount other = (SeverityTrendsCount) obj;
        return Objects.equals(unknown(), other.unknown()) && Objects.equals(informational(), other.informational())
                && Objects.equals(low(), other.low()) && Objects.equals(medium(), other.medium())
                && Objects.equals(high(), other.high()) && Objects.equals(critical(), other.critical())
                && Objects.equals(fatal(), other.fatal()) && Objects.equals(other(), other.other());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SeverityTrendsCount").add("Unknown", unknown()).add("Informational", informational())
                .add("Low", low()).add("Medium", medium()).add("High", high()).add("Critical", critical()).add("Fatal", fatal())
                .add("Other", other()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Unknown":
            return Optional.ofNullable(clazz.cast(unknown()));
        case "Informational":
            return Optional.ofNullable(clazz.cast(informational()));
        case "Low":
            return Optional.ofNullable(clazz.cast(low()));
        case "Medium":
            return Optional.ofNullable(clazz.cast(medium()));
        case "High":
            return Optional.ofNullable(clazz.cast(high()));
        case "Critical":
            return Optional.ofNullable(clazz.cast(critical()));
        case "Fatal":
            return Optional.ofNullable(clazz.cast(fatal()));
        case "Other":
            return Optional.ofNullable(clazz.cast(other()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Unknown", UNKNOWN_FIELD);
        map.put("Informational", INFORMATIONAL_FIELD);
        map.put("Low", LOW_FIELD);
        map.put("Medium", MEDIUM_FIELD);
        map.put("High", HIGH_FIELD);
        map.put("Critical", CRITICAL_FIELD);
        map.put("Fatal", FATAL_FIELD);
        map.put("Other", OTHER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SeverityTrendsCount, T> g) {
        return obj -> g.apply((SeverityTrendsCount) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SeverityTrendsCount> {
        /**
         * <p>
         * The count of findings with Unknown severity level at this point in the trend timeline.
         * </p>
         * 
         * @param unknown
         *        The count of findings with Unknown severity level at this point in the trend timeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unknown(Long unknown);

        /**
         * <p>
         * The count of findings with Informational severity level at this point in the trend timeline.
         * </p>
         * 
         * @param informational
         *        The count of findings with Informational severity level at this point in the trend timeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder informational(Long informational);

        /**
         * <p>
         * The count of findings with Low severity level at this point in the trend timeline.
         * </p>
         * 
         * @param low
         *        The count of findings with Low severity level at this point in the trend timeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder low(Long low);

        /**
         * <p>
         * The count of findings with Medium severity level at this point in the trend timeline.
         * </p>
         * 
         * @param medium
         *        The count of findings with Medium severity level at this point in the trend timeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder medium(Long medium);

        /**
         * <p>
         * The count of findings with High severity level at this point in the trend timeline.
         * </p>
         * 
         * @param high
         *        The count of findings with High severity level at this point in the trend timeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder high(Long high);

        /**
         * <p>
         * The count of findings with Critical severity level at this point in the trend timeline.
         * </p>
         * 
         * @param critical
         *        The count of findings with Critical severity level at this point in the trend timeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder critical(Long critical);

        /**
         * <p>
         * The count of findings with Fatal severity level at this point in the trend timeline.
         * </p>
         * 
         * @param fatal
         *        The count of findings with Fatal severity level at this point in the trend timeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fatal(Long fatal);

        /**
         * <p>
         * The count of findings with severity levels not fitting into the standard categories at this point in the
         * trend timeline.
         * </p>
         * 
         * @param other
         *        The count of findings with severity levels not fitting into the standard categories at this point in
         *        the trend timeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder other(Long other);
    }

    static final class BuilderImpl implements Builder {
        private Long unknown;

        private Long informational;

        private Long low;

        private Long medium;

        private Long high;

        private Long critical;

        private Long fatal;

        private Long other;

        private BuilderImpl() {
        }

        private BuilderImpl(SeverityTrendsCount model) {
            unknown(model.unknown);
            informational(model.informational);
            low(model.low);
            medium(model.medium);
            high(model.high);
            critical(model.critical);
            fatal(model.fatal);
            other(model.other);
        }

        public final Long getUnknown() {
            return unknown;
        }

        public final void setUnknown(Long unknown) {
            this.unknown = unknown;
        }

        @Override
        public final Builder unknown(Long unknown) {
            this.unknown = unknown;
            return this;
        }

        public final Long getInformational() {
            return informational;
        }

        public final void setInformational(Long informational) {
            this.informational = informational;
        }

        @Override
        public final Builder informational(Long informational) {
            this.informational = informational;
            return this;
        }

        public final Long getLow() {
            return low;
        }

        public final void setLow(Long low) {
            this.low = low;
        }

        @Override
        public final Builder low(Long low) {
            this.low = low;
            return this;
        }

        public final Long getMedium() {
            return medium;
        }

        public final void setMedium(Long medium) {
            this.medium = medium;
        }

        @Override
        public final Builder medium(Long medium) {
            this.medium = medium;
            return this;
        }

        public final Long getHigh() {
            return high;
        }

        public final void setHigh(Long high) {
            this.high = high;
        }

        @Override
        public final Builder high(Long high) {
            this.high = high;
            return this;
        }

        public final Long getCritical() {
            return critical;
        }

        public final void setCritical(Long critical) {
            this.critical = critical;
        }

        @Override
        public final Builder critical(Long critical) {
            this.critical = critical;
            return this;
        }

        public final Long getFatal() {
            return fatal;
        }

        public final void setFatal(Long fatal) {
            this.fatal = fatal;
        }

        @Override
        public final Builder fatal(Long fatal) {
            this.fatal = fatal;
            return this;
        }

        public final Long getOther() {
            return other;
        }

        public final void setOther(Long other) {
            this.other = other;
        }

        @Override
        public final Builder other(Long other) {
            this.other = other;
            return this;
        }

        @Override
        public SeverityTrendsCount build() {
            return new SeverityTrendsCount(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
