/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A set of TCP flags and masks to inspect for.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleGroupSourceStatelessRuleMatchAttributesTcpFlags
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<RuleGroupSourceStatelessRuleMatchAttributesTcpFlags.Builder, RuleGroupSourceStatelessRuleMatchAttributesTcpFlags> {
    private static final SdkField<List<String>> FLAGS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Flags")
            .getter(getter(RuleGroupSourceStatelessRuleMatchAttributesTcpFlags::flags))
            .setter(setter(Builder::flags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Flags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> MASKS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Masks")
            .getter(getter(RuleGroupSourceStatelessRuleMatchAttributesTcpFlags::masks))
            .setter(setter(Builder::masks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Masks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLAGS_FIELD, MASKS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> flags;

    private final List<String> masks;

    private RuleGroupSourceStatelessRuleMatchAttributesTcpFlags(BuilderImpl builder) {
        this.flags = builder.flags;
        this.masks = builder.masks;
    }

    /**
     * For responses, this returns true if the service returned a value for the Flags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasFlags() {
        return flags != null && !(flags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Defines the flags from the <code>Masks</code> setting that must be set in order for the packet to match. Flags
     * that are listed must be set. Flags that are not listed must not be set.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFlags} method.
     * </p>
     * 
     * @return Defines the flags from the <code>Masks</code> setting that must be set in order for the packet to match.
     *         Flags that are listed must be set. Flags that are not listed must not be set.
     */
    public final List<String> flags() {
        return flags;
    }

    /**
     * For responses, this returns true if the service returned a value for the Masks property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasMasks() {
        return masks != null && !(masks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The set of flags to consider in the inspection. If not specified, then all flags are inspected.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMasks} method.
     * </p>
     * 
     * @return The set of flags to consider in the inspection. If not specified, then all flags are inspected.
     */
    public final List<String> masks() {
        return masks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasFlags() ? flags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMasks() ? masks() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleGroupSourceStatelessRuleMatchAttributesTcpFlags)) {
            return false;
        }
        RuleGroupSourceStatelessRuleMatchAttributesTcpFlags other = (RuleGroupSourceStatelessRuleMatchAttributesTcpFlags) obj;
        return hasFlags() == other.hasFlags() && Objects.equals(flags(), other.flags()) && hasMasks() == other.hasMasks()
                && Objects.equals(masks(), other.masks());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleGroupSourceStatelessRuleMatchAttributesTcpFlags").add("Flags", hasFlags() ? flags() : null)
                .add("Masks", hasMasks() ? masks() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Flags":
            return Optional.ofNullable(clazz.cast(flags()));
        case "Masks":
            return Optional.ofNullable(clazz.cast(masks()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Flags", FLAGS_FIELD);
        map.put("Masks", MASKS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuleGroupSourceStatelessRuleMatchAttributesTcpFlags, T> g) {
        return obj -> g.apply((RuleGroupSourceStatelessRuleMatchAttributesTcpFlags) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleGroupSourceStatelessRuleMatchAttributesTcpFlags> {
        /**
         * <p>
         * Defines the flags from the <code>Masks</code> setting that must be set in order for the packet to match.
         * Flags that are listed must be set. Flags that are not listed must not be set.
         * </p>
         * 
         * @param flags
         *        Defines the flags from the <code>Masks</code> setting that must be set in order for the packet to
         *        match. Flags that are listed must be set. Flags that are not listed must not be set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flags(Collection<String> flags);

        /**
         * <p>
         * Defines the flags from the <code>Masks</code> setting that must be set in order for the packet to match.
         * Flags that are listed must be set. Flags that are not listed must not be set.
         * </p>
         * 
         * @param flags
         *        Defines the flags from the <code>Masks</code> setting that must be set in order for the packet to
         *        match. Flags that are listed must be set. Flags that are not listed must not be set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flags(String... flags);

        /**
         * <p>
         * The set of flags to consider in the inspection. If not specified, then all flags are inspected.
         * </p>
         * 
         * @param masks
         *        The set of flags to consider in the inspection. If not specified, then all flags are inspected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masks(Collection<String> masks);

        /**
         * <p>
         * The set of flags to consider in the inspection. If not specified, then all flags are inspected.
         * </p>
         * 
         * @param masks
         *        The set of flags to consider in the inspection. If not specified, then all flags are inspected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masks(String... masks);
    }

    static final class BuilderImpl implements Builder {
        private List<String> flags = DefaultSdkAutoConstructList.getInstance();

        private List<String> masks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RuleGroupSourceStatelessRuleMatchAttributesTcpFlags model) {
            flags(model.flags);
            masks(model.masks);
        }

        public final Collection<String> getFlags() {
            if (flags instanceof SdkAutoConstructList) {
                return null;
            }
            return flags;
        }

        public final void setFlags(Collection<String> flags) {
            this.flags = NonEmptyStringListCopier.copy(flags);
        }

        @Override
        public final Builder flags(Collection<String> flags) {
            this.flags = NonEmptyStringListCopier.copy(flags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flags(String... flags) {
            flags(Arrays.asList(flags));
            return this;
        }

        public final Collection<String> getMasks() {
            if (masks instanceof SdkAutoConstructList) {
                return null;
            }
            return masks;
        }

        public final void setMasks(Collection<String> masks) {
            this.masks = NonEmptyStringListCopier.copy(masks);
        }

        @Override
        public final Builder masks(Collection<String> masks) {
            this.masks = NonEmptyStringListCopier.copy(masks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder masks(String... masks) {
            masks(Arrays.asList(masks));
            return this;
        }

        @Override
        public RuleGroupSourceStatelessRuleMatchAttributesTcpFlags build() {
            return new RuleGroupSourceStatelessRuleMatchAttributesTcpFlags(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
