/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The definition of the stateless rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleGroupSourceStatelessRuleDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<RuleGroupSourceStatelessRuleDefinition.Builder, RuleGroupSourceStatelessRuleDefinition> {
    private static final SdkField<List<String>> ACTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Actions")
            .getter(getter(RuleGroupSourceStatelessRuleDefinition::actions))
            .setter(setter(Builder::actions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<RuleGroupSourceStatelessRuleMatchAttributes> MATCH_ATTRIBUTES_FIELD = SdkField
            .<RuleGroupSourceStatelessRuleMatchAttributes> builder(MarshallingType.SDK_POJO).memberName("MatchAttributes")
            .getter(getter(RuleGroupSourceStatelessRuleDefinition::matchAttributes)).setter(setter(Builder::matchAttributes))
            .constructor(RuleGroupSourceStatelessRuleMatchAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchAttributes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIONS_FIELD,
            MATCH_ATTRIBUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> actions;

    private final RuleGroupSourceStatelessRuleMatchAttributes matchAttributes;

    private RuleGroupSourceStatelessRuleDefinition(BuilderImpl builder) {
        this.actions = builder.actions;
        this.matchAttributes = builder.matchAttributes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Actions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasActions() {
        return actions != null && !(actions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The actions to take on a packet that matches one of the stateless rule definition's match attributes. You must
     * specify a standard action (<code>aws:pass</code>, <code>aws:drop</code>, or <code>aws:forward_to_sfe</code>). You
     * can then add custom actions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActions} method.
     * </p>
     * 
     * @return The actions to take on a packet that matches one of the stateless rule definition's match attributes. You
     *         must specify a standard action (<code>aws:pass</code>, <code>aws:drop</code>, or
     *         <code>aws:forward_to_sfe</code>). You can then add custom actions.
     */
    public final List<String> actions() {
        return actions;
    }

    /**
     * <p>
     * The criteria for Network Firewall to use to inspect an individual packet in a stateless rule inspection.
     * </p>
     * 
     * @return The criteria for Network Firewall to use to inspect an individual packet in a stateless rule inspection.
     */
    public final RuleGroupSourceStatelessRuleMatchAttributes matchAttributes() {
        return matchAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasActions() ? actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(matchAttributes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleGroupSourceStatelessRuleDefinition)) {
            return false;
        }
        RuleGroupSourceStatelessRuleDefinition other = (RuleGroupSourceStatelessRuleDefinition) obj;
        return hasActions() == other.hasActions() && Objects.equals(actions(), other.actions())
                && Objects.equals(matchAttributes(), other.matchAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleGroupSourceStatelessRuleDefinition").add("Actions", hasActions() ? actions() : null)
                .add("MatchAttributes", matchAttributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Actions":
            return Optional.ofNullable(clazz.cast(actions()));
        case "MatchAttributes":
            return Optional.ofNullable(clazz.cast(matchAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Actions", ACTIONS_FIELD);
        map.put("MatchAttributes", MATCH_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuleGroupSourceStatelessRuleDefinition, T> g) {
        return obj -> g.apply((RuleGroupSourceStatelessRuleDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleGroupSourceStatelessRuleDefinition> {
        /**
         * <p>
         * The actions to take on a packet that matches one of the stateless rule definition's match attributes. You
         * must specify a standard action (<code>aws:pass</code>, <code>aws:drop</code>, or
         * <code>aws:forward_to_sfe</code>). You can then add custom actions.
         * </p>
         * 
         * @param actions
         *        The actions to take on a packet that matches one of the stateless rule definition's match attributes.
         *        You must specify a standard action (<code>aws:pass</code>, <code>aws:drop</code>, or
         *        <code>aws:forward_to_sfe</code>). You can then add custom actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Collection<String> actions);

        /**
         * <p>
         * The actions to take on a packet that matches one of the stateless rule definition's match attributes. You
         * must specify a standard action (<code>aws:pass</code>, <code>aws:drop</code>, or
         * <code>aws:forward_to_sfe</code>). You can then add custom actions.
         * </p>
         * 
         * @param actions
         *        The actions to take on a packet that matches one of the stateless rule definition's match attributes.
         *        You must specify a standard action (<code>aws:pass</code>, <code>aws:drop</code>, or
         *        <code>aws:forward_to_sfe</code>). You can then add custom actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(String... actions);

        /**
         * <p>
         * The criteria for Network Firewall to use to inspect an individual packet in a stateless rule inspection.
         * </p>
         * 
         * @param matchAttributes
         *        The criteria for Network Firewall to use to inspect an individual packet in a stateless rule
         *        inspection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchAttributes(RuleGroupSourceStatelessRuleMatchAttributes matchAttributes);

        /**
         * <p>
         * The criteria for Network Firewall to use to inspect an individual packet in a stateless rule inspection.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RuleGroupSourceStatelessRuleMatchAttributes.Builder} avoiding the need to create one manually via
         * {@link RuleGroupSourceStatelessRuleMatchAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuleGroupSourceStatelessRuleMatchAttributes.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #matchAttributes(RuleGroupSourceStatelessRuleMatchAttributes)}.
         * 
         * @param matchAttributes
         *        a consumer that will call methods on {@link RuleGroupSourceStatelessRuleMatchAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #matchAttributes(RuleGroupSourceStatelessRuleMatchAttributes)
         */
        default Builder matchAttributes(Consumer<RuleGroupSourceStatelessRuleMatchAttributes.Builder> matchAttributes) {
            return matchAttributes(RuleGroupSourceStatelessRuleMatchAttributes.builder().applyMutation(matchAttributes).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<String> actions = DefaultSdkAutoConstructList.getInstance();

        private RuleGroupSourceStatelessRuleMatchAttributes matchAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleGroupSourceStatelessRuleDefinition model) {
            actions(model.actions);
            matchAttributes(model.matchAttributes);
        }

        public final Collection<String> getActions() {
            if (actions instanceof SdkAutoConstructList) {
                return null;
            }
            return actions;
        }

        public final void setActions(Collection<String> actions) {
            this.actions = NonEmptyStringListCopier.copy(actions);
        }

        @Override
        public final Builder actions(Collection<String> actions) {
            this.actions = NonEmptyStringListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(String... actions) {
            actions(Arrays.asList(actions));
            return this;
        }

        public final RuleGroupSourceStatelessRuleMatchAttributes.Builder getMatchAttributes() {
            return matchAttributes != null ? matchAttributes.toBuilder() : null;
        }

        public final void setMatchAttributes(RuleGroupSourceStatelessRuleMatchAttributes.BuilderImpl matchAttributes) {
            this.matchAttributes = matchAttributes != null ? matchAttributes.build() : null;
        }

        @Override
        public final Builder matchAttributes(RuleGroupSourceStatelessRuleMatchAttributes matchAttributes) {
            this.matchAttributes = matchAttributes;
            return this;
        }

        @Override
        public RuleGroupSourceStatelessRuleDefinition build() {
            return new RuleGroupSourceStatelessRuleDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
