/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Stateful inspection criteria for a domain list rule group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleGroupSourceListDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<RuleGroupSourceListDetails.Builder, RuleGroupSourceListDetails> {
    private static final SdkField<String> GENERATED_RULES_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GeneratedRulesType").getter(getter(RuleGroupSourceListDetails::generatedRulesType))
            .setter(setter(Builder::generatedRulesType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeneratedRulesType").build())
            .build();

    private static final SdkField<List<String>> TARGET_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TargetTypes")
            .getter(getter(RuleGroupSourceListDetails::targetTypes))
            .setter(setter(Builder::targetTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> TARGETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Targets")
            .getter(getter(RuleGroupSourceListDetails::targets))
            .setter(setter(Builder::targets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Targets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GENERATED_RULES_TYPE_FIELD,
            TARGET_TYPES_FIELD, TARGETS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String generatedRulesType;

    private final List<String> targetTypes;

    private final List<String> targets;

    private RuleGroupSourceListDetails(BuilderImpl builder) {
        this.generatedRulesType = builder.generatedRulesType;
        this.targetTypes = builder.targetTypes;
        this.targets = builder.targets;
    }

    /**
     * <p>
     * Indicates whether to allow or deny access to the domains listed in <code>Targets</code>.
     * </p>
     * 
     * @return Indicates whether to allow or deny access to the domains listed in <code>Targets</code>.
     */
    public final String generatedRulesType() {
        return generatedRulesType;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTargetTypes() {
        return targetTypes != null && !(targetTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The protocols that you want to inspect. Specify <code>LS_SNI</code> for HTTPS. Specify <code>HTTP_HOST</code> for
     * HTTP. You can specify either or both.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetTypes} method.
     * </p>
     * 
     * @return The protocols that you want to inspect. Specify <code>LS_SNI</code> for HTTPS. Specify
     *         <code>HTTP_HOST</code> for HTTP. You can specify either or both.
     */
    public final List<String> targetTypes() {
        return targetTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Targets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTargets() {
        return targets != null && !(targets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The domains that you want to inspect for in your traffic flows. You can provide full domain names, or use the '.'
     * prefix as a wildcard. For example, <code>.example.com</code> matches all domains that end with
     * <code>example.com</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargets} method.
     * </p>
     * 
     * @return The domains that you want to inspect for in your traffic flows. You can provide full domain names, or use
     *         the '.' prefix as a wildcard. For example, <code>.example.com</code> matches all domains that end with
     *         <code>example.com</code>.
     */
    public final List<String> targets() {
        return targets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(generatedRulesType());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetTypes() ? targetTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTargets() ? targets() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleGroupSourceListDetails)) {
            return false;
        }
        RuleGroupSourceListDetails other = (RuleGroupSourceListDetails) obj;
        return Objects.equals(generatedRulesType(), other.generatedRulesType()) && hasTargetTypes() == other.hasTargetTypes()
                && Objects.equals(targetTypes(), other.targetTypes()) && hasTargets() == other.hasTargets()
                && Objects.equals(targets(), other.targets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleGroupSourceListDetails").add("GeneratedRulesType", generatedRulesType())
                .add("TargetTypes", hasTargetTypes() ? targetTypes() : null).add("Targets", hasTargets() ? targets() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GeneratedRulesType":
            return Optional.ofNullable(clazz.cast(generatedRulesType()));
        case "TargetTypes":
            return Optional.ofNullable(clazz.cast(targetTypes()));
        case "Targets":
            return Optional.ofNullable(clazz.cast(targets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GeneratedRulesType", GENERATED_RULES_TYPE_FIELD);
        map.put("TargetTypes", TARGET_TYPES_FIELD);
        map.put("Targets", TARGETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuleGroupSourceListDetails, T> g) {
        return obj -> g.apply((RuleGroupSourceListDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleGroupSourceListDetails> {
        /**
         * <p>
         * Indicates whether to allow or deny access to the domains listed in <code>Targets</code>.
         * </p>
         * 
         * @param generatedRulesType
         *        Indicates whether to allow or deny access to the domains listed in <code>Targets</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generatedRulesType(String generatedRulesType);

        /**
         * <p>
         * The protocols that you want to inspect. Specify <code>LS_SNI</code> for HTTPS. Specify <code>HTTP_HOST</code>
         * for HTTP. You can specify either or both.
         * </p>
         * 
         * @param targetTypes
         *        The protocols that you want to inspect. Specify <code>LS_SNI</code> for HTTPS. Specify
         *        <code>HTTP_HOST</code> for HTTP. You can specify either or both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetTypes(Collection<String> targetTypes);

        /**
         * <p>
         * The protocols that you want to inspect. Specify <code>LS_SNI</code> for HTTPS. Specify <code>HTTP_HOST</code>
         * for HTTP. You can specify either or both.
         * </p>
         * 
         * @param targetTypes
         *        The protocols that you want to inspect. Specify <code>LS_SNI</code> for HTTPS. Specify
         *        <code>HTTP_HOST</code> for HTTP. You can specify either or both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetTypes(String... targetTypes);

        /**
         * <p>
         * The domains that you want to inspect for in your traffic flows. You can provide full domain names, or use the
         * '.' prefix as a wildcard. For example, <code>.example.com</code> matches all domains that end with
         * <code>example.com</code>.
         * </p>
         * 
         * @param targets
         *        The domains that you want to inspect for in your traffic flows. You can provide full domain names, or
         *        use the '.' prefix as a wildcard. For example, <code>.example.com</code> matches all domains that end
         *        with <code>example.com</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Collection<String> targets);

        /**
         * <p>
         * The domains that you want to inspect for in your traffic flows. You can provide full domain names, or use the
         * '.' prefix as a wildcard. For example, <code>.example.com</code> matches all domains that end with
         * <code>example.com</code>.
         * </p>
         * 
         * @param targets
         *        The domains that you want to inspect for in your traffic flows. You can provide full domain names, or
         *        use the '.' prefix as a wildcard. For example, <code>.example.com</code> matches all domains that end
         *        with <code>example.com</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(String... targets);
    }

    static final class BuilderImpl implements Builder {
        private String generatedRulesType;

        private List<String> targetTypes = DefaultSdkAutoConstructList.getInstance();

        private List<String> targets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RuleGroupSourceListDetails model) {
            generatedRulesType(model.generatedRulesType);
            targetTypes(model.targetTypes);
            targets(model.targets);
        }

        public final String getGeneratedRulesType() {
            return generatedRulesType;
        }

        public final void setGeneratedRulesType(String generatedRulesType) {
            this.generatedRulesType = generatedRulesType;
        }

        @Override
        public final Builder generatedRulesType(String generatedRulesType) {
            this.generatedRulesType = generatedRulesType;
            return this;
        }

        public final Collection<String> getTargetTypes() {
            if (targetTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return targetTypes;
        }

        public final void setTargetTypes(Collection<String> targetTypes) {
            this.targetTypes = NonEmptyStringListCopier.copy(targetTypes);
        }

        @Override
        public final Builder targetTypes(Collection<String> targetTypes) {
            this.targetTypes = NonEmptyStringListCopier.copy(targetTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetTypes(String... targetTypes) {
            targetTypes(Arrays.asList(targetTypes));
            return this;
        }

        public final Collection<String> getTargets() {
            if (targets instanceof SdkAutoConstructList) {
                return null;
            }
            return targets;
        }

        public final void setTargets(Collection<String> targets) {
            this.targets = NonEmptyStringListCopier.copy(targets);
        }

        @Override
        public final Builder targets(Collection<String> targets) {
            this.targets = NonEmptyStringListCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(String... targets) {
            targets(Arrays.asList(targets));
            return this;
        }

        @Override
        public RuleGroupSourceListDetails build() {
            return new RuleGroupSourceListDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
