/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the resource trend metrics data for a specific time point in the requested time period.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourcesTrendsMetricsResult implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourcesTrendsMetricsResult.Builder, ResourcesTrendsMetricsResult> {
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("Timestamp")
            .getter(getter(ResourcesTrendsMetricsResult::timestamp))
            .setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<ResourcesTrendsValues> TRENDS_VALUES_FIELD = SdkField
            .<ResourcesTrendsValues> builder(MarshallingType.SDK_POJO).memberName("TrendsValues")
            .getter(getter(ResourcesTrendsMetricsResult::trendsValues)).setter(setter(Builder::trendsValues))
            .constructor(ResourcesTrendsValues::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrendsValues").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMESTAMP_FIELD,
            TRENDS_VALUES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant timestamp;

    private final ResourcesTrendsValues trendsValues;

    private ResourcesTrendsMetricsResult(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.trendsValues = builder.trendsValues;
    }

    /**
     * <p>
     * The timestamp for this data point in the resources trend metrics.
     * </p>
     * 
     * @return The timestamp for this data point in the resources trend metrics.
     */
    public final Instant timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * The resource trend metric values associated with this timestamp, including resource counts.
     * </p>
     * 
     * @return The resource trend metric values associated with this timestamp, including resource counts.
     */
    public final ResourcesTrendsValues trendsValues() {
        return trendsValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(trendsValues());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourcesTrendsMetricsResult)) {
            return false;
        }
        ResourcesTrendsMetricsResult other = (ResourcesTrendsMetricsResult) obj;
        return Objects.equals(timestamp(), other.timestamp()) && Objects.equals(trendsValues(), other.trendsValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourcesTrendsMetricsResult").add("Timestamp", timestamp()).add("TrendsValues", trendsValues())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "TrendsValues":
            return Optional.ofNullable(clazz.cast(trendsValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Timestamp", TIMESTAMP_FIELD);
        map.put("TrendsValues", TRENDS_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourcesTrendsMetricsResult, T> g) {
        return obj -> g.apply((ResourcesTrendsMetricsResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourcesTrendsMetricsResult> {
        /**
         * <p>
         * The timestamp for this data point in the resources trend metrics.
         * </p>
         * 
         * @param timestamp
         *        The timestamp for this data point in the resources trend metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);

        /**
         * <p>
         * The resource trend metric values associated with this timestamp, including resource counts.
         * </p>
         * 
         * @param trendsValues
         *        The resource trend metric values associated with this timestamp, including resource counts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trendsValues(ResourcesTrendsValues trendsValues);

        /**
         * <p>
         * The resource trend metric values associated with this timestamp, including resource counts.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourcesTrendsValues.Builder} avoiding
         * the need to create one manually via {@link ResourcesTrendsValues#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourcesTrendsValues.Builder#build()} is called immediately and
         * its result is passed to {@link #trendsValues(ResourcesTrendsValues)}.
         * 
         * @param trendsValues
         *        a consumer that will call methods on {@link ResourcesTrendsValues.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trendsValues(ResourcesTrendsValues)
         */
        default Builder trendsValues(Consumer<ResourcesTrendsValues.Builder> trendsValues) {
            return trendsValues(ResourcesTrendsValues.builder().applyMutation(trendsValues).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Instant timestamp;

        private ResourcesTrendsValues trendsValues;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourcesTrendsMetricsResult model) {
            timestamp(model.timestamp);
            trendsValues(model.trendsValues);
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final ResourcesTrendsValues.Builder getTrendsValues() {
            return trendsValues != null ? trendsValues.toBuilder() : null;
        }

        public final void setTrendsValues(ResourcesTrendsValues.BuilderImpl trendsValues) {
            this.trendsValues = trendsValues != null ? trendsValues.build() : null;
        }

        @Override
        public final Builder trendsValues(ResourcesTrendsValues trendsValues) {
            this.trendsValues = trendsValues;
            return this;
        }

        @Override
        public ResourcesTrendsMetricsResult build() {
            return new ResourcesTrendsMetricsResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
