/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Enables filtering of Amazon Web Services resources based on key-value map attributes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourcesMapFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourcesMapFilter.Builder, ResourcesMapFilter> {
    private static final SdkField<String> FIELD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FieldName").getter(getter(ResourcesMapFilter::fieldNameAsString)).setter(setter(Builder::fieldName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldName").build()).build();

    private static final SdkField<MapFilter> FILTER_FIELD = SdkField.<MapFilter> builder(MarshallingType.SDK_POJO)
            .memberName("Filter").getter(getter(ResourcesMapFilter::filter)).setter(setter(Builder::filter))
            .constructor(MapFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(FIELD_NAME_FIELD, FILTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String fieldName;

    private final MapFilter filter;

    private ResourcesMapFilter(BuilderImpl builder) {
        this.fieldName = builder.fieldName;
        this.filter = builder.filter;
    }

    /**
     * <p>
     * The name of the field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fieldName} will
     * return {@link ResourcesMapField#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fieldNameAsString}.
     * </p>
     * 
     * @return The name of the field.
     * @see ResourcesMapField
     */
    public final ResourcesMapField fieldName() {
        return ResourcesMapField.fromValue(fieldName);
    }

    /**
     * <p>
     * The name of the field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fieldName} will
     * return {@link ResourcesMapField#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fieldNameAsString}.
     * </p>
     * 
     * @return The name of the field.
     * @see ResourcesMapField
     */
    public final String fieldNameAsString() {
        return fieldName;
    }

    /**
     * Returns the value of the Filter property for this object.
     * 
     * @return The value of the Filter property for this object.
     */
    public final MapFilter filter() {
        return filter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourcesMapFilter)) {
            return false;
        }
        ResourcesMapFilter other = (ResourcesMapFilter) obj;
        return Objects.equals(fieldNameAsString(), other.fieldNameAsString()) && Objects.equals(filter(), other.filter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourcesMapFilter").add("FieldName", fieldNameAsString()).add("Filter", filter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldName":
            return Optional.ofNullable(clazz.cast(fieldNameAsString()));
        case "Filter":
            return Optional.ofNullable(clazz.cast(filter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FieldName", FIELD_NAME_FIELD);
        map.put("Filter", FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourcesMapFilter, T> g) {
        return obj -> g.apply((ResourcesMapFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourcesMapFilter> {
        /**
         * <p>
         * The name of the field.
         * </p>
         * 
         * @param fieldName
         *        The name of the field.
         * @see ResourcesMapField
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourcesMapField
         */
        Builder fieldName(String fieldName);

        /**
         * <p>
         * The name of the field.
         * </p>
         * 
         * @param fieldName
         *        The name of the field.
         * @see ResourcesMapField
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourcesMapField
         */
        Builder fieldName(ResourcesMapField fieldName);

        /**
         * Sets the value of the Filter property for this object.
         *
         * @param filter
         *        The new value for the Filter property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(MapFilter filter);

        /**
         * Sets the value of the Filter property for this object.
         *
         * This is a convenience method that creates an instance of the {@link MapFilter.Builder} avoiding the need to
         * create one manually via {@link MapFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MapFilter.Builder#build()} is called immediately and its result
         * is passed to {@link #filter(MapFilter)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link MapFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(MapFilter)
         */
        default Builder filter(Consumer<MapFilter.Builder> filter) {
            return filter(MapFilter.builder().applyMutation(filter).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String fieldName;

        private MapFilter filter;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourcesMapFilter model) {
            fieldName(model.fieldName);
            filter(model.filter);
        }

        public final String getFieldName() {
            return fieldName;
        }

        public final void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public final Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        @Override
        public final Builder fieldName(ResourcesMapField fieldName) {
            this.fieldName(fieldName == null ? null : fieldName.toString());
            return this;
        }

        public final MapFilter.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        public final void setFilter(MapFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(MapFilter filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public ResourcesMapFilter build() {
            return new ResourcesMapFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
